/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.dynamicinclude.impl;

import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.dynamicinclude.Configuration;

public final class UrlBuilder {
    public static String buildUrl(String includeSelector, String resourceType, boolean synthetic, Configuration config, RequestPathInfo pathInfo) {
        StringBuilder builder = new StringBuilder();
        String resourcePath = pathInfo.getResourcePath();
        builder.append(resourcePath);
        String currentSelectorString = StringUtils.defaultString((String)pathInfo.getSelectorString());
        if (pathInfo.getSelectorString() != null) {
            builder.append('.').append(currentSelectorString);
        }
        if (UrlBuilder.includeSelectorNotAlreadyPresent(pathInfo.getSelectors(), includeSelector)) {
            builder.append('.').append(includeSelector);
        }
        builder.append('.').append(pathInfo.getExtension());
        if (synthetic) {
            builder.append('/').append(resourceType);
            if (config.hasExtensionSet()) {
                builder.append('.').append(config.getExtension());
            }
        } else {
            builder.append(StringUtils.defaultString((String)pathInfo.getSuffix()));
        }
        return builder.toString();
    }

    private static boolean includeSelectorNotAlreadyPresent(String[] currentSelectors, String includeSelector) {
        return !Arrays.asList(currentSelectors).contains(includeSelector);
    }
}

