/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.its;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.sling.commons.testing.junit.categories.Slow;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyEventListener;
import org.apache.sling.discovery.TopologyView;
import org.apache.sling.discovery.base.its.setup.VirtualInstance;
import org.apache.sling.discovery.base.its.setup.VirtualInstanceBuilder;
import org.apache.sling.testing.tools.retry.RetryLoop;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDiscoveryServiceTest {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    List<Tester> testers = new LinkedList<Tester>();

    public abstract VirtualInstanceBuilder newBuilder();

    @Before
    public void setUp() throws Exception {
        this.testers.clear();
    }

    @After
    public void tearDown() throws Exception {
        for (Tester tester : this.testers) {
            tester.shutdown();
        }
    }

    Tester newInstance(String debugName, int interval, int timeout, long pollingSleep, VirtualInstance base) throws Throwable {
        VirtualInstanceBuilder builder = this.newBuilder();
        builder.setDebugName(debugName);
        if (base == null) {
            builder.newRepository("/var/discovery/testing/", true);
        } else {
            builder.useRepositoryOf(base);
        }
        builder.setConnectorPingInterval(interval);
        builder.setConnectorPingTimeout(timeout);
        builder.setMinEventDelay(1);
        VirtualInstance instance = builder.build();
        Tester t = new Tester(instance, pollingSleep);
        this.testers.add(t);
        instance.startViewChecker(interval);
        return t;
    }

    private void assertStableTopology(Tester ... instances) {
        for (Tester tester : instances) {
            this.logger.info("asserting tester: " + tester.instance.getDebugName());
            TopologyEvent lastEvent = tester.previousEvent;
            TopologyEvent.Type type = lastEvent.getType();
            if (type != TopologyEvent.Type.TOPOLOGY_CHANGED && type != TopologyEvent.Type.TOPOLOGY_INIT) {
                Assert.fail((String)("wrong type, expected CHANGED or INIT, got: " + type));
            }
            Assert.assertNotNull((Object)lastEvent.getNewView());
            Assert.assertEquals((long)instances.length, (long)lastEvent.getNewView().getInstances().size());
            TopologyView t = tester.instance.getDiscoveryService().getTopology();
            Assert.assertTrue((boolean)t.isCurrent());
            Assert.assertEquals((long)instances.length, (long)t.getInstances().size());
        }
    }

    private boolean isStableTopology(Tester ... instances) {
        for (Tester tester : instances) {
            TopologyEvent lastEvent = tester.previousEvent;
            if (lastEvent == null) {
                return false;
            }
            TopologyEvent.Type type = lastEvent.getType();
            if (type != TopologyEvent.Type.TOPOLOGY_CHANGED && type != TopologyEvent.Type.TOPOLOGY_INIT) {
                return false;
            }
            TopologyView newView = lastEvent.getNewView();
            if (newView == null) {
                return false;
            }
            if (instances.length != newView.getInstances().size()) {
                return false;
            }
            TopologyView t = tester.instance.getDiscoveryService().getTopology();
            if (!t.isCurrent()) {
                return false;
            }
            if (instances.length != t.getInstances().size()) {
                return false;
            }
            for (Tester t2 : instances) {
                boolean foundMatch = false;
                for (InstanceDescription id : t.getInstances()) {
                    if (!t2.instance.getSlingId().equals(id.getSlingId())) continue;
                    foundMatch = true;
                    break;
                }
                if (foundMatch) continue;
                return false;
            }
        }
        return true;
    }

    @Test
    public void testSingleInstance() throws Throwable {
        this.logger.info("testSingleInstances: start");
        Tester single = this.newInstance("single", 1, 5, 50L, null);
        single.instance.dumpRepo();
        this.logger.info("testSingleInstances: starting retry loop (10sec max)");
        this.startRetryLoop(this.testers, 10);
        single.assertNoFailures();
        this.assertStableTopology(single);
        this.logger.info("testSingleInstances: end");
    }

    @Test
    public void testTwoInstances() throws Throwable {
        this.logger.info("testTwoInstances: start");
        Tester i1 = this.newInstance("i1", 1, 10, 100L, null);
        Tester i2 = this.newInstance("i2", 1, 10, 100L, i1.instance);
        this.logger.info("testTwoInstances: starting retry loop (15sec max)");
        this.startRetryLoop(this.testers, 15);
        i1.instance.dumpRepo();
        i1.assertNoFailures();
        i2.assertNoFailures();
        this.assertStableTopology(i1, i2);
        this.logger.info("testTwoInstances: end");
    }

    @Test
    public void testFiveInstances() throws Throwable {
        this.logger.info("testFiveInstances: start");
        Tester i1 = this.newInstance("i1", 1, 30, 250L, null);
        for (int i = 2; i <= 5; ++i) {
            Tester tester = this.newInstance("i" + i, 1, 30, 250L, i1.instance);
        }
        this.logger.info("testFiveInstances: starting retry loop (40sec max)");
        this.startRetryLoop(this.testers, 40);
        i1.instance.dumpRepo();
        i1.assertNoFailures();
        this.assertStableTopology(this.testers.toArray(new Tester[0]));
        this.logger.info("testFiveInstances: end");
    }

    @Category(value={Slow.class})
    @Test
    public void testTenInstances() throws Throwable {
        this.logger.info("testTenInstances: start");
        Tester i1 = this.newInstance("i1", 1, 30, 250L, null);
        for (int i = 2; i <= 10; ++i) {
            Tester tester = this.newInstance("i" + i, 1, 30, 250L, i1.instance);
        }
        this.logger.info("testTenInstances: starting retry loop (60sec max)");
        this.startRetryLoop(this.testers, 60);
        i1.instance.dumpRepo();
        i1.assertNoFailures();
        this.assertStableTopology(this.testers.toArray(new Tester[0]));
        this.logger.info("testTenInstances: end");
    }

    @Category(value={Slow.class})
    @Test
    public void testTwentyInstances() throws Throwable {
        this.logger.info("testTwentyInstances: start");
        Tester i1 = this.newInstance("i1", 1, 60, 1000L, null);
        for (int i = 2; i <= 20; ++i) {
            Tester tester = this.newInstance("i" + i, 1, 60, 1000L, i1.instance);
        }
        this.logger.info("testThirtyInstances: starting retry loop (80 sec max)");
        this.startRetryLoop(this.testers, 80);
        i1.instance.dumpRepo();
        i1.assertNoFailures();
        this.assertStableTopology(this.testers.toArray(new Tester[0]));
        this.logger.info("testTwentyInstances: end");
    }

    @Category(value={Slow.class})
    @Test
    public void testTwentyFourInstances() throws Throwable {
        this.logger.info("testTwentyFourInstances: start");
        Tester i1 = this.newInstance("i1", 4, 120, 1000L, null);
        for (int i = 2; i <= 24; ++i) {
            Tester in = this.newInstance("i" + i, 4, 120, 2000L, i1.instance);
            Thread.sleep(1000L);
        }
        this.logger.info("testTwentyFourInstances: starting retry loop (180sec max)");
        this.startRetryLoop(this.testers, 180);
        i1.instance.dumpRepo();
        i1.assertNoFailures();
        this.assertStableTopology(this.testers.toArray(new Tester[0]));
        this.logger.info("testTwentyFourInstances: end");
    }

    private void startRetryLoop(List<Tester> testers, int retryTimeoutSeconds) {
        this.startRetryLoop(retryTimeoutSeconds, testers.toArray(new Tester[0]));
    }

    private void startRetryLoop(int retryTimeoutSeconds, final Tester ... testers) {
        new RetryLoop(new RetryLoop.Condition(){

            public String getDescription() {
                return null;
            }

            public boolean isTrue() throws Exception {
                if (!AbstractDiscoveryServiceTest.this.isStableTopology(testers)) {
                    return false;
                }
                for (Tester tester : testers) {
                    tester.assertNoFailures();
                }
                AbstractDiscoveryServiceTest.this.logger.info("retryLoop: declaring stable topology with " + testers.length);
                return true;
            }
        }, retryTimeoutSeconds, 1000);
    }

    @Category(value={Slow.class})
    @Test
    public void testStartStopFiesta() throws Throwable {
        Tester[] instances = new Tester[8];
        instances[0] = this.newInstance("i1", 1, 10, 1000L, null);
        for (int i = 2; i <= 8; ++i) {
            instances[i - 1] = this.newInstance("i" + i, 1, 10, 1000L, instances[0].instance);
            Thread.sleep(600L);
        }
        this.startRetryLoop(15, instances);
        for (Tester tester : instances) {
            tester.assertNoFailures();
        }
        this.assertStableTopology(this.testers.toArray(new Tester[0]));
        Random r = new Random(123432141L);
        for (int i = 0; i < 10; ++i) {
            this.logger.info("testStartStopFiesta : loop " + i);
            LinkedList<Tester> alive = new LinkedList<Tester>();
            int keepAlive = r.nextInt(instances.length);
            for (int j = 0; j < instances.length; ++j) {
                if (j == keepAlive || r.nextBoolean()) {
                    instances[j].restart();
                    alive.add(instances[j]);
                    continue;
                }
                instances[j].pause();
            }
            this.logger.info("testStartStopFiesta : loop " + i + ", alive-cnt: " + alive.size());
            this.startRetryLoop(alive, 30);
            for (Tester tester : instances) {
                tester.assertNoFailures();
            }
            this.assertStableTopology(alive.toArray(new Tester[0]));
        }
    }

    class Tester
    implements TopologyEventListener,
    Runnable {
        private final VirtualInstance instance;
        private final Thread thread;
        private TopologyEvent previousEvent;
        private List<String> failures = new LinkedList<String>();
        private volatile boolean stopped = false;
        private final long pollingSleep;
        private boolean running = true;

        Tester(VirtualInstance instance, long pollingSleep) throws Throwable {
            this.instance = instance;
            this.pollingSleep = pollingSleep;
            instance.bindTopologyEventListener(this);
            this.thread = new Thread(this);
            this.thread.setName("Tester-" + instance.getDebugName() + "-thread");
            this.thread.setDaemon(true);
            this.thread.start();
        }

        private synchronized void assertNoFailures() {
            if (this.failures.size() == 0) {
                return;
            }
            Assert.fail((String)("got " + this.failures.size() + " failures, the first one thereof: " + this.failures.get(0)));
        }

        private synchronized boolean hasFailures() {
            return this.failures.size() != 0;
        }

        private synchronized void asyncFail(String msg) {
            this.failures.add(msg);
        }

        @Override
        public void run() {
            while (!this.stopped) {
                try {
                    TopologyView topo = this.instance.getDiscoveryService().getTopology();
                    Thread.sleep(this.pollingSleep);
                }
                catch (Throwable th) {
                    this.asyncFail("Got a Throwable: " + th);
                    return;
                }
            }
        }

        public void handleTopologyEvent(TopologyEvent event) {
            if (this.hasFailures()) {
                return;
            }
            AbstractDiscoveryServiceTest.this.logger.info("handleTopologyEvent[" + this.instance.getDebugName() + "]: " + event);
            if (this.previousEvent == null) {
                if (event.getType() != TopologyEvent.Type.TOPOLOGY_INIT) {
                    this.asyncFail("expected an INIT as the first, but got: " + event);
                    return;
                }
            } else if (this.previousEvent.getType() == TopologyEvent.Type.TOPOLOGY_CHANGED || this.previousEvent.getType() == TopologyEvent.Type.PROPERTIES_CHANGED) {
                if (event.getType() != TopologyEvent.Type.TOPOLOGY_CHANGING && event.getType() != TopologyEvent.Type.PROPERTIES_CHANGED) {
                    this.asyncFail("expected a CHANGING or PROPERTIES_CHANGED, but got: " + event);
                    return;
                }
            } else if (this.previousEvent.getType() == TopologyEvent.Type.TOPOLOGY_CHANGING && event.getType() != TopologyEvent.Type.TOPOLOGY_CHANGED) {
                this.asyncFail("expected a CHANGED after CHANGING, but got: " + event);
                return;
            }
            this.previousEvent = event;
        }

        public void shutdown() throws Exception {
            this.stopped = true;
            this.instance.stop();
            this.running = false;
        }

        public void restart() throws Exception {
            this.instance.startViewChecker((int)this.instance.getConfig().getConnectorPingInterval());
            this.running = true;
        }

        public void pause() throws Throwable {
            this.instance.stopViewChecker();
            this.running = false;
        }
    }
}

