/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.its;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import org.apache.log4j.Level;
import org.apache.log4j.spi.RootLogger;
import org.apache.sling.commons.testing.junit.categories.Slow;
import org.apache.sling.discovery.ClusterView;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyEventListener;
import org.apache.sling.discovery.TopologyView;
import org.apache.sling.discovery.base.commons.ClusterViewHelper;
import org.apache.sling.discovery.base.commons.ClusterViewService;
import org.apache.sling.discovery.base.commons.UndefinedClusterViewException;
import org.apache.sling.discovery.base.connectors.announcement.Announcement;
import org.apache.sling.discovery.base.connectors.announcement.AnnouncementFilter;
import org.apache.sling.discovery.base.connectors.announcement.AnnouncementRegistry;
import org.apache.sling.discovery.base.its.setup.VirtualInstance;
import org.apache.sling.discovery.base.its.setup.VirtualInstanceBuilder;
import org.apache.sling.discovery.base.its.setup.mock.AcceptsMultiple;
import org.apache.sling.discovery.base.its.setup.mock.AssertingTopologyEventListener;
import org.apache.sling.discovery.base.its.setup.mock.PropertyProviderImpl;
import org.apache.sling.discovery.commons.providers.spi.LocalClusterView;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClusterTest {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    VirtualInstance instance1;
    VirtualInstance instance2;
    VirtualInstance instance3;
    private String property1Value;
    protected String property2Value;
    private String property1Name;
    private String property2Name;
    VirtualInstance instance4;
    VirtualInstance instance5;
    VirtualInstance instance1Restarted;
    private Level logLevel;

    protected abstract VirtualInstanceBuilder newBuilder();

    @Before
    public void setup() throws Exception {
        org.apache.log4j.Logger discoveryLogger = RootLogger.getLogger((String)"org.apache.sling.discovery");
        this.logLevel = discoveryLogger.getLevel();
        discoveryLogger.setLevel(Level.TRACE);
        this.logger.debug("here we are");
        this.instance1 = this.newBuilder().setDebugName("firstInstance").newRepository("/var/discovery/impl/", true).build();
        this.instance2 = this.newBuilder().setDebugName("secondInstance").useRepositoryOf(this.instance1).build();
    }

    @After
    public void tearDown() throws Exception {
        if (this.instance5 != null) {
            this.instance5.stop();
        }
        if (this.instance4 != null) {
            this.instance4.stop();
        }
        if (this.instance3 != null) {
            this.instance3.stop();
        }
        if (this.instance3 != null) {
            this.instance3.stop();
        }
        if (this.instance2 != null) {
            this.instance2.stop();
        }
        if (this.instance1 != null) {
            this.instance1.stop();
        }
        if (this.instance1Restarted != null) {
            this.instance1Restarted.stop();
        }
        this.instance1Restarted = null;
        this.instance1 = null;
        this.instance2 = null;
        this.instance3 = null;
        this.instance4 = null;
        this.instance5 = null;
        org.apache.log4j.Logger discoveryLogger = RootLogger.getLogger((String)"org.apache.sling.discovery");
        discoveryLogger.setLevel(this.logLevel);
    }

    @Test
    public void testLeaderAsc() throws Throwable {
        this.logger.info("testLeaderAsc: start");
        this.doTestLeader("000", "111");
        this.logger.info("testLeaderAsc: end");
    }

    @Test
    public void testLeaderDesc() throws Throwable {
        this.logger.info("testLeaderDesc: start");
        this.doTestLeader("111", "000");
        this.logger.info("testLeaderDesc: end");
    }

    private void doTestLeader(String slingId1, String slingId2) throws Throwable {
        this.logger.info("doTestLeader(" + slingId1 + "," + slingId2 + "): start");
        this.instance2.stopViewChecker();
        this.instance1.stopViewChecker();
        this.instance2.stop();
        this.instance1.stop();
        this.instance1 = this.newBuilder().setDebugName("firstInstance").newRepository("/var/discovery/impl/", true).setConnectorPingTimeout(30).setMinEventDelay(1).setSlingId(slingId1).build();
        this.logger.info("doTestLeader: 1st sleep 200ms");
        Thread.sleep(200L);
        this.instance2 = this.newBuilder().setDebugName("secondInstance").useRepositoryOf(this.instance1).setConnectorPingTimeout(30).setMinEventDelay(1).setSlingId(slingId2).build();
        Assert.assertNotNull((Object)this.instance1);
        Assert.assertNotNull((Object)this.instance2);
        try {
            this.instance1.getClusterViewService().getLocalClusterView();
            Assert.fail((String)"should complain");
        }
        catch (UndefinedClusterViewException undefinedClusterViewException) {
            // empty catch block
        }
        try {
            this.instance2.getClusterViewService().getLocalClusterView();
            Assert.fail((String)"should complain");
        }
        catch (UndefinedClusterViewException undefinedClusterViewException) {
            // empty catch block
        }
        for (int m = 0; m < 4; ++m) {
            this.instance1.heartbeatsAndCheckView();
            this.instance2.heartbeatsAndCheckView();
            this.logger.info("doTestLeader: sleep 500ms");
            Thread.sleep(500L);
        }
        this.instance1.heartbeatsAndCheckView();
        this.instance2.heartbeatsAndCheckView();
        Assert.assertEquals((long)2L, (long)this.instance1.getClusterViewService().getLocalClusterView().getInstances().size());
        Assert.assertEquals((long)2L, (long)this.instance2.getClusterViewService().getLocalClusterView().getInstances().size());
        Assert.assertTrue((boolean)this.instance1.getLocalInstanceDescription().isLeader());
        Assert.assertFalse((boolean)this.instance2.getLocalInstanceDescription().isLeader());
        this.logger.info("doTestLeader(" + slingId1 + "," + slingId2 + "): end");
    }

    @Test
    public void testStaleAnnouncementsVisibleToClusterPeers4139() throws Throwable {
        this.logger.info("testStaleAnnouncementsVisibleToClusterPeers4139: start");
        String instance1SlingId = this.prepare4139();
        this.instance1Restarted = this.newBuilder().setDebugName("firstInstance").useRepositoryOf(this.instance2).setConnectorPingTimeout(Integer.MAX_VALUE).setMinEventDelay(1).setSlingId(instance1SlingId).build();
        this.runHeartbeatOnceWith(this.instance1Restarted, this.instance2, this.instance3);
        Thread.sleep(500L);
        this.runHeartbeatOnceWith(this.instance1Restarted, this.instance2, this.instance3);
        Thread.sleep(500L);
        this.runHeartbeatOnceWith(this.instance1Restarted, this.instance2, this.instance3);
        this.logger.info("instance1Restarted.dump: " + this.instance1Restarted.slingId);
        this.instance1Restarted.dumpRepo();
        this.logger.info("instance2.dump: " + this.instance2.slingId);
        this.instance2.dumpRepo();
        this.logger.info("instance3.dump: " + this.instance3.slingId);
        this.instance3.dumpRepo();
        this.assertTopology(this.instance1Restarted, new SimpleClusterView(this.instance1Restarted, this.instance2));
        this.assertTopology(this.instance3, new SimpleClusterView(this.instance3));
        this.assertTopology(this.instance2, new SimpleClusterView(this.instance1Restarted, this.instance2));
        this.instance1Restarted.stop();
        this.logger.info("testStaleAnnouncementsVisibleToClusterPeers4139: end");
    }

    @Test
    public void testDuplicateInstanceIn2Clusters4139() throws Throwable {
        this.logger.info("testDuplicateInstanceIn2Clusters4139: start");
        String instance1SlingId = this.prepare4139();
        this.pingConnector(this.instance3, this.instance2);
        this.instance1Restarted = this.newBuilder().setDebugName("firstInstance").useRepositoryOf(this.instance2).setConnectorPingTimeout(Integer.MAX_VALUE).setMinEventDelay(1).setSlingId(instance1SlingId).build();
        this.runHeartbeatOnceWith(this.instance1Restarted, this.instance2, this.instance3);
        this.pingConnector(this.instance3, this.instance2);
        this.runHeartbeatOnceWith(this.instance1Restarted, this.instance2, this.instance3);
        this.pingConnector(this.instance3, this.instance2);
        this.logger.info("iteration 0");
        this.logger.info("instance1Restarted.slingId: " + this.instance1Restarted.slingId);
        this.logger.info("instance2.slingId: " + this.instance2.slingId);
        this.logger.info("instance3.slingId: " + this.instance3.slingId);
        this.instance1Restarted.dumpRepo();
        this.assertSameTopology(new SimpleClusterView(this.instance1Restarted, this.instance2), new SimpleClusterView(this.instance3));
        Thread.sleep(500L);
        this.runHeartbeatOnceWith(this.instance1Restarted, this.instance2, this.instance3);
        this.pingConnector(this.instance3, this.instance2);
        this.runHeartbeatOnceWith(this.instance1Restarted, this.instance2, this.instance3);
        this.pingConnector(this.instance3, this.instance2);
        this.logger.info("iteration 1");
        this.logger.info("instance1Restarted.slingId: " + this.instance1Restarted.slingId);
        this.logger.info("instance2.slingId: " + this.instance2.slingId);
        this.logger.info("instance3.slingId: " + this.instance3.slingId);
        this.instance1Restarted.dumpRepo();
        this.assertSameTopology(new SimpleClusterView(this.instance1Restarted, this.instance2), new SimpleClusterView(this.instance3));
        this.instance1Restarted.stop();
        this.logger.info("testDuplicateInstanceIn2Clusters4139: end");
    }

    @Category(value={Slow.class})
    @Test
    public void testConnectorSwitching4139() throws Throwable {
        int i;
        boolean MIN_EVENT_DELAY = true;
        this.tearDown();
        org.apache.log4j.Logger discoveryLogger = RootLogger.getLogger((String)"org.apache.sling.discovery");
        this.logLevel = discoveryLogger.getLevel();
        discoveryLogger.setLevel(Level.DEBUG);
        this.instance1 = this.newBuilder().setDebugName("instance1").newRepository("/var/discovery/clusterA/", true).setConnectorPingTimeout(10).setConnectorPingInterval(999).setMinEventDelay(1).build();
        this.instance2 = this.newBuilder().setDebugName("instance2").useRepositoryOf(this.instance1).setConnectorPingTimeout(10).setConnectorPingInterval(999).setMinEventDelay(1).build();
        this.instance3 = this.newBuilder().setDebugName("instance3").newRepository("/var/discovery/clusterB/", false).setConnectorPingTimeout(10).setConnectorPingInterval(999).setMinEventDelay(1).build();
        this.instance4 = this.newBuilder().setDebugName("instance4").useRepositoryOf(this.instance3).setConnectorPingTimeout(10).setConnectorPingInterval(999).setMinEventDelay(1).build();
        this.instance5 = this.newBuilder().setDebugName("instance5").newRepository("/var/discovery/clusterC/", false).setConnectorPingTimeout(10).setConnectorPingInterval(999).setMinEventDelay(1).build();
        this.runHeartbeatOnceWith(this.instance1, this.instance2, this.instance3, this.instance4, this.instance5);
        Thread.sleep(500L);
        this.runHeartbeatOnceWith(this.instance1, this.instance2, this.instance3, this.instance4, this.instance5);
        Thread.sleep(500L);
        this.runHeartbeatOnceWith(this.instance1, this.instance2, this.instance3, this.instance4, this.instance5);
        Thread.sleep(500L);
        this.assertSameTopology(new SimpleClusterView(this.instance1, this.instance2));
        this.assertSameTopology(new SimpleClusterView(this.instance3, this.instance4));
        this.assertSameTopology(new SimpleClusterView(this.instance5));
        this.runHeartbeatOnceWith(this.instance1, this.instance2, this.instance3, this.instance4, this.instance5);
        this.pingConnector(this.instance3, this.instance1);
        this.pingConnector(this.instance5, this.instance1);
        Thread.sleep(500L);
        this.runHeartbeatOnceWith(this.instance1, this.instance2, this.instance3, this.instance4, this.instance5);
        this.pingConnector(this.instance3, this.instance1);
        this.pingConnector(this.instance5, this.instance1);
        Thread.sleep(500L);
        this.logger.info("testConnectorSwitching4139: instance1.slingId=" + this.instance1.slingId);
        this.logger.info("testConnectorSwitching4139: instance2.slingId=" + this.instance2.slingId);
        this.logger.info("testConnectorSwitching4139: instance3.slingId=" + this.instance3.slingId);
        this.logger.info("testConnectorSwitching4139: instance4.slingId=" + this.instance4.slingId);
        this.logger.info("testConnectorSwitching4139: instance5.slingId=" + this.instance5.slingId);
        this.instance1.dumpRepo();
        this.assertSameTopology(new SimpleClusterView(this.instance1, this.instance2), new SimpleClusterView(this.instance3, this.instance4), new SimpleClusterView(this.instance5));
        boolean success = false;
        for (i = 0; i < 25; ++i) {
            this.runHeartbeatOnceWith(this.instance2, this.instance3, this.instance4, this.instance5);
            boolean ping1 = this.pingConnector(this.instance3, this.instance2);
            boolean ping2 = this.pingConnector(this.instance5, this.instance2);
            if (ping1 && ping2) {
                success = true;
                this.logger.info("testConnectorSwitching4139: successfully switched all pings to instance2 after " + i + " rounds.");
                if (i >= 20) break;
                this.logger.info("testConnectorSwitching4139: min loop cnt not yet reached: i=" + i);
                Thread.sleep(1000L);
                continue;
            }
            this.logger.info("testConnectorSwitching4139: looping cos ping1=" + ping1 + ", ping2=" + ping2);
            Thread.sleep(1000L);
        }
        Assert.assertTrue((boolean)success);
        this.runHeartbeatOnceWith(this.instance2, this.instance3, this.instance4, this.instance5);
        Assert.assertTrue((boolean)this.pingConnector(this.instance3, this.instance2));
        Assert.assertTrue((boolean)this.pingConnector(this.instance5, this.instance2));
        this.instance2.dumpRepo();
        this.assertSameTopology(new SimpleClusterView(this.instance2), new SimpleClusterView(this.instance3, this.instance4), new SimpleClusterView(this.instance5));
        this.instance4.stopViewChecker();
        this.instance1Restarted = this.newBuilder().setDebugName("instance1").useRepositoryOf(this.instance2).setConnectorPingTimeout(Integer.MAX_VALUE).setMinEventDelay(1).setSlingId(this.instance1.getSlingId()).build();
        this.runHeartbeatOnceWith(this.instance1Restarted, this.instance2, this.instance3, this.instance5);
        Thread.sleep(2000L);
        Assert.assertTrue((boolean)this.pingConnector(this.instance3, this.instance2));
        Assert.assertTrue((boolean)this.pingConnector(this.instance5, this.instance2));
        success = false;
        for (i = 0; i < 40; ++i) {
            this.runHeartbeatOnceWith(this.instance1Restarted, this.instance2, this.instance3, this.instance5);
            this.instance1.getViewChecker().checkView();
            try {
                this.pingConnector(this.instance3, this.instance2);
            }
            catch (UndefinedClusterViewException ping1) {
                // empty catch block
            }
            this.pingConnector(this.instance5, this.instance2);
            TopologyView topology = this.instance3.getDiscoveryService().getTopology();
            InstanceDescription i3 = null;
            for (InstanceDescription id : topology.getInstances()) {
                if (!id.getSlingId().equals(this.instance3.slingId)) continue;
                i3 = id;
                break;
            }
            Assert.assertNotNull(i3);
            Assert.assertEquals((Object)this.instance3.slingId, (Object)i3.getSlingId());
            ClusterView i3Cluster = i3.getClusterView();
            int i3ClusterSize = i3Cluster.getInstances().size();
            if (i3ClusterSize == 1) {
                if (i < 30) {
                    this.logger.info("testConnectorSwitching4139: [2] min loop cnt not yet reached: i=" + i);
                    Thread.sleep(500L);
                    continue;
                }
                success = true;
                this.logger.info("testConnectorSwitching4139: i3ClusterSize: " + i3ClusterSize + ", i=" + i + " (success)");
                break;
            }
            this.logger.info("testConnectorSwitching4139: i3ClusterSize: " + i3ClusterSize + ", i=" + i);
            Thread.sleep(500L);
        }
        this.logger.info("testConnectorSwitching4139: instance1Restarted.slingId=" + this.instance1Restarted.slingId);
        this.logger.info("testConnectorSwitching4139: instance2.slingId=" + this.instance2.slingId);
        this.logger.info("testConnectorSwitching4139: instance3.slingId=" + this.instance3.slingId);
        this.logger.info("testConnectorSwitching4139: instance4.slingId=" + this.instance4.slingId);
        this.logger.info("testConnectorSwitching4139: instance5.slingId=" + this.instance5.slingId);
        this.instance1Restarted.dumpRepo();
        Assert.assertTrue((boolean)success);
        this.assertSameTopology(new SimpleClusterView(this.instance1Restarted, this.instance2), new SimpleClusterView(this.instance3), new SimpleClusterView(this.instance5));
        this.instance1Restarted.stop();
    }

    @Category(value={Slow.class})
    @Test
    public void testDuplicateInstance3726() throws Throwable {
        int i;
        this.logger.info("testDuplicateInstance3726: start");
        boolean MIN_EVENT_DELAY = true;
        this.tearDown();
        org.apache.log4j.Logger discoveryLogger = RootLogger.getLogger((String)"org.apache.sling.discovery");
        this.logLevel = discoveryLogger.getLevel();
        discoveryLogger.setLevel(Level.DEBUG);
        this.instance1 = this.newBuilder().setDebugName("instance1").newRepository("/var/discovery/clusterA/", true).setConnectorPingTimeout(15).setMinEventDelay(1).build();
        this.instance2 = this.newBuilder().setDebugName("instance2").useRepositoryOf(this.instance1).setConnectorPingTimeout(15).setMinEventDelay(1).build();
        this.instance3 = this.newBuilder().setDebugName("instance3").newRepository("/var/discovery/clusterB/", false).setConnectorPingTimeout(15).setMinEventDelay(1).build();
        this.instance5 = this.newBuilder().setDebugName("instance5").newRepository("/var/discovery/clusterC/", false).setConnectorPingTimeout(15).setMinEventDelay(1).build();
        this.runHeartbeatOnceWith(this.instance1, this.instance2, this.instance3, this.instance5);
        Thread.sleep(500L);
        this.runHeartbeatOnceWith(this.instance1, this.instance2, this.instance3, this.instance5);
        Thread.sleep(500L);
        this.runHeartbeatOnceWith(this.instance1, this.instance2, this.instance3, this.instance5);
        Thread.sleep(500L);
        this.assertSameTopology(new SimpleClusterView(this.instance1, this.instance2));
        this.assertSameTopology(new SimpleClusterView(this.instance3));
        this.assertSameTopology(new SimpleClusterView(this.instance5));
        this.pingConnector(this.instance3, this.instance1);
        this.pingConnector(this.instance5, this.instance1);
        this.pingConnector(this.instance3, this.instance1);
        this.pingConnector(this.instance5, this.instance1);
        this.logger.info("testDuplicateInstance3726: instance1.slingId=" + this.instance1.slingId);
        this.logger.info("testDuplicateInstance3726: instance2.slingId=" + this.instance2.slingId);
        this.logger.info("testDuplicateInstance3726: instance3.slingId=" + this.instance3.slingId);
        this.logger.info("testDuplicateInstance3726: instance5.slingId=" + this.instance5.slingId);
        this.instance1.dumpRepo();
        this.assertSameTopology(new SimpleClusterView(this.instance1, this.instance2), new SimpleClusterView(this.instance3), new SimpleClusterView(this.instance5));
        this.instance1.stopViewChecker();
        boolean success = false;
        for (i = 0; i < 25; ++i) {
            this.runHeartbeatOnceWith(this.instance2, this.instance3, this.instance5);
            boolean ping1 = this.pingConnector(this.instance3, this.instance2);
            boolean ping2 = this.pingConnector(this.instance5, this.instance2);
            if (ping1 && ping2) {
                success = true;
                this.logger.info("testDuplicateInstance3726: successfully switched all pings to instance2 after " + i + " rounds.");
                if (i >= 20) break;
                this.logger.info("testDuplicateInstance3726: min loop cnt not yet reached: i=" + i);
                Thread.sleep(1000L);
                continue;
            }
            this.logger.info("testDuplicateInstance3726: looping");
            Thread.sleep(1000L);
        }
        Assert.assertTrue((boolean)success);
        this.runHeartbeatOnceWith(this.instance2, this.instance3, this.instance5);
        Assert.assertTrue((boolean)this.pingConnector(this.instance3, this.instance2));
        Assert.assertTrue((boolean)this.pingConnector(this.instance5, this.instance2));
        this.instance2.dumpRepo();
        this.assertSameTopology(new SimpleClusterView(this.instance2), new SimpleClusterView(this.instance3), new SimpleClusterView(this.instance5));
        this.instance1Restarted = this.newBuilder().setDebugName("instance1").useRepositoryOf(this.instance2).setConnectorPingTimeout(Integer.MAX_VALUE).setMinEventDelay(1).setSlingId(this.instance1.getSlingId()).build();
        this.instance4 = this.newBuilder().setDebugName("instance4").useRepositoryOf(this.instance3).setConnectorPingTimeout(30).setMinEventDelay(1).build();
        for (i = 0; i < 3; ++i) {
            this.runHeartbeatOnceWith(this.instance1Restarted, this.instance2, this.instance3, this.instance4, this.instance5);
            Thread.sleep(250L);
            try {
                this.pingConnector(this.instance3, this.instance2);
            }
            catch (UndefinedClusterViewException undefinedClusterViewException) {
                // empty catch block
            }
            Assert.assertTrue((boolean)this.pingConnector(this.instance5, this.instance2));
        }
        this.instance1Restarted.dumpRepo();
        this.logger.info("testDuplicateInstance3726: instance1Restarted.slingId=" + this.instance1Restarted.slingId);
        this.logger.info("testDuplicateInstance3726: instance2.slingId=" + this.instance2.slingId);
        this.logger.info("testDuplicateInstance3726: instance3.slingId=" + this.instance3.slingId);
        this.logger.info("testDuplicateInstance3726: instance4.slingId=" + this.instance4.slingId);
        this.logger.info("testDuplicateInstance3726: instance5.slingId=" + this.instance5.slingId);
        Assert.assertTrue((boolean)success);
        this.assertSameTopology(new SimpleClusterView(this.instance1Restarted, this.instance2), new SimpleClusterView(this.instance3, this.instance4), new SimpleClusterView(this.instance5));
        this.instance1Restarted.stop();
        this.logger.info("testDuplicateInstance3726: end");
    }

    private void assertSameTopology(SimpleClusterView ... clusters) throws UndefinedClusterViewException {
        if (clusters == null) {
            return;
        }
        for (int i = 0; i < clusters.length; ++i) {
            SimpleClusterView aCluster = clusters[i];
            this.assertSameClusterIds(aCluster.instances);
            for (int j = 0; j < aCluster.instances.length; ++j) {
                VirtualInstance anInstance = aCluster.instances[j];
                this.assertTopology(anInstance, clusters);
                for (int k = 0; k < clusters.length; ++k) {
                    SimpleClusterView otherCluster = clusters[k];
                    if (aCluster == otherCluster) continue;
                    for (int m = 0; m < otherCluster.instances.length; ++m) {
                        this.assertNotSameClusterIds(anInstance, otherCluster.instances[m]);
                    }
                }
            }
        }
    }

    private void runHeartbeatOnceWith(VirtualInstance ... instances) {
        if (instances == null) {
            return;
        }
        for (int i = 0; i < instances.length; ++i) {
            instances[i].heartbeatsAndCheckView();
        }
    }

    @Test
    public void testStaleInstanceIn3Clusters4139() throws Throwable {
        this.logger.info("testStaleInstanceIn3Clusters4139: start");
        String instance1SlingId = this.prepare4139();
        this.instance4 = this.newBuilder().setDebugName("remoteInstance4").newRepository("/var/discovery/implremote4/", false).setConnectorPingTimeout(Integer.MAX_VALUE).setMinEventDelay(1).build();
        try {
            this.instance4.getClusterViewService().getLocalClusterView();
            Assert.fail((String)"should complain");
        }
        catch (UndefinedClusterViewException undefinedClusterViewException) {
            // empty catch block
        }
        this.instance4.heartbeatsAndCheckView();
        this.instance4.heartbeatsAndCheckView();
        this.pingConnector(this.instance3, this.instance4);
        this.instance1Restarted = this.newBuilder().setDebugName("firstInstance").useRepositoryOf(this.instance2).setConnectorPingTimeout(Integer.MAX_VALUE).setMinEventDelay(1).setSlingId(instance1SlingId).build();
        this.runHeartbeatOnceWith(this.instance1Restarted, this.instance2, this.instance3, this.instance4);
        this.pingConnector(this.instance3, this.instance4);
        this.runHeartbeatOnceWith(this.instance1Restarted, this.instance2, this.instance3, this.instance4);
        this.pingConnector(this.instance3, this.instance4);
        this.logger.info("iteration 0");
        this.logger.info("instance1Restarted.slingId: " + this.instance1Restarted.slingId);
        this.logger.info("instance2.slingId: " + this.instance2.slingId);
        this.logger.info("instance3.slingId: " + this.instance3.slingId);
        this.logger.info("instance4.slingId: " + this.instance4.slingId);
        this.instance1Restarted.dumpRepo();
        this.assertSameTopology(new SimpleClusterView(this.instance3), new SimpleClusterView(this.instance4));
        this.assertSameTopology(new SimpleClusterView(this.instance1Restarted, this.instance2));
        Thread.sleep(100L);
        this.runHeartbeatOnceWith(this.instance1Restarted, this.instance2, this.instance3, this.instance4);
        this.pingConnector(this.instance3, this.instance4);
        this.runHeartbeatOnceWith(this.instance1Restarted, this.instance2, this.instance3, this.instance4);
        this.pingConnector(this.instance3, this.instance4);
        this.logger.info("iteration 1");
        this.logger.info("instance1Restarted.slingId: " + this.instance1Restarted.slingId);
        this.logger.info("instance2.slingId: " + this.instance2.slingId);
        this.logger.info("instance3.slingId: " + this.instance3.slingId);
        this.logger.info("instance4.slingId: " + this.instance4.slingId);
        this.instance1Restarted.dumpRepo();
        this.assertSameTopology(new SimpleClusterView(this.instance1Restarted, this.instance2));
        this.assertSameTopology(new SimpleClusterView(this.instance3), new SimpleClusterView(this.instance4));
        Thread.sleep(100L);
        this.runHeartbeatOnceWith(this.instance1Restarted, this.instance2, this.instance3, this.instance4);
        this.pingConnector(this.instance3, this.instance4);
        this.logger.info("iteration 2");
        this.logger.info("instance1Restarted.slingId: " + this.instance1Restarted.slingId);
        this.logger.info("instance2.slingId: " + this.instance2.slingId);
        this.logger.info("instance3.slingId: " + this.instance3.slingId);
        this.logger.info("instance4.slingId: " + this.instance4.slingId);
        this.instance1Restarted.dumpRepo();
        this.assertSameTopology(new SimpleClusterView(this.instance1Restarted, this.instance2));
        this.assertSameTopology(new SimpleClusterView(this.instance3), new SimpleClusterView(this.instance4));
        this.instance1Restarted.stop();
        this.logger.info("testStaleInstanceIn3Clusters4139: end");
    }

    private String prepare4139() throws Throwable, Exception, InterruptedException {
        this.tearDown();
        this.instance1 = this.newBuilder().setDebugName("firstInstance").newRepository("/var/discovery/impl/", true).setConnectorPingTimeout(Integer.MAX_VALUE).setMinEventDelay(1).build();
        this.instance2 = this.newBuilder().setDebugName("secondInstance").useRepositoryOf(this.instance1).setConnectorPingTimeout(Integer.MAX_VALUE).setMinEventDelay(1).build();
        this.runHeartbeatOnceWith(this.instance1, this.instance2);
        Thread.sleep(100L);
        this.runHeartbeatOnceWith(this.instance1, this.instance2);
        Thread.sleep(100L);
        this.runHeartbeatOnceWith(this.instance1, this.instance2);
        this.assertSameClusterIds(this.instance1, this.instance2);
        this.instance3 = this.newBuilder().setDebugName("remoteInstance").newRepository("/var/discovery/implremote/", false).setConnectorPingTimeout(Integer.MAX_VALUE).setMinEventDelay(1).build();
        this.assertSameClusterIds(this.instance1, this.instance2);
        try {
            this.instance3.getClusterViewService().getLocalClusterView();
            Assert.fail((String)"should complain");
        }
        catch (UndefinedClusterViewException undefinedClusterViewException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)this.instance1.getAnnouncementRegistry().listLocalAnnouncements().size());
        Assert.assertEquals((long)0L, (long)this.instance1.getAnnouncementRegistry().listLocalIncomingAnnouncements().size());
        Assert.assertEquals((long)0L, (long)this.instance2.getAnnouncementRegistry().listLocalAnnouncements().size());
        Assert.assertEquals((long)0L, (long)this.instance2.getAnnouncementRegistry().listLocalIncomingAnnouncements().size());
        Assert.assertEquals((long)0L, (long)this.instance3.getAnnouncementRegistry().listLocalAnnouncements().size());
        Assert.assertEquals((long)0L, (long)this.instance3.getAnnouncementRegistry().listLocalIncomingAnnouncements().size());
        this.instance3.heartbeatsAndCheckView();
        this.instance3.heartbeatsAndCheckView();
        Thread.sleep(1000L);
        this.pingConnector(this.instance3, this.instance1);
        this.instance1.dumpRepo();
        this.assertSameTopology(new SimpleClusterView(this.instance1, this.instance2), new SimpleClusterView(this.instance3));
        this.logger.info("instance1.slingId=" + this.instance1.slingId);
        this.logger.info("instance2.slingId=" + this.instance2.slingId);
        this.logger.info("instance3.slingId=" + this.instance3.slingId);
        String instance1SlingId = this.instance1.slingId;
        this.instance1.stopViewChecker();
        this.instance1.stop();
        this.instance1 = null;
        this.instance2.getConfig().setViewCheckTimeout(1);
        this.instance3.getConfig().setViewCheckTimeout(1);
        Thread.sleep(500L);
        this.runHeartbeatOnceWith(this.instance2, this.instance3);
        Thread.sleep(500L);
        this.runHeartbeatOnceWith(this.instance2, this.instance3);
        Thread.sleep(500L);
        this.runHeartbeatOnceWith(this.instance2, this.instance3);
        this.instance2.dumpRepo();
        this.assertTopology(this.instance2, new SimpleClusterView(this.instance2));
        this.assertTopology(this.instance3, new SimpleClusterView(this.instance3));
        this.instance2.getConfig().setViewCheckTimeout(Integer.MAX_VALUE);
        this.instance3.getConfig().setViewCheckTimeout(Integer.MAX_VALUE);
        return instance1SlingId;
    }

    private void assertNotSameClusterIds(VirtualInstance ... instances) throws UndefinedClusterViewException {
        if (instances == null) {
            Assert.fail((String)"must not pass empty set of instances here");
        }
        if (instances.length <= 1) {
            Assert.fail((String)"must not pass 0 or 1 instance only");
        }
        String clusterId1 = instances[0].getClusterViewService().getLocalClusterView().getId();
        for (int i = 1; i < instances.length; ++i) {
            String otherClusterId = instances[i].getClusterViewService().getLocalClusterView().getId();
            Assert.assertNotEquals((Object)clusterId1, (Object)otherClusterId);
        }
        if (instances.length > 2) {
            VirtualInstance[] subset = new VirtualInstance[instances.length - 1];
            System.arraycopy(instances, 0, subset, 1, instances.length - 1);
            this.assertNotSameClusterIds(subset);
        }
    }

    private void assertSameClusterIds(VirtualInstance ... instances) throws UndefinedClusterViewException {
        if (instances == null) {
            return;
        }
        if (instances.length == 1) {
            return;
        }
        String clusterId1 = instances[0].getClusterViewService().getLocalClusterView().getId();
        for (int i = 1; i < instances.length; ++i) {
            String otherClusterId = instances[i].getClusterViewService().getLocalClusterView().getId();
            if (clusterId1.equals(otherClusterId)) continue;
            this.logger.error("assertSameClusterIds: instances[0]: " + instances[0]);
            this.logger.error("assertSameClusterIds: instances[" + i + "]: " + instances[i]);
            Assert.fail((String)("mismatch in clusterIds: expected to equal: clusterId1=" + clusterId1 + ", otherClusterId=" + otherClusterId));
        }
    }

    private void assertTopology(VirtualInstance instance, SimpleClusterView ... assertedClusterViews) {
        TopologyView topology = instance.getDiscoveryService().getTopology();
        this.logger.info("assertTopology: instance " + instance.slingId + " sees topology: " + topology + ", expected: " + assertedClusterViews);
        Assert.assertNotNull((Object)topology);
        if (assertedClusterViews.length != topology.getClusterViews().size()) {
            this.dumpFailureDetails(topology, assertedClusterViews);
            Assert.fail((String)("instance " + instance.slingId + " expected " + assertedClusterViews.length + ", got: " + topology.getClusterViews().size()));
        }
        HashSet actualClusters = new HashSet(topology.getClusterViews());
        for (int i = 0; i < assertedClusterViews.length; ++i) {
            SimpleClusterView assertedClusterView = assertedClusterViews[i];
            boolean foundMatch = false;
            Iterator it = actualClusters.iterator();
            while (it.hasNext()) {
                ClusterView actualClusterView = (ClusterView)it.next();
                if (!this.matches(assertedClusterView, actualClusterView)) continue;
                it.remove();
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            this.dumpFailureDetails(topology, assertedClusterViews);
            Assert.fail((String)("instance " + instance.slingId + " could not find a match in the topology with instance=" + instance.slingId + " and clusterViews=" + assertedClusterViews.length));
        }
        Assert.assertEquals((String)("not all asserted clusterviews are in the actual view with instance=" + instance + " and clusterViews=" + assertedClusterViews), (long)actualClusters.size(), (long)0L);
    }

    private void dumpFailureDetails(TopologyView topology, SimpleClusterView ... assertedClusterViews) {
        this.logger.error("assertTopology: expected: " + assertedClusterViews.length);
        for (int j = 0; j < assertedClusterViews.length; ++j) {
            this.logger.error("assertTopology:  [" + j + "]: " + assertedClusterViews[j].toString());
        }
        Set clusterViews = topology.getClusterViews();
        Set instances = topology.getInstances();
        this.logger.error("assertTopology: actual: " + clusterViews.size() + " clusters with a total of " + instances.size() + " instances");
        for (ClusterView aCluster : clusterViews) {
            this.logger.error("assertTopology:  a cluster: " + aCluster.getId());
            for (InstanceDescription id : aCluster.getInstances()) {
                this.logger.error("assertTopology:   - an instance " + id.getSlingId());
            }
        }
        this.logger.error("assertTopology: list of all instances: " + instances.size());
        for (InstanceDescription id : instances) {
            this.logger.error("assertTopology: - an instance: " + id.getSlingId());
        }
    }

    private boolean matches(SimpleClusterView assertedClusterView, ClusterView actualClusterView) {
        Assert.assertNotNull((Object)assertedClusterView);
        Assert.assertNotNull((Object)actualClusterView);
        if (assertedClusterView.instances.length != actualClusterView.getInstances().size()) {
            return false;
        }
        HashSet actualInstances = new HashSet(actualClusterView.getInstances());
        block0: for (int i = 0; i < assertedClusterView.instances.length; ++i) {
            VirtualInstance assertedInstance = assertedClusterView.instances[i];
            for (InstanceDescription anActualInstance : actualInstances) {
                if (!assertedInstance.slingId.equals(anActualInstance.getSlingId())) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    private boolean pingConnector(VirtualInstance from, VirtualInstance to) throws UndefinedClusterViewException {
        Announcement fromAnnouncement = this.createFromAnnouncement(from);
        Announcement replyAnnouncement = null;
        try {
            replyAnnouncement = this.ping(to, fromAnnouncement);
        }
        catch (AssertionError e) {
            this.logger.warn("pingConnector: ping failed, assertionError: " + e);
            return false;
        }
        catch (UndefinedClusterViewException e) {
            this.logger.warn("pingConnector: ping failed, currently the cluster view is undefined: " + (Object)((Object)e));
            return false;
        }
        this.registerReplyAnnouncement(from, replyAnnouncement);
        return true;
    }

    private void registerReplyAnnouncement(VirtualInstance from, Announcement inheritedAnnouncement) {
        AnnouncementRegistry announcementRegistry = from.getAnnouncementRegistry();
        if (inheritedAnnouncement.isLoop()) {
            Assert.fail((String)"loop detected");
            return;
        }
        inheritedAnnouncement.setInherited(true);
        if (announcementRegistry.registerAnnouncement(inheritedAnnouncement) == -1L) {
            this.logger.info("ping: connector response is from an instance which I already see in my topology" + inheritedAnnouncement);
            return;
        }
    }

    private Announcement ping(VirtualInstance to, final Announcement incomingTopologyAnnouncement) throws UndefinedClusterViewException {
        String slingId = to.slingId;
        ClusterViewService clusterViewService = to.getClusterViewService();
        AnnouncementRegistry announcementRegistry = to.getAnnouncementRegistry();
        incomingTopologyAnnouncement.removeInherited(slingId);
        Announcement replyAnnouncement = new Announcement(slingId);
        long backoffInterval = -1L;
        LocalClusterView clusterView = clusterViewService.getLocalClusterView();
        if (!incomingTopologyAnnouncement.isCorrectVersion()) {
            Assert.fail((String)"incorrect version");
            return null;
        }
        if (ClusterViewHelper.contains((ClusterView)clusterView, (String)incomingTopologyAnnouncement.getOwnerId())) {
            Assert.fail((String)"loop=true");
            return null;
        }
        if (ClusterViewHelper.containsAny((ClusterView)clusterView, (Collection)incomingTopologyAnnouncement.listInstances())) {
            Assert.fail((String)"incoming announcement contains instances that are part of my cluster");
            return null;
        }
        backoffInterval = announcementRegistry.registerAnnouncement(incomingTopologyAnnouncement);
        if (backoffInterval == -1L) {
            Assert.fail((String)"rejecting an announcement from an instance that I already see in my topology: ");
            return null;
        }
        replyAnnouncement.setLocalCluster((ClusterView)clusterView);
        announcementRegistry.addAllExcept(replyAnnouncement, (ClusterView)clusterView, new AnnouncementFilter(){

            public boolean accept(String receivingSlingId, Announcement announcement) {
                return !announcement.getPrimaryKey().equals(incomingTopologyAnnouncement.getPrimaryKey());
            }
        });
        return replyAnnouncement;
    }

    private Announcement createFromAnnouncement(VirtualInstance from) throws UndefinedClusterViewException {
        Announcement topologyAnnouncement = new Announcement(from.slingId);
        topologyAnnouncement.setServerInfo(from.slingId);
        LocalClusterView clusterView = from.getClusterViewService().getLocalClusterView();
        topologyAnnouncement.setLocalCluster((ClusterView)clusterView);
        from.getAnnouncementRegistry().addAllExcept(topologyAnnouncement, (ClusterView)clusterView, new AnnouncementFilter((ClusterView)clusterView){
            final /* synthetic */ ClusterView val$clusterView;
            {
                this.val$clusterView = clusterView;
            }

            public boolean accept(String receivingSlingId, Announcement announcement) {
                for (InstanceDescription instance : this.val$clusterView.getInstances()) {
                    if (!instance.getSlingId().equals(receivingSlingId)) continue;
                    return true;
                }
                return false;
            }
        });
        return topologyAnnouncement;
    }

    @Test
    public void testStableClusterId() throws Throwable {
        this.logger.info("testStableClusterId: start");
        this.instance2.stopViewChecker();
        this.instance1.stopViewChecker();
        this.instance2.stop();
        this.instance1.stop();
        this.instance1 = this.newBuilder().setDebugName("firstInstance").newRepository("/var/discovery/impl/", true).setConnectorPingTimeout(100).setMinEventDelay(1).build();
        this.instance2 = this.newBuilder().setDebugName("secondInstance").useRepositoryOf(this.instance1).setConnectorPingTimeout(100).setMinEventDelay(1).build();
        Assert.assertNotNull((Object)this.instance1);
        Assert.assertNotNull((Object)this.instance2);
        try {
            this.instance1.getClusterViewService().getLocalClusterView();
            Assert.fail((String)"should complain");
        }
        catch (UndefinedClusterViewException undefinedClusterViewException) {
            // empty catch block
        }
        try {
            this.instance2.getClusterViewService().getLocalClusterView();
            Assert.fail((String)"should complain");
        }
        catch (UndefinedClusterViewException undefinedClusterViewException) {
            // empty catch block
        }
        this.instance1.heartbeatsAndCheckView();
        this.instance2.heartbeatsAndCheckView();
        Thread.sleep(500L);
        this.instance1.heartbeatsAndCheckView();
        this.instance2.heartbeatsAndCheckView();
        Thread.sleep(500L);
        this.instance1.heartbeatsAndCheckView();
        this.instance2.heartbeatsAndCheckView();
        String newClusterId1 = this.instance1.getClusterViewService().getLocalClusterView().getId();
        String newClusterId2 = this.instance2.getClusterViewService().getLocalClusterView().getId();
        Assert.assertEquals((Object)newClusterId1, (Object)newClusterId1);
        this.instance1.dumpRepo();
        Assert.assertEquals((long)2L, (long)this.instance1.getClusterViewService().getLocalClusterView().getInstances().size());
        Assert.assertEquals((long)2L, (long)this.instance2.getClusterViewService().getLocalClusterView().getInstances().size());
        this.instance2.getConfig().setViewCheckTimeout(1);
        this.instance1.getConfig().setViewCheckTimeout(1);
        this.instance2.stopViewChecker();
        this.instance1.heartbeatsAndCheckView();
        Thread.sleep(500L);
        this.instance1.heartbeatsAndCheckView();
        Thread.sleep(500L);
        this.instance1.heartbeatsAndCheckView();
        Thread.sleep(500L);
        this.instance1.heartbeatsAndCheckView();
        Thread.sleep(500L);
        this.instance1.heartbeatsAndCheckView();
        Thread.sleep(500L);
        this.instance1.heartbeatsAndCheckView();
        Assert.assertEquals((long)1L, (long)this.instance1.getClusterViewService().getLocalClusterView().getInstances().size());
        try {
            this.instance2.getViewChecker().checkView();
            this.instance2.getClusterViewService().getLocalClusterView();
            Assert.fail((String)"should complain");
        }
        catch (UndefinedClusterViewException undefinedClusterViewException) {
            // empty catch block
        }
        this.instance1.dumpRepo();
        String actualClusterId = this.instance1.getClusterViewService().getLocalClusterView().getId();
        this.logger.info("expected cluster id: " + newClusterId1);
        this.logger.info("actual   cluster id: " + actualClusterId);
        Assert.assertEquals((Object)newClusterId1, (Object)actualClusterId);
        this.logger.info("testStableClusterId: end");
    }

    @Test
    public void testClusterView() throws Exception {
        this.logger.info("testClusterView: start");
        Assert.assertNotNull((Object)this.instance1);
        Assert.assertNotNull((Object)this.instance2);
        Assert.assertNull((Object)this.instance3);
        this.instance3 = this.newBuilder().setDebugName("thirdInstance").useRepositoryOf(this.instance1).build();
        Assert.assertNotNull((Object)this.instance3);
        Assert.assertEquals((Object)this.instance1.getSlingId(), (Object)this.instance1.getClusterViewService().getSlingId());
        Assert.assertEquals((Object)this.instance2.getSlingId(), (Object)this.instance2.getClusterViewService().getSlingId());
        Assert.assertEquals((Object)this.instance3.getSlingId(), (Object)this.instance3.getClusterViewService().getSlingId());
        try {
            this.instance1.getClusterViewService().getLocalClusterView();
            Assert.fail((String)"should complain");
        }
        catch (UndefinedClusterViewException undefinedClusterViewException) {
            // empty catch block
        }
        try {
            this.instance2.getClusterViewService().getLocalClusterView();
            Assert.fail((String)"should complain");
        }
        catch (UndefinedClusterViewException undefinedClusterViewException) {
            // empty catch block
        }
        try {
            this.instance3.getClusterViewService().getLocalClusterView();
            Assert.fail((String)"should complain");
        }
        catch (UndefinedClusterViewException undefinedClusterViewException) {
            // empty catch block
        }
        this.instance1.dumpRepo();
        this.instance1.heartbeatsAndCheckView();
        this.instance2.heartbeatsAndCheckView();
        this.instance3.heartbeatsAndCheckView();
        this.instance1.dumpRepo();
        this.logger.info("testClusterView: 1st 2s sleep");
        Thread.sleep(2000L);
        this.instance1.heartbeatsAndCheckView();
        this.instance2.heartbeatsAndCheckView();
        this.instance3.heartbeatsAndCheckView();
        this.logger.info("testClusterView: 2nd 2s sleep");
        Thread.sleep(2000L);
        this.instance1.dumpRepo();
        String clusterId1 = this.instance1.getClusterViewService().getLocalClusterView().getId();
        this.logger.info("clusterId1=" + clusterId1);
        String clusterId2 = this.instance2.getClusterViewService().getLocalClusterView().getId();
        this.logger.info("clusterId2=" + clusterId2);
        String clusterId3 = this.instance3.getClusterViewService().getLocalClusterView().getId();
        this.logger.info("clusterId3=" + clusterId3);
        Assert.assertEquals((Object)clusterId1, (Object)clusterId2);
        Assert.assertEquals((Object)clusterId1, (Object)clusterId3);
        Assert.assertEquals((long)3L, (long)this.instance1.getClusterViewService().getLocalClusterView().getInstances().size());
        Assert.assertEquals((long)3L, (long)this.instance2.getClusterViewService().getLocalClusterView().getInstances().size());
        Assert.assertEquals((long)3L, (long)this.instance3.getClusterViewService().getLocalClusterView().getInstances().size());
        this.logger.info("testClusterView: end");
    }

    @Category(value={Slow.class})
    @Test
    public void testAdditionalInstance() throws Throwable {
        this.logger.info("testAdditionalInstance: start");
        Assert.assertNotNull((Object)this.instance1);
        Assert.assertNotNull((Object)this.instance2);
        Assert.assertEquals((Object)this.instance1.getSlingId(), (Object)this.instance1.getClusterViewService().getSlingId());
        Assert.assertEquals((Object)this.instance2.getSlingId(), (Object)this.instance2.getClusterViewService().getSlingId());
        try {
            this.instance1.getClusterViewService().getLocalClusterView();
            Assert.fail((String)"should complain");
        }
        catch (UndefinedClusterViewException undefinedClusterViewException) {
            // empty catch block
        }
        try {
            this.instance2.getClusterViewService().getLocalClusterView();
            Assert.fail((String)"should complain");
        }
        catch (UndefinedClusterViewException undefinedClusterViewException) {
            // empty catch block
        }
        this.instance1.heartbeatsAndCheckView();
        this.instance2.heartbeatsAndCheckView();
        this.instance1.dumpRepo();
        this.logger.info("testAdditionalInstance: 1st 2s sleep");
        Thread.sleep(2000L);
        this.instance1.heartbeatsAndCheckView();
        this.instance2.heartbeatsAndCheckView();
        this.logger.info("testAdditionalInstance: 2nd 2s sleep");
        Thread.sleep(2000L);
        this.instance1.dumpRepo();
        String clusterId1 = this.instance1.getClusterViewService().getLocalClusterView().getId();
        this.logger.info("clusterId1=" + clusterId1);
        String clusterId2 = this.instance2.getClusterViewService().getLocalClusterView().getId();
        this.logger.info("clusterId2=" + clusterId2);
        Assert.assertEquals((Object)clusterId1, (Object)clusterId2);
        Assert.assertEquals((long)2L, (long)this.instance1.getClusterViewService().getLocalClusterView().getInstances().size());
        Assert.assertEquals((long)2L, (long)this.instance2.getClusterViewService().getLocalClusterView().getInstances().size());
        AssertingTopologyEventListener assertingTopologyEventListener = new AssertingTopologyEventListener();
        assertingTopologyEventListener.addExpected(TopologyEvent.Type.TOPOLOGY_INIT);
        Assert.assertEquals((long)1L, (long)assertingTopologyEventListener.getRemainingExpectedCount());
        this.instance1.bindTopologyEventListener(assertingTopologyEventListener);
        Thread.sleep(500L);
        Assert.assertEquals((long)0L, (long)assertingTopologyEventListener.getRemainingExpectedCount());
        AcceptsMultiple acceptsMultiple = new AcceptsMultiple(TopologyEvent.Type.TOPOLOGY_CHANGING, TopologyEvent.Type.TOPOLOGY_CHANGED);
        assertingTopologyEventListener.addExpected(acceptsMultiple);
        assertingTopologyEventListener.addExpected(acceptsMultiple);
        this.instance3 = this.newBuilder().setDebugName("thirdInstance").useRepositoryOf(this.instance1).build();
        for (int i = 0; i < 4; ++i) {
            this.instance1.heartbeatsAndCheckView();
            this.instance2.heartbeatsAndCheckView();
            this.instance3.heartbeatsAndCheckView();
            this.logger.info("testAdditionalInstance: i=" + i + ", 2s sleep");
            Thread.sleep(2000L);
        }
        Assert.assertEquals((long)1L, (long)acceptsMultiple.getEventCnt(TopologyEvent.Type.TOPOLOGY_CHANGING));
        Assert.assertEquals((long)1L, (long)acceptsMultiple.getEventCnt(TopologyEvent.Type.TOPOLOGY_CHANGED));
        this.logger.info("testAdditionalInstance: end");
    }

    @Test
    public void testPropertyProviders() throws Throwable {
        this.logger.info("testPropertyProviders: start");
        this.instance1.heartbeatsAndCheckView();
        this.instance2.heartbeatsAndCheckView();
        Assert.assertNull((Object)this.instance3);
        this.instance3 = this.newBuilder().setDebugName("thirdInstance").useRepositoryOf(this.instance1).build();
        this.instance3.heartbeatsAndCheckView();
        this.logger.info("testPropertyProviders: 1st 2s sleep");
        Thread.sleep(2000L);
        this.instance1.heartbeatsAndCheckView();
        this.instance2.heartbeatsAndCheckView();
        this.instance3.heartbeatsAndCheckView();
        this.logger.info("testPropertyProviders: 2nd 2s sleep");
        Thread.sleep(2000L);
        this.instance1.heartbeatsAndCheckView();
        this.instance2.heartbeatsAndCheckView();
        this.instance3.heartbeatsAndCheckView();
        this.logger.info("testPropertyProviders: 3rd 2s sleep");
        Thread.sleep(2000L);
        this.property1Value = UUID.randomUUID().toString();
        this.property1Name = UUID.randomUUID().toString();
        PropertyProviderImpl pp1 = new PropertyProviderImpl();
        pp1.setProperty(this.property1Name, this.property1Value);
        this.instance1.bindPropertyProvider(pp1, this.property1Name);
        this.property2Value = UUID.randomUUID().toString();
        this.property2Name = UUID.randomUUID().toString();
        PropertyProviderImpl pp2 = new PropertyProviderImpl();
        pp2.setProperty(this.property2Name, this.property2Value);
        this.instance2.bindPropertyProvider(pp2, this.property2Name);
        this.assertPropertyValues();
        this.property1Value = UUID.randomUUID().toString();
        pp1.setProperty(this.property1Name, this.property1Value);
        this.instance1.heartbeatsAndCheckView();
        this.instance2.heartbeatsAndCheckView();
        this.assertPropertyValues();
        Assert.assertNull((Object)((InstanceDescription)this.instance1.getClusterViewService().getLocalClusterView().getInstances().get(0)).getProperty(UUID.randomUUID().toString()));
        Assert.assertNull((Object)((InstanceDescription)this.instance2.getClusterViewService().getLocalClusterView().getInstances().get(0)).getProperty(UUID.randomUUID().toString()));
        this.logger.info("testPropertyProviders: end");
    }

    private void assertPropertyValues() throws UndefinedClusterViewException {
        this.assertPropertyValues(this.instance1.getSlingId(), this.property1Name, this.property1Value);
        this.assertPropertyValues(this.instance2.getSlingId(), this.property2Name, this.property2Value);
    }

    private void assertPropertyValues(String slingId, String name, String value) throws UndefinedClusterViewException {
        Assert.assertEquals((Object)value, (Object)this.getInstance(this.instance1, slingId).getProperty(name));
        Assert.assertEquals((Object)value, (Object)this.getInstance(this.instance2, slingId).getProperty(name));
    }

    private InstanceDescription getInstance(VirtualInstance instance, String slingId) throws UndefinedClusterViewException {
        for (InstanceDescription id : instance.getClusterViewService().getLocalClusterView().getInstances()) {
            if (!id.getSlingId().equals(slingId)) continue;
            return id;
        }
        throw new IllegalStateException("instance not found: instance=" + instance + ", slingId=" + slingId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Category(value={Slow.class})
    @Test
    public void testLongRunningListener() throws Throwable {
        this.instance1.getConfig().setViewCheckTimeout(2);
        this.instance2.getConfig().setViewCheckTimeout(2);
        this.logger.info("testLongRunningListener : letting instance2 remain silent from now on");
        this.instance1.heartbeatsAndCheckView();
        Thread.sleep(1500L);
        this.instance1.heartbeatsAndCheckView();
        Thread.sleep(1500L);
        this.instance1.heartbeatsAndCheckView();
        Thread.sleep(1500L);
        this.instance1.heartbeatsAndCheckView();
        this.logger.info("testLongRunningListener : instance 2 should now be considered dead");
        LongRunningListener longRunningListener1 = new LongRunningListener();
        AssertingTopologyEventListener fastListener2 = new AssertingTopologyEventListener();
        fastListener2.addExpected(TopologyEvent.Type.TOPOLOGY_INIT);
        longRunningListener1.assertNoFail();
        Assert.assertEquals((long)1L, (long)fastListener2.getRemainingExpectedCount());
        this.logger.info("testLongRunningListener : binding longRunningListener1 ...");
        this.instance1.bindTopologyEventListener(longRunningListener1);
        this.logger.info("testLongRunningListener : binding fastListener2 ...");
        this.instance1.bindTopologyEventListener(fastListener2);
        this.logger.info("testLongRunningListener : waiting a bit for longRunningListener1 to receive the TOPOLOGY_INIT event");
        Thread.sleep(2500L);
        Assert.assertEquals((long)0L, (long)fastListener2.getRemainingExpectedCount());
        Assert.assertTrue((boolean)longRunningListener1.initReceived);
        fastListener2.addExpected(TopologyEvent.Type.TOPOLOGY_CHANGING);
        fastListener2.addExpected(TopologyEvent.Type.TOPOLOGY_CHANGED);
        this.instance1.getConfig().setViewCheckTimeout(10);
        this.instance2.getConfig().setViewCheckTimeout(10);
        this.instance1.heartbeatsAndCheckView();
        this.instance2.heartbeatsAndCheckView();
        Thread.sleep(500L);
        this.instance1.heartbeatsAndCheckView();
        this.instance2.heartbeatsAndCheckView();
        Thread.sleep(500L);
        this.instance1.heartbeatsAndCheckView();
        this.instance2.heartbeatsAndCheckView();
        Thread.sleep(500L);
        this.instance1.dumpRepo();
        longRunningListener1.assertNoFail();
        Assert.assertEquals((long)0L, (long)fastListener2.getUnexpectedCount());
        Assert.assertEquals((long)1L, (long)fastListener2.getRemainingExpectedCount());
        Assert.assertEquals((long)1L, (long)longRunningListener1.noninitReceived);
        Thread.sleep(2000L);
        Assert.assertTrue((boolean)longRunningListener1.getChangedSemaphore().hasQueuedThreads());
        Thread.sleep(2000L);
        Assert.assertEquals((long)0L, (long)fastListener2.getUnexpectedCount());
        Assert.assertEquals((long)1L, (long)fastListener2.getRemainingExpectedCount());
        Assert.assertEquals((long)1L, (long)longRunningListener1.noninitReceived);
        Assert.assertTrue((boolean)longRunningListener1.getChangedSemaphore().hasQueuedThreads());
        final LinkedList asyncException = new LinkedList();
        Thread th = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AbstractClusterTest.this.instance1.stop();
                }
                catch (Exception e) {
                    List list = asyncException;
                    synchronized (list) {
                        asyncException.add(e);
                    }
                }
            }
        });
        th.start();
        this.logger.info("Waiting max 4 sec...");
        th.join(4000L);
        this.logger.info("Done waiting max 4 sec...");
        if (th.isAlive()) {
            this.logger.warn("Thread still alive: " + th.isAlive());
            longRunningListener1.getChangedSemaphore().release();
            Assert.fail((String)"Thread was still alive");
        }
        this.logger.info("Thread was no longer alive: " + th.isAlive());
        LinkedList linkedList = asyncException;
        synchronized (linkedList) {
            this.logger.info("Async exceptions: " + asyncException.size());
            if (asyncException.size() != 0) {
                longRunningListener1.getChangedSemaphore().release();
                Assert.fail((String)("async exceptions: " + asyncException.size() + ", first: " + asyncException.get(0)));
            }
        }
        longRunningListener1.getChangedSemaphore().release();
        Thread.sleep(500L);
        Assert.assertEquals((long)0L, (long)fastListener2.getUnexpectedCount());
        Assert.assertEquals((long)0L, (long)fastListener2.getRemainingExpectedCount());
        Assert.assertEquals((long)2L, (long)longRunningListener1.noninitReceived);
        Assert.assertFalse((boolean)longRunningListener1.getChangedSemaphore().hasQueuedThreads());
    }

    class LongRunningListener
    implements TopologyEventListener {
        String failMsg = null;
        boolean initReceived = false;
        int noninitReceived;
        private Semaphore changedSemaphore = new Semaphore(0);

        LongRunningListener() {
        }

        public void assertNoFail() {
            if (this.failMsg != null) {
                Assert.fail((String)this.failMsg);
            }
        }

        public Semaphore getChangedSemaphore() {
            return this.changedSemaphore;
        }

        public void handleTopologyEvent(TopologyEvent event) {
            if (this.failMsg != null) {
                this.failMsg = this.failMsg + "/ Already failed, got another event; " + event;
                return;
            }
            if (!this.initReceived) {
                if (event.getType() != TopologyEvent.Type.TOPOLOGY_INIT) {
                    this.failMsg = "Expected TOPOLOGY_INIT first, got: " + event.getType();
                    return;
                }
                this.initReceived = true;
                return;
            }
            if (event.getType() == TopologyEvent.Type.TOPOLOGY_CHANGED) {
                try {
                    this.changedSemaphore.acquire();
                }
                catch (InterruptedException e) {
                    throw new Error("don't interrupt me pls: " + e);
                }
            }
            ++this.noninitReceived;
        }
    }

    private class SimpleClusterView {
        private VirtualInstance[] instances;

        SimpleClusterView(VirtualInstance ... instances) {
            this.instances = instances;
        }

        public String toString() {
            String instanceSlingIds = "";
            for (int i = 0; i < this.instances.length; ++i) {
                instanceSlingIds = instanceSlingIds + this.instances[i].slingId + ",";
            }
            return "an expected cluster with " + this.instances.length + " instances: " + instanceSlingIds;
        }
    }
}

