/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.its;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.sling.commons.testing.junit.categories.Slow;
import org.apache.sling.discovery.base.commons.UndefinedClusterViewException;
import org.apache.sling.discovery.base.its.setup.VirtualInstance;
import org.apache.sling.discovery.base.its.setup.VirtualInstanceBuilder;
import org.apache.sling.discovery.base.its.setup.WithholdingAppender;
import org.apache.sling.testing.tools.retry.RetryLoop;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClusterLoadTest {
    private static final int INSTANCE_VIEW_TIMEOUT_SECONDS = 120;
    private static final int INSTANCE_VIEW_POLL_INTERVAL_MILLIS = 500;
    private final Random random = new Random();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    List<VirtualInstance> instances = new LinkedList<VirtualInstance>();

    @After
    public void tearDown() throws Exception {
        if (this.instances == null || this.instances.size() == 0) {
            return;
        }
        Iterator<VirtualInstance> it = this.instances.iterator();
        while (it.hasNext()) {
            VirtualInstance i = it.next();
            i.stop();
            it.remove();
        }
    }

    public abstract VirtualInstanceBuilder newBuilder();

    @Test
    public void testFramework() throws Exception {
        this.logger.info("testFramework: building 1st instance..");
        VirtualInstanceBuilder builder = this.newBuilder().newRepository("/var/discovery/impl/ClusterLoadTest/testFramework/", true).setDebugName("firstInstance").setConnectorPingTimeout(3).setConnectorPingInterval(20).setMinEventDelay(0);
        VirtualInstance firstInstance = builder.build();
        this.instances.add(firstInstance);
        Thread.sleep(2000L);
        try {
            firstInstance.getClusterViewService().getLocalClusterView();
            Assert.fail((String)"should complain");
        }
        catch (UndefinedClusterViewException undefinedClusterViewException) {
            // empty catch block
        }
        firstInstance.startViewChecker(1);
        Thread.sleep(4000L);
        firstInstance.dumpRepo();
        firstInstance.assertEstablishedView();
        VirtualInstanceBuilder builder2 = this.newBuilder().useRepositoryOf(builder).setDebugName("secondInstance").setConnectorPingTimeout(3).setConnectorPingInterval(20).setMinEventDelay(0);
        firstInstance.dumpRepo();
        this.logger.info("testFramework: building 2nd instance..");
        VirtualInstance secondInstance = builder2.build();
        this.instances.add(secondInstance);
        secondInstance.startViewChecker(1);
        Thread.sleep(4000L);
        firstInstance.dumpRepo();
        Assert.assertEquals((long)firstInstance.getClusterViewService().getLocalClusterView().getInstances().size(), (long)2L);
        Assert.assertEquals((long)secondInstance.getClusterViewService().getLocalClusterView().getInstances().size(), (long)2L);
    }

    @Test
    public void testTwoInstancesFast() throws Throwable {
        this.doTest(2, 3);
    }

    @Test
    public void testThreeInstancesFast() throws Throwable {
        this.doTest(3, 3);
    }

    @Category(value={Slow.class})
    @Test
    public void testTwoInstances() throws Throwable {
        this.doTest(2, 5);
    }

    @Category(value={Slow.class})
    @Test
    public void testThreeInstances() throws Throwable {
        this.doTest(3, 6);
    }

    @Category(value={Slow.class})
    @Test
    public void testFourInstances() throws Throwable {
        this.doTest(4, 7);
    }

    @Category(value={Slow.class})
    @Test
    public void testFiveInstances() throws Throwable {
        this.doTest(5, 8);
    }

    @Category(value={Slow.class})
    @Test
    public void testSixInstances() throws Throwable {
        this.doTest(6, 9);
    }

    @Category(value={Slow.class})
    @Test
    public void testSevenInstances() throws Throwable {
        this.doTest(7, 10);
    }

    @Category(value={Slow.class})
    @Test
    public void testEightInstances() throws Throwable {
        this.doTest(8, 50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTest(int size, int loopCnt) throws Throwable {
        WithholdingAppender withholdingAppender = null;
        boolean failure = true;
        try {
            this.logger.info("doTest(" + size + "," + loopCnt + "): muting log output...");
            withholdingAppender = WithholdingAppender.install();
            this.doDoTest(size, loopCnt);
            failure = false;
        }
        finally {
            if (withholdingAppender != null) {
                if (failure) {
                    this.logger.info("doTest(" + size + "," + loopCnt + "): writing muted log output due to failure...");
                }
                withholdingAppender.release(failure);
                if (!failure) {
                    this.logger.info("doTest(" + size + "," + loopCnt + "): not writing muted log output due to success...");
                }
            }
            this.logger.info("doTest(" + size + "," + loopCnt + "): unmuted log output.");
        }
    }

    private void doDoTest(int size, int loopCnt) throws Throwable {
        int i;
        if (size < 2) {
            Assert.fail((String)"can only test 2 or more instances");
        }
        VirtualInstanceBuilder builder = this.newBuilder().newRepository("/var/discovery/impl/ClusterLoadTest/doTest-" + size + "-" + loopCnt + "/", true).setDebugName("firstInstance-" + size + "_" + loopCnt).setConnectorPingTimeout(3).setConnectorPingInterval(20).setMinEventDelay(0);
        VirtualInstance firstInstance = builder.build();
        firstInstance.startViewChecker(1);
        this.instances.add(firstInstance);
        for (i = 1; i < size; ++i) {
            VirtualInstanceBuilder builder2 = this.newBuilder().useRepositoryOf(builder).setDebugName("subsequentInstance-" + i + "-" + size + "_" + loopCnt).setConnectorPingTimeout(3).setMinEventDelay(0).setConnectorPingInterval(20);
            VirtualInstance subsequentInstance = builder2.build();
            this.instances.add(subsequentInstance);
            subsequentInstance.startViewChecker(1);
        }
        for (i = 0; i < loopCnt; ++i) {
            this.logger.info("=====================");
            this.logger.info(" START of LOOP " + i);
            this.logger.info("=====================");
            int aliveCnt = 0;
            for (VirtualInstance instance : this.instances) {
                if (!instance.isViewCheckerRunning()) continue;
                ++aliveCnt;
            }
            this.logger.info("=====================");
            this.logger.info(" original aliveCnt " + aliveCnt);
            this.logger.info("=====================");
            if (aliveCnt == 0) {
                aliveCnt = 1;
            }
            int aliveCntFinal = aliveCnt;
            for (VirtualInstance instance : this.instances) {
                try {
                    instance.dumpRepo();
                }
                catch (Exception e) {
                    this.logger.error("Failed dumping repo for instance " + instance.getSlingId(), (Throwable)e);
                }
            }
            for (VirtualInstance instance : this.instances) {
                if (!instance.isViewCheckerRunning()) continue;
                new RetryLoop((RetryLoop.Condition)new ConditionImplementation(instance, aliveCntFinal), 120, 500);
            }
            this.logger.info("Starting/Stopping heartbeats with count=" + this.instances.size());
            for (VirtualInstance instance : this.instances) {
                if (this.random.nextBoolean()) {
                    this.logger.info("Starting heartbeats with " + instance.slingId);
                    instance.startViewChecker(1);
                    this.logger.info("Started heartbeats with " + instance.slingId);
                    continue;
                }
                this.logger.info("Stopping heartbeats with " + instance.slingId);
                instance.stopViewChecker();
                this.logger.info("Stopped heartbeats with " + instance.slingId);
            }
        }
    }

    class ConditionImplementation
    implements RetryLoop.Condition {
        private final int expectedAliveCount;
        private final VirtualInstance instance;

        private ConditionImplementation(VirtualInstance instance, int expectedAliveCount) {
            this.expectedAliveCount = expectedAliveCount;
            this.instance = instance;
        }

        public boolean isTrue() throws Exception {
            boolean result = false;
            int actualAliveCount = -1;
            try {
                actualAliveCount = this.instance.getClusterViewService().getLocalClusterView().getInstances().size();
                result = this.expectedAliveCount == actualAliveCount;
            }
            catch (UndefinedClusterViewException e) {
                AbstractClusterLoadTest.this.logger.info("no view at the moment: " + (Object)((Object)e));
                return false;
            }
            catch (Exception e) {
                AbstractClusterLoadTest.this.logger.error("isTrue: got exception: " + e, (Throwable)e);
                throw e;
            }
            if (!result) {
                AbstractClusterLoadTest.this.logger.info("isTrue: expected=" + this.expectedAliveCount + ", actual=" + actualAliveCount + ", result=" + result);
            }
            return result;
        }

        public String getDescription() {
            return "Waiting for instance with " + this.instance.getSlingId() + " to see " + this.expectedAliveCount + " instances";
        }
    }
}

