/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.its.setup.mock;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.discovery.base.its.setup.mock.MockedResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockedResource
extends SyntheticResource {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final MockedResourceResolver mockedResourceResolver;
    private Session session;

    public MockedResource(MockedResourceResolver resourceResolver, String path, String resourceType) {
        super((ResourceResolver)resourceResolver, path, resourceType);
        this.mockedResourceResolver = resourceResolver;
        resourceResolver.register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session getSession() {
        MockedResource mockedResource = this;
        synchronized (mockedResource) {
            if (this.session == null) {
                try {
                    this.session = this.mockedResourceResolver.getSession();
                }
                catch (RepositoryException e) {
                    throw new RuntimeException("RepositoryException: " + (Object)((Object)e), e);
                }
            }
            return this.session;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        MockedResource mockedResource = this;
        synchronized (mockedResource) {
            if (this.session != null) {
                if (this.session.isLive()) {
                    this.session.logout();
                }
                this.session = null;
            }
        }
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type.equals(Node.class)) {
            try {
                return (AdapterType)this.getSession().getNode(this.getPath());
            }
            catch (Exception e) {
                this.logger.error("Exception occurred: " + e, (Throwable)e);
                throw new RuntimeException("Exception occurred: " + e, e);
            }
        }
        if (type.equals(ValueMap.class)) {
            try {
                Session session = this.getSession();
                Node node = session.getNode(this.getPath());
                HashMap<String, Object> map = new HashMap<String, Object>();
                PropertyIterator properties = node.getProperties();
                while (properties.hasNext()) {
                    Property p = properties.nextProperty();
                    if (p.getType() == 6) {
                        map.put(p.getName(), p.getBoolean());
                        continue;
                    }
                    if (p.getType() == 1) {
                        map.put(p.getName(), p.getString());
                        continue;
                    }
                    if (p.getType() == 5) {
                        map.put(p.getName(), p.getDate().getTime());
                        continue;
                    }
                    if (p.getType() == 7) {
                        map.put(p.getName(), p.getName());
                        continue;
                    }
                    if (p.getType() == 3) {
                        map.put(p.getName(), p.getLong());
                        continue;
                    }
                    throw new RuntimeException("Unsupported property type: " + p.getType());
                }
                ValueMapDecorator valueMap = new ValueMapDecorator(map);
                return (AdapterType)valueMap;
            }
            catch (Exception e) {
                this.logger.error("adaptTo failed with : " + e);
                return null;
            }
        }
        if (type.equals(ModifiableValueMap.class)) {
            return (AdapterType)new ModifiableValueMap(){

                public Collection<Object> values() {
                    throw new UnsupportedOperationException();
                }

                public int size() {
                    throw new UnsupportedOperationException();
                }

                public Object remove(Object arg0) {
                    Session session = MockedResource.this.getSession();
                    try {
                        Node node = session.getNode(MockedResource.this.getPath());
                        Property p = node.getProperty(String.valueOf(arg0));
                        if (p != null) {
                            p.remove();
                        }
                        return null;
                    }
                    catch (PathNotFoundException pnfe) {
                        return null;
                    }
                    catch (RepositoryException e) {
                        throw new RuntimeException(e);
                    }
                }

                public void putAll(Map<? extends String, ? extends Object> arg0) {
                    throw new UnsupportedOperationException();
                }

                public Object put(String arg0, Object arg1) {
                    Session session = MockedResource.this.getSession();
                    try {
                        Property previous;
                        Node node = session.getNode(MockedResource.this.getPath());
                        Object result = null;
                        if (node.hasProperty(arg0) && (previous = node.getProperty(arg0)) != null) {
                            if (previous.getType() == 1) {
                                result = previous.getString();
                            } else if (previous.getType() == 5) {
                                result = previous.getDate();
                            } else if (previous.getType() == 6) {
                                result = previous.getBoolean();
                            } else if (previous.getType() == 3) {
                                result = previous.getLong();
                            } else {
                                throw new UnsupportedOperationException();
                            }
                        }
                        if (arg1 instanceof String) {
                            node.setProperty(arg0, (String)arg1);
                        } else if (arg1 instanceof Calendar) {
                            node.setProperty(arg0, (Calendar)arg1);
                        } else if (arg1 instanceof Boolean) {
                            node.setProperty(arg0, ((Boolean)arg1).booleanValue());
                        } else if (arg1 instanceof Date) {
                            Calendar c = Calendar.getInstance();
                            c.setTime((Date)arg1);
                            node.setProperty(arg0, c);
                        } else if (arg1 instanceof Long) {
                            node.setProperty(arg0, ((Long)arg1).longValue());
                        } else if (arg1 == null) {
                            node.setProperty(arg0, (Value)null);
                        } else {
                            throw new UnsupportedOperationException();
                        }
                        return result;
                    }
                    catch (RepositoryException e) {
                        throw new RuntimeException(e);
                    }
                }

                public Set<String> keySet() {
                    Session session = MockedResource.this.getSession();
                    try {
                        Node node = session.getNode(MockedResource.this.getPath());
                        PropertyIterator pi = node.getProperties();
                        HashSet<String> result = new HashSet<String>();
                        while (pi.hasNext()) {
                            Property p = pi.nextProperty();
                            result.add(p.getName());
                        }
                        return result;
                    }
                    catch (RepositoryException e) {
                        throw new RuntimeException(e);
                    }
                }

                public boolean isEmpty() {
                    throw new UnsupportedOperationException();
                }

                public Object get(Object arg0) {
                    Session session = MockedResource.this.getSession();
                    try {
                        Node node = session.getNode(MockedResource.this.getPath());
                        String key = String.valueOf(arg0);
                        if (node.hasProperty(key)) {
                            return node.getProperty(key);
                        }
                        return null;
                    }
                    catch (RepositoryException re) {
                        throw new RuntimeException(re);
                    }
                }

                public Set<Map.Entry<String, Object>> entrySet() {
                    throw new UnsupportedOperationException();
                }

                public boolean containsValue(Object arg0) {
                    throw new UnsupportedOperationException();
                }

                public boolean containsKey(Object arg0) {
                    Session session = MockedResource.this.getSession();
                    try {
                        Node node = session.getNode(MockedResource.this.getPath());
                        return node.hasProperty(String.valueOf(arg0));
                    }
                    catch (RepositoryException re) {
                        throw new RuntimeException(re);
                    }
                }

                public void clear() {
                    throw new UnsupportedOperationException();
                }

                public <T> T get(String name, T defaultValue) {
                    throw new UnsupportedOperationException();
                }

                public <T> T get(String name, Class<T> type) {
                    Session session = MockedResource.this.getSession();
                    try {
                        Node node = session.getNode(MockedResource.this.getPath());
                        if (node == null) {
                            return null;
                        }
                        if (!node.hasProperty(name)) {
                            return null;
                        }
                        Property p = node.getProperty(name);
                        if (p == null) {
                            return null;
                        }
                        if (type.equals(Calendar.class)) {
                            return (T)p.getDate();
                        }
                        if (type.equals(String.class)) {
                            return (T)p.getString();
                        }
                        throw new UnsupportedOperationException();
                    }
                    catch (RepositoryException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
        return (AdapterType)super.adaptTo(type);
    }
}

