/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.its;

import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyView;
import org.apache.sling.discovery.base.its.setup.VirtualInstance;
import org.apache.sling.discovery.base.its.setup.VirtualInstanceBuilder;
import org.apache.sling.discovery.base.its.setup.mock.AssertingTopologyEventListener;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTopologyEventTest {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private VirtualInstance instance1;
    private VirtualInstance instance2;
    private Level logLevel;

    @Before
    public void setup() throws Exception {
        LogManager.getRootLogger();
        org.apache.log4j.Logger discoveryLogger = org.apache.log4j.Logger.getLogger((String)"org.apache.sling.discovery");
        this.logLevel = discoveryLogger.getLevel();
        discoveryLogger.setLevel(Level.DEBUG);
    }

    @After
    public void tearDown() throws Throwable {
        if (this.instance1 != null) {
            this.instance1.stopViewChecker();
            this.instance1.stop();
            this.instance1 = null;
        }
        if (this.instance2 != null) {
            this.instance2.stopViewChecker();
            this.instance2.stop();
            this.instance2 = null;
        }
        LogManager.getRootLogger();
        org.apache.log4j.Logger discoveryLogger = org.apache.log4j.Logger.getLogger((String)"org.apache.sling.discovery");
        discoveryLogger.setLevel(this.logLevel);
    }

    public abstract VirtualInstanceBuilder newBuilder();

    @Test
    public void testDelayedInitEvent() throws Throwable {
        this.logger.info("testDelayedInitEvent: start");
        this.instance1 = this.newBuilder().setDebugName("firstInstanceA").newRepository("/var/discovery/impl/", true).setConnectorPingTimeout(3).setMinEventDelay(3).build();
        AssertingTopologyEventListener l1 = new AssertingTopologyEventListener("instance1.l1");
        l1.addExpected(TopologyEvent.Type.TOPOLOGY_INIT);
        this.instance1.bindTopologyEventListener(l1);
        this.logger.info("testDelayedInitEvent: instance1 created, no events expected yet. slingId=" + this.instance1.slingId);
        this.instance1.heartbeatsAndCheckView();
        Thread.sleep(1200L);
        this.instance1.heartbeatsAndCheckView();
        Thread.sleep(1200L);
        this.instance1.heartbeatsAndCheckView();
        Thread.sleep(1200L);
        this.logger.info("testDelayedInitEvent: 2nd/3rd heartbeat sent - now expecting a TOPOLOGY_INIT");
        this.instance1.dumpRepo();
        Assert.assertEquals((long)1L, (long)l1.getEvents().size());
        Assert.assertEquals((long)0L, (long)l1.getRemainingExpectedCount());
        Assert.assertEquals((long)0L, (long)l1.getUnexpectedCount());
        this.logger.info("testDelayedInitEvent: creating instance2");
        this.instance2 = this.newBuilder().setDebugName("secondInstanceB").useRepositoryOf(this.instance1).setConnectorPingTimeout(20).setMinEventDelay(3).build();
        this.logger.info("testDelayedInitEvent: instance2 created with slingId=" + this.instance2.slingId);
        AssertingTopologyEventListener l2 = new AssertingTopologyEventListener("instance2.l2");
        this.instance2.bindTopologyEventListener(l2);
        this.logger.info("testDelayedInitEvent: listener instance2.l2 added - it should not get any events though");
        AssertingTopologyEventListener l1Two = new AssertingTopologyEventListener("instance1.l1Two");
        l1Two.addExpected(TopologyEvent.Type.TOPOLOGY_INIT);
        this.logger.info("testDelayedInitEvent: listener instance1.l1Two added - it expects an INIT now");
        this.instance1.bindTopologyEventListener(l1Two);
        Thread.sleep(500L);
        Assert.assertEquals((long)1L, (long)l1.getEvents().size());
        Assert.assertEquals((long)0L, (long)l1.getRemainingExpectedCount());
        Assert.assertEquals((long)0L, (long)l1.getUnexpectedCount());
        Assert.assertEquals((long)0L, (long)l2.getEvents().size());
        Assert.assertEquals((long)0L, (long)l2.getUnexpectedCount());
        Assert.assertEquals((long)1L, (long)l1Two.getEvents().size());
        Assert.assertEquals((long)0L, (long)l1Two.getRemainingExpectedCount());
        Assert.assertEquals((long)0L, (long)l1Two.getUnexpectedCount());
        this.logger.info("testDelayedInitEvent: two more heartbeats should trigger events");
        l1.addExpected(TopologyEvent.Type.TOPOLOGY_CHANGING);
        l1Two.addExpected(TopologyEvent.Type.TOPOLOGY_CHANGING);
        Thread.sleep(500L);
        l2.addExpected(TopologyEvent.Type.TOPOLOGY_INIT);
        this.instance1.heartbeatsAndCheckView();
        this.instance2.heartbeatsAndCheckView();
        Thread.sleep(500L);
        this.instance1.heartbeatsAndCheckView();
        this.instance2.heartbeatsAndCheckView();
        Thread.sleep(500L);
        this.instance1.heartbeatsAndCheckView();
        this.instance2.heartbeatsAndCheckView();
        this.logger.info("testDelayedInitEvent: instance1: " + this.instance1.slingId);
        this.logger.info("testDelayedInitEvent: instance2: " + this.instance2.slingId);
        this.instance1.dumpRepo();
        Assert.assertEquals((long)0L, (long)l1.getUnexpectedCount());
        Assert.assertEquals((long)2L, (long)l1.getEvents().size());
        Assert.assertEquals((long)0L, (long)l2.getUnexpectedCount());
        Assert.assertEquals((long)0L, (long)l1Two.getUnexpectedCount());
        Assert.assertEquals((long)2L, (long)l1Two.getEvents().size());
        l1.addExpected(TopologyEvent.Type.TOPOLOGY_CHANGED);
        l1Two.addExpected(TopologyEvent.Type.TOPOLOGY_CHANGED);
        Thread.sleep(4000L);
        Assert.assertEquals((long)0L, (long)l1.getUnexpectedCount());
        Assert.assertEquals((long)3L, (long)l1.getEvents().size());
        Assert.assertEquals((long)0L, (long)l2.getUnexpectedCount());
        Assert.assertEquals((long)1L, (long)l2.getEvents().size());
        Assert.assertEquals((long)0L, (long)l1Two.getUnexpectedCount());
        Assert.assertEquals((long)3L, (long)l1Two.getEvents().size());
        this.logger.info("testDelayedInitEvent: end");
    }

    @Test
    public void testGetDuringDelay() throws Throwable {
        this.instance1 = this.newBuilder().setDebugName("firstInstanceA").newRepository("/var/discovery/impl/", true).setConnectorPingTimeout(20).setMinEventDelay(6).build();
        AssertingTopologyEventListener l1 = new AssertingTopologyEventListener("instance1.l1");
        l1.addExpected(TopologyEvent.Type.TOPOLOGY_INIT);
        this.instance1.bindTopologyEventListener(l1);
        TopologyView earlyTopo = this.instance1.getDiscoveryService().getTopology();
        Assert.assertNotNull((Object)earlyTopo);
        Assert.assertFalse((boolean)earlyTopo.isCurrent());
        Assert.assertEquals((long)1L, (long)earlyTopo.getInstances().size());
        for (int i = 0; i < 4; ++i) {
            this.instance1.heartbeatsAndCheckView();
            Thread.sleep(125L);
        }
        TopologyView secondTopo = this.instance1.getDiscoveryService().getTopology();
        Assert.assertEquals((long)1L, (long)secondTopo.getInstances().size());
        Assert.assertEquals((Object)this.instance1.getSlingId(), (Object)((InstanceDescription)secondTopo.getInstances().iterator().next()).getSlingId());
        Assert.assertTrue((boolean)secondTopo.isCurrent());
        this.instance1.dumpRepo();
        this.assertEarlyAndFirstClusterViewIdMatches(earlyTopo, secondTopo);
        Thread.sleep(500L);
        Assert.assertEquals((long)0L, (long)l1.getRemainingExpectedCount());
        Assert.assertEquals((long)0L, (long)l1.getUnexpectedCount());
        l1.addExpected(TopologyEvent.Type.TOPOLOGY_CHANGING);
        this.instance2 = this.newBuilder().setDebugName("secondInstanceB").useRepositoryOf(this.instance1).setConnectorPingTimeout(20).setMinEventDelay(1).build();
        AssertingTopologyEventListener l2 = new AssertingTopologyEventListener("instance2.l1");
        l2.addExpected(TopologyEvent.Type.TOPOLOGY_INIT);
        this.instance2.bindTopologyEventListener(l2);
        for (int i = 0; i < 4; ++i) {
            this.instance2.heartbeatsAndCheckView();
            this.instance1.heartbeatsAndCheckView();
            Thread.sleep(750L);
        }
        Assert.assertEquals((long)0L, (long)l1.getUnexpectedCount());
        TopologyView topo2 = this.instance2.getDiscoveryService().getTopology();
        Assert.assertTrue((boolean)topo2.isCurrent());
        Assert.assertEquals((long)2L, (long)topo2.getInstances().size());
        TopologyView topo1 = this.instance1.getDiscoveryService().getTopology();
        Assert.assertTrue((boolean)topo1.isCurrent());
        Assert.assertEquals((long)2L, (long)topo1.getInstances().size());
        l1.addExpected(TopologyEvent.Type.TOPOLOGY_CHANGED);
        Thread.sleep(5000L);
        Assert.assertEquals((long)0L, (long)l1.getRemainingExpectedCount());
        Assert.assertEquals((long)0L, (long)l1.getUnexpectedCount());
        Assert.assertEquals((long)0L, (long)l2.getRemainingExpectedCount());
        Assert.assertEquals((long)0L, (long)l2.getUnexpectedCount());
        Assert.assertTrue((boolean)this.instance2.getDiscoveryService().getTopology().isCurrent());
        Assert.assertEquals((long)2L, (long)this.instance2.getDiscoveryService().getTopology().getInstances().size());
        Assert.assertTrue((boolean)this.instance1.getDiscoveryService().getTopology().isCurrent());
        Assert.assertEquals((long)2L, (long)this.instance1.getDiscoveryService().getTopology().getInstances().size());
    }

    public abstract void assertEarlyAndFirstClusterViewIdMatches(TopologyView var1, TopologyView var2);
}

