/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.connectors.announcement;

import java.util.List;
import java.util.UUID;
import javax.jcr.Session;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.testing.jcr.RepositoryProvider;
import org.apache.sling.discovery.ClusterView;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.base.connectors.BaseConfig;
import org.apache.sling.discovery.base.connectors.announcement.Announcement;
import org.apache.sling.discovery.base.connectors.announcement.AnnouncementFilter;
import org.apache.sling.discovery.base.connectors.announcement.AnnouncementRegistryImpl;
import org.apache.sling.discovery.base.its.setup.TopologyHelper;
import org.apache.sling.discovery.base.its.setup.VirtualInstanceHelper;
import org.apache.sling.discovery.base.its.setup.mock.MockFactory;
import org.apache.sling.discovery.base.its.setup.mock.SimpleConnectorConfig;
import org.apache.sling.discovery.commons.providers.DefaultClusterView;
import org.apache.sling.discovery.commons.providers.DefaultInstanceDescription;
import org.apache.sling.discovery.commons.providers.spi.base.DummySlingSettingsService;
import org.apache.sling.settings.SlingSettingsService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AnnouncementRegistryImplTest {
    private AnnouncementRegistryImpl registry;
    private String slingId;
    private ResourceResolverFactory resourceResolverFactory;
    private BaseConfig config;

    @Before
    public void setup() throws Exception {
        this.resourceResolverFactory = MockFactory.mockResourceResolverFactory();
        this.config = new SimpleConnectorConfig(){

            @Override
            public long getConnectorPingTimeout() {
                return 10L;
            }
        };
        this.slingId = UUID.randomUUID().toString();
        Session l = RepositoryProvider.instance().getRepository().loginAdministrative(null);
        try {
            l.removeItem("/var");
            l.save();
            l.logout();
        }
        catch (Exception e) {
            l.refresh(false);
            l.logout();
        }
        this.registry = AnnouncementRegistryImpl.testConstructorAndActivate((ResourceResolverFactory)this.resourceResolverFactory, (SlingSettingsService)new DummySlingSettingsService(this.slingId), (BaseConfig)this.config);
    }

    @Test
    public void testRegisterUnregister() throws Exception {
        try {
            this.registry.registerAnnouncement(null);
            Assert.fail((String)"should complain");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.registry.unregisterAnnouncement(null);
            Assert.fail((String)"should complain");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.registry.unregisterAnnouncement("");
            Assert.fail((String)"should complain");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new Announcement(null);
            Assert.fail((String)"should complain");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new Announcement("");
            Assert.fail((String)"should complain");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Announcement ann = new Announcement(this.slingId);
        Assert.assertFalse((boolean)ann.isValid());
        Assert.assertFalse((this.registry.registerAnnouncement(ann) != -1L ? 1 : 0) != 0);
        DefaultClusterView localCluster = new DefaultClusterView(UUID.randomUUID().toString());
        ann.setLocalCluster((ClusterView)localCluster);
        Assert.assertFalse((boolean)ann.isValid());
        Assert.assertFalse((this.registry.registerAnnouncement(ann) != -1L ? 1 : 0) != 0);
        try {
            this.registry.listInstances((ClusterView)localCluster);
            Assert.fail((String)"doing getInstances() on an empty cluster should throw an illegalstateexception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        DefaultInstanceDescription instance = TopologyHelper.createInstanceDescription(ann.getOwnerId(), true, (ClusterView)localCluster);
        Assert.assertEquals((Object)instance.getSlingId(), (Object)ann.getOwnerId());
        Assert.assertTrue((boolean)ann.isValid());
        Assert.assertTrue((this.registry.registerAnnouncement(ann) != -1L ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)this.registry.listInstances((ClusterView)localCluster).size());
        this.registry.checkExpiredAnnouncements();
        Assert.assertEquals((long)1L, (long)this.registry.listInstances((ClusterView)localCluster).size());
        this.registry.unregisterAnnouncement(ann.getOwnerId());
        Assert.assertEquals((long)0L, (long)this.registry.listInstances((ClusterView)localCluster).size());
        Assert.assertTrue((boolean)ann.isValid());
        Assert.assertTrue((this.registry.registerAnnouncement(ann) != -1L ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)this.registry.listInstances((ClusterView)localCluster).size());
        Thread.sleep(10500L);
        Assert.assertEquals((long)0L, (long)this.registry.listInstances((ClusterView)localCluster).size());
    }

    @Test
    public void testLists() throws Exception {
        try {
            this.registry.listAnnouncementsInSameCluster(null);
            Assert.fail((String)"should complain");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.registry.listAnnouncementsInSameCluster(null);
            Assert.fail((String)"should complain");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)this.registry.listLocalAnnouncements().size());
        Assert.assertEquals((long)0L, (long)this.registry.listLocalIncomingAnnouncements().size());
        DefaultClusterView localCluster = new DefaultClusterView(UUID.randomUUID().toString());
        DefaultInstanceDescription instance = TopologyHelper.createInstanceDescription(this.slingId, true, (ClusterView)localCluster);
        Assert.assertEquals((long)0L, (long)this.registry.listAnnouncementsInSameCluster((ClusterView)localCluster).size());
        Assert.assertEquals((long)0L, (long)this.registry.listLocalAnnouncements().size());
        Assert.assertEquals((long)0L, (long)this.registry.listLocalIncomingAnnouncements().size());
        Announcement ann = new Announcement(this.slingId);
        ann.setLocalCluster((ClusterView)localCluster);
        ann.setInherited(true);
        this.registry.registerAnnouncement(ann);
        Assert.assertEquals((long)1L, (long)this.registry.listAnnouncementsInSameCluster((ClusterView)localCluster).size());
        Assert.assertEquals((long)1L, (long)this.registry.listLocalAnnouncements().size());
        Assert.assertEquals((long)0L, (long)this.registry.listLocalIncomingAnnouncements().size());
        ann.setInherited(true);
        Assert.assertEquals((long)0L, (long)this.registry.listLocalIncomingAnnouncements().size());
        Assert.assertTrue((boolean)this.registry.hasActiveAnnouncement(this.slingId));
        Assert.assertFalse((boolean)this.registry.hasActiveAnnouncement(UUID.randomUUID().toString()));
        this.registry.unregisterAnnouncement(this.slingId);
        Assert.assertEquals((long)0L, (long)this.registry.listAnnouncementsInSameCluster((ClusterView)localCluster).size());
        Assert.assertEquals((long)0L, (long)this.registry.listLocalAnnouncements().size());
        Assert.assertEquals((long)0L, (long)this.registry.listLocalIncomingAnnouncements().size());
        Assert.assertFalse((boolean)this.registry.hasActiveAnnouncement(this.slingId));
        Assert.assertFalse((boolean)this.registry.hasActiveAnnouncement(UUID.randomUUID().toString()));
        ann.setInherited(false);
        this.registry.registerAnnouncement(ann);
        Assert.assertEquals((long)1L, (long)this.registry.listAnnouncementsInSameCluster((ClusterView)localCluster).size());
        Assert.assertEquals((long)1L, (long)this.registry.listLocalAnnouncements().size());
        Assert.assertEquals((long)1L, (long)this.registry.listLocalIncomingAnnouncements().size());
        Assert.assertTrue((boolean)this.registry.hasActiveAnnouncement(this.slingId));
        Assert.assertFalse((boolean)this.registry.hasActiveAnnouncement(UUID.randomUUID().toString()));
        this.registry.unregisterAnnouncement(this.slingId);
        Assert.assertEquals((long)0L, (long)this.registry.listAnnouncementsInSameCluster((ClusterView)localCluster).size());
        Assert.assertEquals((long)0L, (long)this.registry.listLocalAnnouncements().size());
        Assert.assertEquals((long)0L, (long)this.registry.listLocalIncomingAnnouncements().size());
        Assert.assertFalse((boolean)this.registry.hasActiveAnnouncement(this.slingId));
        Assert.assertFalse((boolean)this.registry.hasActiveAnnouncement(UUID.randomUUID().toString()));
        Assert.assertEquals((long)1L, (long)ann.listInstances().size());
        this.registry.addAllExcept(ann, (ClusterView)localCluster, new AnnouncementFilter(){

            public boolean accept(String receivingSlingId, Announcement announcement) {
                Assert.assertNotNull((Object)receivingSlingId);
                Assert.assertNotNull((Object)announcement);
                return true;
            }
        });
        Assert.assertEquals((long)1L, (long)ann.listInstances().size());
        this.registry.registerAnnouncement(this.createAnnouncement(this.createCluster(3), 1, false));
        Assert.assertEquals((long)1L, (long)this.registry.listAnnouncementsInSameCluster((ClusterView)localCluster).size());
        Assert.assertEquals((long)3L, (long)this.registry.listInstances((ClusterView)localCluster).size());
        this.registry.addAllExcept(ann, (ClusterView)localCluster, new AnnouncementFilter(){

            public boolean accept(String receivingSlingId, Announcement announcement) {
                Assert.assertNotNull((Object)receivingSlingId);
                Assert.assertNotNull((Object)announcement);
                return true;
            }
        });
        Assert.assertEquals((long)4L, (long)ann.listInstances().size());
        this.registry.registerAnnouncement(ann);
        Assert.assertEquals((long)2L, (long)this.registry.listAnnouncementsInSameCluster((ClusterView)localCluster).size());
    }

    private ClusterView createCluster(int numInstances) {
        DefaultClusterView localCluster = new DefaultClusterView(UUID.randomUUID().toString());
        for (int i = 0; i < numInstances; ++i) {
            DefaultInstanceDescription defaultInstanceDescription = TopologyHelper.createInstanceDescription(UUID.randomUUID().toString(), i == 0, (ClusterView)localCluster);
        }
        return localCluster;
    }

    private ClusterView createCluster(String ... instanceIds) {
        DefaultClusterView localCluster = new DefaultClusterView(UUID.randomUUID().toString());
        for (int i = 0; i < instanceIds.length; ++i) {
            DefaultInstanceDescription defaultInstanceDescription = TopologyHelper.createInstanceDescription(instanceIds[i], i == 0, (ClusterView)localCluster);
        }
        return localCluster;
    }

    private Announcement createAnnouncement(ClusterView remoteCluster, int ownerIndex, boolean inherited) {
        List instances = remoteCluster.getInstances();
        Announcement ann = new Announcement(((InstanceDescription)instances.get(ownerIndex)).getSlingId());
        ann.setInherited(inherited);
        ann.setLocalCluster(remoteCluster);
        return ann;
    }

    @Test
    public void testExpiry() throws InterruptedException, NoSuchFieldException {
        ClusterView cluster1 = this.createCluster(4);
        ClusterView cluster2 = this.createCluster(3);
        ClusterView cluster3 = this.createCluster(5);
        ClusterView myCluster = this.createCluster(this.slingId);
        Announcement ann1 = this.createAnnouncement(cluster1, 0, true);
        Announcement ann2 = this.createAnnouncement(cluster2, 1, true);
        Announcement ann3 = this.createAnnouncement(cluster3, 1, false);
        Assert.assertTrue((this.registry.registerAnnouncement(ann1) != -1L ? 1 : 0) != 0);
        Assert.assertTrue((this.registry.registerAnnouncement(ann2) != -1L ? 1 : 0) != 0);
        Assert.assertTrue((this.registry.registerAnnouncement(ann3) != -1L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.registry.hasActiveAnnouncement(((InstanceDescription)cluster1.getInstances().get(0)).getSlingId()));
        Assert.assertTrue((boolean)this.registry.hasActiveAnnouncement(((InstanceDescription)cluster2.getInstances().get(1)).getSlingId()));
        Assert.assertTrue((boolean)this.registry.hasActiveAnnouncement(((InstanceDescription)cluster3.getInstances().get(1)).getSlingId()));
        Assert.assertEquals((long)3L, (long)this.registry.listAnnouncementsInSameCluster(myCluster).size());
        Assert.assertEquals((long)3L, (long)this.registry.listLocalAnnouncements().size());
        Assert.assertEquals((long)1L, (long)this.registry.listLocalIncomingAnnouncements().size());
        Announcement testAnn = this.createAnnouncement(myCluster, 0, false);
        Assert.assertEquals((long)1L, (long)testAnn.listInstances().size());
        this.registry.addAllExcept(testAnn, myCluster, null);
        Assert.assertEquals((long)13L, (long)testAnn.listInstances().size());
        Thread.sleep(10500L);
        testAnn = this.createAnnouncement(myCluster, 0, false);
        Assert.assertEquals((long)1L, (long)testAnn.listInstances().size());
        this.registry.addAllExcept(testAnn, myCluster, null);
        Assert.assertEquals((long)13L, (long)testAnn.listInstances().size());
        Assert.assertTrue((this.registry.registerAnnouncement(ann3) != -1L ? 1 : 0) != 0);
        testAnn = this.createAnnouncement(myCluster, 0, false);
        Assert.assertEquals((long)1L, (long)testAnn.listInstances().size());
        this.registry.addAllExcept(testAnn, myCluster, null);
        Assert.assertEquals((long)13L, (long)testAnn.listInstances().size());
        this.registry.checkExpiredAnnouncements();
        Assert.assertEquals((long)1L, (long)this.registry.listAnnouncementsInSameCluster(myCluster).size());
        Assert.assertEquals((long)1L, (long)this.registry.listLocalAnnouncements().size());
        Assert.assertEquals((long)1L, (long)this.registry.listLocalIncomingAnnouncements().size());
        Assert.assertFalse((boolean)this.registry.hasActiveAnnouncement(((InstanceDescription)cluster1.getInstances().get(0)).getSlingId()));
        Assert.assertFalse((boolean)this.registry.hasActiveAnnouncement(((InstanceDescription)cluster2.getInstances().get(1)).getSlingId()));
        Assert.assertTrue((boolean)this.registry.hasActiveAnnouncement(((InstanceDescription)cluster3.getInstances().get(1)).getSlingId()));
        testAnn = this.createAnnouncement(myCluster, 0, false);
        Assert.assertEquals((long)1L, (long)testAnn.listInstances().size());
        this.registry.addAllExcept(testAnn, myCluster, null);
        Assert.assertEquals((long)6L, (long)testAnn.listInstances().size());
    }

    @Test
    public void testCluster() throws Exception {
        ClusterView cluster1 = this.createCluster(2);
        ClusterView cluster2 = this.createCluster(4);
        ClusterView cluster3 = this.createCluster(7);
        Announcement ann1 = this.createAnnouncement(cluster1, 1, true);
        Announcement ann2 = this.createAnnouncement(cluster2, 2, true);
        Announcement ann3 = this.createAnnouncement(cluster3, 3, false);
        String instance1 = UUID.randomUUID().toString();
        String instance2 = UUID.randomUUID().toString();
        String instance3 = UUID.randomUUID().toString();
        ClusterView myCluster = this.createCluster(instance1, instance2, instance3);
        AnnouncementRegistryImpl registry1 = AnnouncementRegistryImpl.testConstructorAndActivate((ResourceResolverFactory)this.resourceResolverFactory, (SlingSettingsService)new DummySlingSettingsService(instance1), (BaseConfig)this.config);
        AnnouncementRegistryImpl registry2 = AnnouncementRegistryImpl.testConstructorAndActivate((ResourceResolverFactory)this.resourceResolverFactory, (SlingSettingsService)new DummySlingSettingsService(instance2), (BaseConfig)this.config);
        AnnouncementRegistryImpl registry3 = AnnouncementRegistryImpl.testConstructorAndActivate((ResourceResolverFactory)this.resourceResolverFactory, (SlingSettingsService)new DummySlingSettingsService(instance3), (BaseConfig)this.config);
        Assert.assertTrue((registry1.registerAnnouncement(ann1) != -1L ? 1 : 0) != 0);
        Assert.assertTrue((registry2.registerAnnouncement(ann2) != -1L ? 1 : 0) != 0);
        Assert.assertTrue((registry3.registerAnnouncement(ann3) != -1L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)registry1.hasActiveAnnouncement(((InstanceDescription)cluster1.getInstances().get(1)).getSlingId()));
        Assert.assertTrue((boolean)registry2.hasActiveAnnouncement(((InstanceDescription)cluster2.getInstances().get(2)).getSlingId()));
        Assert.assertTrue((boolean)registry3.hasActiveAnnouncement(((InstanceDescription)cluster3.getInstances().get(3)).getSlingId()));
        Assert.assertEquals((long)3L, (long)registry1.listAnnouncementsInSameCluster(myCluster).size());
        Assert.assertEquals((long)1L, (long)registry1.listLocalAnnouncements().size());
        Assert.assertEquals((long)0L, (long)registry1.listLocalIncomingAnnouncements().size());
        this.assertAnnouncements(registry1, myCluster, 4, 16);
        Assert.assertEquals((long)3L, (long)registry2.listAnnouncementsInSameCluster(myCluster).size());
        Assert.assertEquals((long)1L, (long)registry2.listLocalAnnouncements().size());
        Assert.assertEquals((long)0L, (long)registry2.listLocalIncomingAnnouncements().size());
        this.assertAnnouncements(registry2, myCluster, 4, 16);
        Assert.assertEquals((long)3L, (long)registry3.listAnnouncementsInSameCluster(myCluster).size());
        Assert.assertEquals((long)1L, (long)registry3.listLocalAnnouncements().size());
        Assert.assertEquals((long)1L, (long)registry3.listLocalIncomingAnnouncements().size());
        this.assertAnnouncements(registry3, myCluster, 4, 16);
        myCluster = this.createCluster(instance1, instance2);
        VirtualInstanceHelper.dumpRepo(this.resourceResolverFactory);
        Assert.assertEquals((long)2L, (long)registry1.listAnnouncementsInSameCluster(myCluster).size());
        Assert.assertEquals((long)1L, (long)registry1.listLocalAnnouncements().size());
        Assert.assertEquals((long)0L, (long)registry1.listLocalIncomingAnnouncements().size());
        this.assertAnnouncements(registry1, myCluster, 3, 8);
        Assert.assertEquals((long)2L, (long)registry2.listAnnouncementsInSameCluster(myCluster).size());
        Assert.assertEquals((long)1L, (long)registry2.listLocalAnnouncements().size());
        Assert.assertEquals((long)0L, (long)registry2.listLocalIncomingAnnouncements().size());
        this.assertAnnouncements(registry2, myCluster, 3, 8);
        Thread.sleep(10500L);
        this.assertAnnouncements(registry1, myCluster, 3, 8);
        this.assertAnnouncements(registry2, myCluster, 3, 8);
        registry1.checkExpiredAnnouncements();
        registry2.checkExpiredAnnouncements();
        this.assertAnnouncements(registry1, myCluster, 1, 2);
        this.assertAnnouncements(registry2, myCluster, 1, 2);
    }

    private void assertAnnouncements(AnnouncementRegistryImpl registry, ClusterView myCluster, int expectedNumAnnouncements, int expectedNumInstances) {
        Announcement ann = this.createAnnouncement(myCluster, 0, false);
        registry.addAllExcept(ann, myCluster, null);
        Assert.assertEquals((long)expectedNumInstances, (long)ann.listInstances().size());
    }
}

