/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cta.impl;

import java.util.Objects;

abstract class Log {
    private static Log INSTANCE;

    public static void configure(String spec) {
        boolean isVerbose = "v".equals(spec);
        boolean isExtraVerbose = "vv".equals(spec);
        INSTANCE = isVerbose || isExtraVerbose ? new ConsoleLog(isExtraVerbose) : new NoopLog();
    }

    public static Log get() {
        return Objects.requireNonNull(INSTANCE, "Log is null, did you foget to call Log.configure() ?");
    }

    private Log() {
    }

    public abstract void log(String var1, Object ... var2);

    public abstract void trace(String var1, Object ... var2);

    public abstract void fatal(String var1, Throwable var2);

    static class NoopLog
    extends Log {
        NoopLog() {
        }

        @Override
        public void log(String msg, Object ... args) {
        }

        @Override
        public void fatal(String message, Throwable t) {
        }

        @Override
        public void trace(String msg, Object ... args) {
        }
    }

    static class ConsoleLog
    extends Log {
        private static final String LOG_ENTRY_PREFIX = "[AGENT] ";
        private final boolean trace;

        ConsoleLog(boolean trace) {
            this.trace = trace;
        }

        @Override
        public void log(String msg, Object ... args) {
            System.out.format(LOG_ENTRY_PREFIX + msg + " %n", args);
        }

        @Override
        public void trace(String msg, Object ... args) {
            if (!this.trace) {
                return;
            }
            this.log(msg, args);
        }

        @Override
        public void fatal(String msg, Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(LOG_ENTRY_PREFIX + msg, t);
        }
    }
}

