/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.scheduler.impl;

import java.util.Date;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.commons.scheduler.Job;
import org.apache.sling.commons.scheduler.impl.QuartzScheduler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class WhiteboardHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private QuartzScheduler scheduler;
    private ServiceTracker serviceTracker;

    @Activate
    protected void activate(final BundleContext btx) throws InvalidSyntaxException {
        this.serviceTracker = new ServiceTracker(btx, btx.createFilter("(|(objectClass=" + Runnable.class.getName() + ")" + "(" + "objectClass" + "=" + Job.class.getName() + "))"), new ServiceTrackerCustomizer(){

            public synchronized void removedService(ServiceReference reference, Object service) {
                btx.ungetService(reference);
                WhiteboardHandler.this.unregister(reference, service);
            }

            public synchronized void modifiedService(ServiceReference reference, Object service) {
                WhiteboardHandler.this.unregister(reference, service);
                WhiteboardHandler.this.register(reference, service);
            }

            public synchronized Object addingService(ServiceReference reference) {
                Object obj = btx.getService(reference);
                if (obj != null) {
                    WhiteboardHandler.this.register(reference, obj);
                }
                return obj;
            }
        });
        this.serviceTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        if (this.serviceTracker != null) {
            this.serviceTracker.close();
            this.serviceTracker = null;
        }
    }

    private String getServiceIdentifier(ServiceReference ref) {
        String name = (String)ref.getProperty("scheduler.name");
        if (name == null && (name = (String)ref.getProperty("service.pid")) == null) {
            name = "Registered Service";
        }
        name = name + "." + ref.getProperty("service.id");
        return name;
    }

    private void register(ServiceReference ref, Object job) {
        String name = this.getServiceIdentifier(ref);
        Boolean concurrent = (Boolean)ref.getProperty("scheduler.concurrent");
        Object runOn = ref.getProperty("scheduler.runOn");
        String[] runOnOpts = null;
        if (runOn instanceof String) {
            runOnOpts = new String[]{runOn.toString()};
        } else if (runOn instanceof String[]) {
            runOnOpts = (String[])runOn;
        } else if (runOn != null) {
            this.logger.warn("Property {} ignored for scheduler {}", (Object)"scheduler.runOn", (Object)ref);
        }
        String expression = (String)ref.getProperty("scheduler.expression");
        if (expression != null) {
            this.scheduler.schedule(ref.getBundle().getBundleId(), (Long)ref.getProperty("service.id"), job, this.scheduler.EXPR(expression).name(name).canRunConcurrently(concurrent != null ? concurrent : true).onInstancesOnly(runOnOpts));
        } else {
            Long period = (Long)ref.getProperty("scheduler.period");
            if (period != null) {
                if (period < 1L) {
                    this.logger.debug("Ignoring service {} : scheduler period is less than 1.", (Object)ref);
                } else {
                    Integer times;
                    boolean immediate = false;
                    if (ref.getProperty("scheduler.immediate") != null) {
                        immediate = (Boolean)ref.getProperty("scheduler.immediate");
                    }
                    Date date = new Date();
                    if (!immediate) {
                        date.setTime(System.currentTimeMillis() + period * 1000L);
                    }
                    if ((times = (Integer)ref.getProperty("scheduler.times")) != null && times < 1) {
                        this.logger.debug("Ignoring service {} : scheduler times is less than 1.", (Object)ref);
                    } else {
                        int t = times != null ? times : -1;
                        this.scheduler.schedule(ref.getBundle().getBundleId(), (Long)ref.getProperty("service.id"), job, this.scheduler.AT(date, t, period).name(name).canRunConcurrently(concurrent != null ? concurrent : true).onInstancesOnly(runOnOpts));
                    }
                }
            } else {
                this.logger.debug("Ignoring servce {} : no scheduling property found.", (Object)ref);
            }
        }
    }

    private void unregister(ServiceReference reference, Object service) {
        String name = this.getServiceIdentifier(reference);
        this.scheduler.unschedule(reference.getBundle().getBundleId(), name);
    }

    protected void bindScheduler(QuartzScheduler quartzScheduler) {
        this.scheduler = quartzScheduler;
    }

    protected void unbindScheduler(QuartzScheduler quartzScheduler) {
        if (this.scheduler == quartzScheduler) {
            this.scheduler = null;
        }
    }
}

