/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.scheduler.impl;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.sling.commons.scheduler.impl.QuartzJobExecutor;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

@Component
public class SettingsSupport {
    private static final String SETTINGS_NAME = "org.apache.sling.settings.SlingSettingsService";
    private volatile Listener settingsListener;

    @Activate
    protected void activate(BundleContext bc) {
        this.settingsListener = new Listener(bc);
        this.settingsListener.start();
    }

    @Deactivate
    protected void deactivate() {
        if (this.settingsListener != null) {
            this.settingsListener.stop();
            this.settingsListener = null;
        }
    }

    protected static final class Listener
    implements ServiceListener {
        private final BundleContext bundleContext;
        private final AtomicBoolean active = new AtomicBoolean(false);

        public Listener(BundleContext bundleContext) {
            this.bundleContext = bundleContext;
        }

        public void start() {
            try {
                this.bundleContext.addServiceListener((ServiceListener)this, "(objectClass=org.apache.sling.settings.SlingSettingsService)");
            }
            catch (InvalidSyntaxException ise) {
                throw new RuntimeException("Unexpected exception occured.", ise);
            }
            this.active.set(true);
            this.retainService();
        }

        public void stop() {
            if (this.active.compareAndSet(true, false)) {
                this.bundleContext.removeServiceListener((ServiceListener)this);
            }
        }

        private synchronized void retainService() {
            SlingSettingsService service;
            ServiceReference reference = this.bundleContext.getServiceReference(SettingsSupport.SETTINGS_NAME);
            if (reference != null && (service = (SlingSettingsService)this.bundleContext.getService(reference)) != null) {
                QuartzJobExecutor.SLING_ID = service.getSlingId();
                this.bundleContext.ungetService(reference);
                this.stop();
            }
        }

        public void serviceChanged(ServiceEvent event) {
            if (event.getType() == 1) {
                this.retainService();
            }
        }
    }
}

