/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.scheduler.impl;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.scheduler.impl.QuartzScheduler;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.matchers.GroupMatcher;

@Component
@Service(value={WebConsolePrinter.class})
@Properties(value={@Property(name="service.description", value={"Apache Sling Scheduler Configuration Printer"}), @Property(name="felix.webconsole.label", value={"slingscheduler"}), @Property(name="felix.webconsole.title", value={"Sling Scheduler"}), @Property(name="felix.webconsole.configprinter.modes", value={"always"})})
public class WebConsolePrinter {
    private static String HEADLINE = "Apache Sling Scheduler";
    @Reference
    private QuartzScheduler scheduler;

    public void printConfiguration(PrintWriter pw) {
        pw.println(HEADLINE);
        pw.println();
        Scheduler s = this.scheduler.getScheduler();
        if (s != null) {
            pw.println("Status : active");
            try {
                pw.print("Name   : ");
                pw.println(s.getSchedulerName());
                pw.print("Id     : ");
                pw.println(s.getSchedulerInstanceId());
                List groups = s.getJobGroupNames();
                for (String group : groups) {
                    Set keys = s.getJobKeys(GroupMatcher.jobGroupEquals((String)group));
                    for (JobKey key : keys) {
                        Long bundleId;
                        JobDetail detail = s.getJobDetail(key);
                        String jobName = (String)detail.getJobDataMap().get((Object)"QuartzJobScheduler.JobName");
                        Object job = detail.getJobDataMap().get((Object)"QuartzJobScheduler.Object");
                        if (jobName == null || job == null) continue;
                        pw.print("Job : ");
                        pw.print(detail.getJobDataMap().get((Object)"QuartzJobScheduler.JobName"));
                        if (detail.getDescription() != null && detail.getDescription().length() > 0) {
                            pw.print(" (");
                            pw.print(detail.getDescription());
                            pw.print(")");
                        }
                        pw.print(", class: ");
                        pw.print(job.getClass().getName());
                        pw.print(", concurrent: ");
                        pw.print(!detail.isConcurrentExectionDisallowed());
                        Object[] runOn = (String[])detail.getJobDataMap().get((Object)"QuartzJobScheduler.runOn");
                        if (runOn != null) {
                            pw.print(", runOn: ");
                            pw.print(Arrays.toString(runOn));
                        }
                        if ((bundleId = (Long)detail.getJobDataMap().get((Object)"QuartzJobScheduler.bundleId")) != null) {
                            pw.print(", bundleId: ");
                            pw.print(String.valueOf(bundleId));
                        }
                        pw.println();
                        for (Trigger trigger : s.getTriggersOfJob(key)) {
                            pw.print("Trigger : ");
                            pw.print(trigger);
                            pw.println();
                        }
                        pw.println();
                    }
                }
            }
            catch (SchedulerException se) {
                pw.print("Unable to print complete configuration: ");
                pw.println(se.getMessage());
            }
        } else {
            pw.println("Status : not active");
        }
    }

    protected void bindScheduler(QuartzScheduler quartzScheduler) {
        this.scheduler = quartzScheduler;
    }

    protected void unbindScheduler(QuartzScheduler quartzScheduler) {
        if (this.scheduler == quartzScheduler) {
            this.scheduler = null;
        }
    }
}

