/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.scheduler.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.scheduler.Job;
import org.apache.sling.commons.scheduler.ScheduleOptions;
import org.apache.sling.commons.scheduler.impl.InternalScheduleOptions;
import org.apache.sling.commons.scheduler.impl.NonParallelQuartzJobExecutor;
import org.apache.sling.commons.scheduler.impl.QuartzJobExecutor;
import org.apache.sling.commons.threads.ThreadPoolManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.DirectSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.simpl.RAMJobStore;
import org.quartz.spi.JobStore;
import org.quartz.spi.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(immediate=true, metatype=true, label="Apache Sling Scheduler", description="The scheduler is able to run services and jobs at specific times or periodically based on cron expressions.")
@Service(value={QuartzScheduler.class})
public class QuartzScheduler
implements BundleListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PREFIX = "Apache Sling Quartz Scheduler ";
    private static final String QUARTZ_SCHEDULER_NAME = "ApacheSling";
    static final String DATA_MAP_OBJECT = "QuartzJobScheduler.Object";
    static final String DATA_MAP_NAME = "QuartzJobScheduler.JobName";
    static final String DATA_MAP_CONFIGURATION = "QuartzJobScheduler.Configuration";
    static final String DATA_MAP_LOGGER = "QuartzJobScheduler.Logger";
    static final String DATA_MAP_RUN_ON = "QuartzJobScheduler.runOn";
    static final String DATA_MAP_BUNDLE_ID = "QuartzJobScheduler.bundleId";
    private volatile Scheduler scheduler;
    @Reference
    private ThreadPoolManager threadPoolManager;
    private org.apache.sling.commons.threads.ThreadPool threadPool;
    @Property(label="Thread Pool Name", description="The name of a configured thread pool - if no name is configured the default pool is used.")
    private static final String PROPERTY_POOL_NAME = "poolName";

    @Activate
    protected void activate(BundleContext ctx, Map<String, Object> props) throws Exception {
        Object poolNameObj = props.get(PROPERTY_POOL_NAME);
        String poolName = poolNameObj != null && poolNameObj.toString().trim().length() > 0 ? poolNameObj.toString().trim() : null;
        ctx.addBundleListener((BundleListener)this);
        this.scheduler = this.init(poolName);
    }

    @Deactivate
    protected void deactivate(BundleContext ctx) {
        ctx.removeBundleListener((BundleListener)this);
        Scheduler s = this.scheduler;
        this.scheduler = null;
        this.dispose(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 4) {
            Long bundleId = event.getBundle().getBundleId();
            Scheduler s = this.scheduler;
            if (s != null) {
                QuartzScheduler quartzScheduler = this;
                synchronized (quartzScheduler) {
                    try {
                        List groups = s.getJobGroupNames();
                        for (String group : groups) {
                            Set keys = s.getJobKeys(GroupMatcher.jobGroupEquals((String)group));
                            for (JobKey key : keys) {
                                Long jobBundleId;
                                JobDetail detail = s.getJobDetail(key);
                                String jobName = (String)detail.getJobDataMap().get((Object)DATA_MAP_NAME);
                                Object job = detail.getJobDataMap().get((Object)DATA_MAP_OBJECT);
                                if (jobName == null || job == null || (jobBundleId = (Long)detail.getJobDataMap().get((Object)DATA_MAP_BUNDLE_ID)) == null || !jobBundleId.equals(bundleId)) continue;
                                s.deleteJob(key);
                                this.logger.debug("Unscheduling job with name {}", (Object)jobName);
                            }
                        }
                    }
                    catch (SchedulerException ignore) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private Scheduler init(String poolName) throws SchedulerException {
        System.setProperty("org.terracotta.quartz.skipUpdateCheck", Boolean.TRUE.toString());
        ThreadPoolManager tpm = this.threadPoolManager;
        if (tpm == null) {
            throw new SchedulerException("Thread pool manager missing");
        }
        this.threadPool = tpm.get(poolName);
        QuartzThreadPool quartzPool = new QuartzThreadPool(this.threadPool);
        DirectSchedulerFactory factory = DirectSchedulerFactory.getInstance();
        String runID = new Date().toString().replace(' ', '_');
        factory.createScheduler(QUARTZ_SCHEDULER_NAME, runID, (ThreadPool)quartzPool, (JobStore)new RAMJobStore());
        Iterator allSchedulersIter = factory.getAllSchedulers().iterator();
        Scheduler s = null;
        while (s == null && allSchedulersIter.hasNext()) {
            Scheduler current = (Scheduler)allSchedulersIter.next();
            if (!QUARTZ_SCHEDULER_NAME.equals(current.getSchedulerName()) || !runID.equals(current.getSchedulerInstanceId())) continue;
            s = current;
        }
        if (s == null) {
            throw new SchedulerException("Unable to find new scheduler with name ApacheSling and run ID " + runID);
        }
        s.start();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Apache Sling Quartz Scheduler started.");
        }
        return s;
    }

    private void dispose(Scheduler s) {
        ThreadPoolManager tpm;
        if (s != null) {
            try {
                s.shutdown();
            }
            catch (SchedulerException e) {
                this.logger.debug("Exception during shutdown of scheduler.", (Throwable)e);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Apache Sling Quartz Scheduler stopped.");
            }
        }
        if ((tpm = this.threadPoolManager) != null && this.threadPool != null) {
            tpm.release(this.threadPool);
        }
        this.threadPool = null;
    }

    private JobDataMap initDataMap(Long bundleId, String jobName, Object job, InternalScheduleOptions options) {
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put(DATA_MAP_OBJECT, job);
        jobDataMap.put(DATA_MAP_NAME, jobName);
        jobDataMap.put(DATA_MAP_LOGGER, (Object)this.logger);
        if (bundleId != null) {
            jobDataMap.put(DATA_MAP_BUNDLE_ID, (Object)bundleId);
        }
        if (options.configuration != null) {
            jobDataMap.put(DATA_MAP_CONFIGURATION, options.configuration);
        }
        if (options.runOn != null) {
            jobDataMap.put(DATA_MAP_RUN_ON, (Object)options.runOn);
        }
        return jobDataMap;
    }

    private JobDetail createJobDetail(String name, JobDataMap jobDataMap, boolean concurrent) {
        JobDetail detail = JobBuilder.newJob(concurrent ? QuartzJobExecutor.class : NonParallelQuartzJobExecutor.class).withIdentity(name).usingJobData(jobDataMap).build();
        return detail;
    }

    private void checkJob(Object job) throws IllegalArgumentException {
        if (!(job instanceof Runnable) && !(job instanceof Job)) {
            throw new IllegalArgumentException("Job object is neither an instance of " + Runnable.class.getName() + " nor " + Job.class.getName());
        }
    }

    public void addJob(Long bundleId, String name, Object job, Map<String, Serializable> config, String schedulingExpression, boolean canRunConcurrently) throws SchedulerException {
        this.scheduleJob(bundleId, job, this.EXPR(schedulingExpression).name(name).config(config).canRunConcurrently(canRunConcurrently));
    }

    public void addPeriodicJob(Long bundleId, String name, Object job, Map<String, Serializable> config, long period, boolean canRunConcurrently) throws SchedulerException {
        this.addPeriodicJob(bundleId, name, job, config, period, canRunConcurrently, false);
    }

    public void addPeriodicJob(Long bundleId, String name, Object job, Map<String, Serializable> config, long period, boolean canRunConcurrently, boolean startImmediate) throws SchedulerException {
        this.scheduleJob(bundleId, job, this.PERIODIC(period, startImmediate).name(name).config(config).canRunConcurrently(canRunConcurrently));
    }

    private ScheduleOptions PERIODIC(long period, boolean startImmediate) {
        if (period < 1L) {
            return new InternalScheduleOptions(new IllegalArgumentException("Period argument must be higher than 0"));
        }
        long ms = period * 1000L;
        TriggerBuilder builder = TriggerBuilder.newTrigger().startAt(new Date(System.currentTimeMillis() + ms)).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().repeatForever().withIntervalInMilliseconds(ms));
        if (startImmediate) {
            return new InternalScheduleOptions((TriggerBuilder<? extends Trigger>)builder.startNow());
        }
        return new InternalScheduleOptions((TriggerBuilder<? extends Trigger>)builder.startAt(new Date(System.currentTimeMillis() + ms)));
    }

    public void fireJob(Long bundleId, Object job, Map<String, Serializable> config) throws SchedulerException {
        this.scheduleJob(bundleId, job, this.NOW().config(config));
    }

    public void fireJobAt(Long bundleId, String name, Object job, Map<String, Serializable> config, Date date) throws SchedulerException {
        this.scheduleJob(bundleId, job, this.AT(date).name(name).config(config));
    }

    public boolean fireJob(Long bundleId, Object job, Map<String, Serializable> config, int times, long period) {
        return this.schedule(bundleId, job, this.NOW(times, period).config(config));
    }

    public boolean fireJobAt(Long bundleId, String name, Object job, Map<String, Serializable> config, Date date, int times, long period) {
        return this.schedule(bundleId, job, this.AT(date, times, period).name(name).config(config));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJob(Long bundleId, String name) throws NoSuchElementException {
        Scheduler s = this.scheduler;
        if (s != null) {
            QuartzScheduler quartzScheduler = this;
            synchronized (quartzScheduler) {
                try {
                    s.deleteJob(JobKey.jobKey((String)name));
                    this.logger.debug("Unscheduling job with name {}", (Object)name);
                }
                catch (SchedulerException se) {
                    throw new NoSuchElementException(se.getMessage());
                }
            }
        }
    }

    Scheduler getScheduler() {
        return this.scheduler;
    }

    public ScheduleOptions NOW() {
        return new InternalScheduleOptions((TriggerBuilder<? extends Trigger>)TriggerBuilder.newTrigger().startNow());
    }

    public ScheduleOptions NOW(int times, long period) {
        if (times < 2 && times != -1) {
            return new InternalScheduleOptions(new IllegalArgumentException("Times argument must be higher than 1 or -1"));
        }
        if (period < 1L) {
            return new InternalScheduleOptions(new IllegalArgumentException("Period argument must be higher than 0"));
        }
        SimpleScheduleBuilder sb = times == -1 ? SimpleScheduleBuilder.simpleSchedule().repeatForever() : SimpleScheduleBuilder.simpleSchedule().withRepeatCount(times - 1);
        return new InternalScheduleOptions((TriggerBuilder<? extends Trigger>)TriggerBuilder.newTrigger().startNow().withSchedule((ScheduleBuilder)sb.withIntervalInMilliseconds(period * 1000L)));
    }

    public ScheduleOptions AT(Date date) {
        if (date == null) {
            return new InternalScheduleOptions(new IllegalArgumentException("Date can't be null"));
        }
        return new InternalScheduleOptions((TriggerBuilder<? extends Trigger>)TriggerBuilder.newTrigger().startAt(date));
    }

    public ScheduleOptions AT(Date date, int times, long period) {
        if (date == null) {
            return new InternalScheduleOptions(new IllegalArgumentException("Date can't be null"));
        }
        if (times < 2 && times != -1) {
            return new InternalScheduleOptions(new IllegalArgumentException("Times argument must be higher than 1 or -1"));
        }
        if (period < 1L) {
            return new InternalScheduleOptions(new IllegalArgumentException("Period argument must be higher than 0"));
        }
        SimpleScheduleBuilder sb = times == -1 ? SimpleScheduleBuilder.simpleSchedule().repeatForever() : SimpleScheduleBuilder.simpleSchedule().withRepeatCount(times - 1);
        return new InternalScheduleOptions((TriggerBuilder<? extends Trigger>)TriggerBuilder.newTrigger().startAt(date).withSchedule((ScheduleBuilder)sb.withIntervalInMilliseconds(period * 1000L)));
    }

    public ScheduleOptions EXPR(String expression) {
        if (expression == null) {
            return new InternalScheduleOptions(new IllegalArgumentException("Expression can't be null"));
        }
        if (!CronExpression.isValidExpression((String)expression)) {
            return new InternalScheduleOptions(new IllegalArgumentException("Expressionis invalid : " + expression));
        }
        return new InternalScheduleOptions((TriggerBuilder<? extends Trigger>)TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)expression)));
    }

    public boolean schedule(Long bundleId, Object job, ScheduleOptions options) {
        try {
            this.scheduleJob(bundleId, job, options);
            return true;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        catch (SchedulerException se) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unschedule(Long bundleId, String jobName) {
        Scheduler s = this.scheduler;
        if (jobName != null && s != null) {
            QuartzScheduler quartzScheduler = this;
            synchronized (quartzScheduler) {
                try {
                    JobKey key = JobKey.jobKey((String)jobName);
                    JobDetail jobdetail = s.getJobDetail(key);
                    if (jobdetail != null) {
                        s.deleteJob(key);
                        this.logger.debug("Unscheduling job with name {}", (Object)jobName);
                        return true;
                    }
                }
                catch (SchedulerException ignored) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleJob(Long bundleId, Object job, ScheduleOptions options) throws SchedulerException {
        this.checkJob(job);
        if (!(options instanceof InternalScheduleOptions)) {
            throw new IllegalArgumentException("Options has not been created via schedule or is null.");
        }
        InternalScheduleOptions opts = (InternalScheduleOptions)options;
        if (opts.argumentException != null) {
            throw opts.argumentException;
        }
        Scheduler s = this.scheduler;
        if (s == null) {
            throw new IllegalStateException("Scheduler is not available anymore.");
        }
        QuartzScheduler quartzScheduler = this;
        synchronized (quartzScheduler) {
            String name;
            if (opts.name != null) {
                try {
                    JobKey key = JobKey.jobKey((String)opts.name);
                    JobDetail jobdetail = s.getJobDetail(key);
                    if (jobdetail != null) {
                        s.deleteJob(key);
                        this.logger.debug("Unscheduling job with name {}", (Object)opts.name);
                    }
                }
                catch (SchedulerException ignored) {
                    // empty catch block
                }
                name = opts.name;
            } else {
                name = job.getClass().getName() + ':' + UUID.randomUUID();
            }
            Trigger trigger = opts.trigger.withIdentity(name).build();
            JobDataMap jobDataMap = this.initDataMap(bundleId, name, job, opts);
            JobDetail detail = this.createJobDetail(name, jobDataMap, opts.canRunConcurrently);
            this.logger.debug("Scheduling job {} with name {} and trigger {}", new Object[]{job, name, trigger});
            s.scheduleJob(detail, trigger);
        }
    }

    protected void bindThreadPoolManager(ThreadPoolManager threadPoolManager) {
        this.threadPoolManager = threadPoolManager;
    }

    protected void unbindThreadPoolManager(ThreadPoolManager threadPoolManager) {
        if (this.threadPoolManager == threadPoolManager) {
            this.threadPoolManager = null;
        }
    }

    public static final class QuartzThreadPool
    implements ThreadPool {
        private org.apache.sling.commons.threads.ThreadPool executor;

        public QuartzThreadPool(org.apache.sling.commons.threads.ThreadPool executor) {
            this.executor = executor;
        }

        public int getPoolSize() {
            return this.executor.getConfiguration().getMaxPoolSize();
        }

        public void initialize() {
        }

        public void setInstanceId(String id) {
        }

        public void setInstanceName(String name) {
        }

        public boolean runInThread(Runnable job) {
            this.executor.execute(job);
            return true;
        }

        public int blockForAvailableThreads() {
            return this.executor.getConfiguration().getMaxPoolSize() - this.executor.getConfiguration().getQueueSize();
        }

        public void shutdown(boolean waitForJobsToComplete) {
            this.executor = null;
        }
    }
}

