/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.scheduler.impl;

import java.io.PrintWriter;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.apache.sling.commons.scheduler.impl.QuartzScheduler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.matchers.GroupMatcher;

public class WebConsolePrinter {
    private static String HEADLINE = "Apache Sling Scheduler";
    private final QuartzScheduler scheduler;

    public static ServiceRegistration initPlugin(BundleContext bundleContext, QuartzScheduler qs) {
        WebConsolePrinter propertiesPrinter = new WebConsolePrinter(qs);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.description", "Apache Sling Scheduler Configuration Printer");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)props).put("felix.webconsole.label", "slingscheduler");
        ((Dictionary)props).put("felix.webconsole.title", "Sling Scheduler");
        ((Dictionary)props).put("felix.webconsole.configprinter.modes", "always");
        return bundleContext.registerService(WebConsolePrinter.class.getName(), (Object)propertiesPrinter, props);
    }

    public static void destroyPlugin(ServiceRegistration plugin) {
        if (plugin != null) {
            plugin.unregister();
        }
    }

    public WebConsolePrinter(QuartzScheduler qs) {
        this.scheduler = qs;
    }

    public void printConfiguration(PrintWriter pw) {
        pw.println(HEADLINE);
        pw.println();
        Scheduler s = this.scheduler.getScheduler();
        if (s != null) {
            pw.println("Status : active");
            try {
                pw.print("Name   : ");
                pw.println(s.getSchedulerName());
                pw.print("Id     : ");
                pw.println(s.getSchedulerInstanceId());
                List groups = s.getJobGroupNames();
                for (String group : groups) {
                    pw.println();
                    pw.print("Group ");
                    pw.println(group);
                    pw.println("---------------------------------------------------------------------------");
                    Set keys = s.getJobKeys(GroupMatcher.jobGroupEquals((String)group));
                    for (JobKey key : keys) {
                        JobDetail detail = s.getJobDetail(key);
                        pw.print("Job : ");
                        pw.print(key.getName());
                        if (detail.getDescription() != null && detail.getDescription().length() > 0) {
                            pw.print(" (");
                            pw.print(detail.getDescription());
                            pw.print(")");
                        }
                        pw.print(", concurrent: ");
                        pw.print(!detail.isConcurrentExectionDisallowed());
                        pw.println();
                        for (Trigger trigger : s.getTriggersOfJob(key)) {
                            pw.print("Trigger : ");
                            pw.print(trigger);
                            pw.println();
                        }
                        pw.println();
                    }
                }
            }
            catch (SchedulerException se) {
                pw.print("Unable to print complete configuration: ");
                pw.println(se.getMessage());
            }
        } else {
            pw.println("Status : not active");
        }
    }
}

