/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.scheduler.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.apache.sling.commons.scheduler.Job;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.commons.scheduler.impl.NonParallelQuartzJobExecutor;
import org.apache.sling.commons.scheduler.impl.QuartzJobExecutor;
import org.apache.sling.commons.scheduler.impl.WebConsolePrinter;
import org.apache.sling.commons.threads.ThreadPoolManager;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.DirectSchedulerFactory;
import org.quartz.simpl.RAMJobStore;
import org.quartz.spi.JobStore;
import org.quartz.spi.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuartzScheduler
implements Scheduler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String DEFAULT_QUARTZ_JOB_GROUP = "Sling";
    protected static final String PREFIX = "Apache Sling Quartz Scheduler ";
    protected static final String QUARTZ_SCHEDULER_NAME = "ApacheSling";
    static final String DATA_MAP_OBJECT = "QuartzJobScheduler.Object";
    static final String DATA_MAP_NAME = "QuartzJobScheduler.JobName";
    static final String DATA_MAP_CONFIGURATION = "QuartzJobScheduler.Configuration";
    static final String DATA_MAP_LOGGER = "QuartzJobScheduler.Logger";
    protected volatile org.quartz.Scheduler scheduler;
    protected final List<Registration> registeredJobs = new ArrayList<Registration>();
    protected volatile ComponentContext context;
    protected ThreadPoolManager threadPoolManager;
    protected org.apache.sling.commons.threads.ThreadPool threadPool;
    private ServiceRegistration plugin;
    private static final String PROPERTY_POOL_NAME = "poolName";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext ctx) throws Exception {
        Registration[] regs;
        Object poolNameObj = ctx.getProperties().get(PROPERTY_POOL_NAME);
        String poolName = poolNameObj != null && poolNameObj.toString().trim().length() > 0 ? poolNameObj.toString().trim() : null;
        this.context = ctx;
        this.scheduler = this.init(poolName);
        List<Registration> list = this.registeredJobs;
        synchronized (list) {
            regs = this.registeredJobs.toArray(new Registration[this.registeredJobs.size()]);
            this.registeredJobs.clear();
        }
        for (Registration reg : regs) {
            try {
                this.register(reg.componentName, reg.reference);
            }
            catch (Exception e) {
                this.logger.error("Exception during registering " + reg.componentName + " service " + reg.reference, (Throwable)e);
            }
        }
        this.plugin = WebConsolePrinter.initPlugin(ctx.getBundleContext(), this);
    }

    protected void deactivate(ComponentContext ctx) {
        WebConsolePrinter.destroyPlugin(this.plugin);
        this.plugin = null;
        org.quartz.Scheduler s = this.scheduler;
        this.scheduler = null;
        this.dispose(s);
        this.context = null;
    }

    protected org.quartz.Scheduler init(String poolName) throws SchedulerException {
        System.setProperty("org.terracotta.quartz.skipUpdateCheck", Boolean.TRUE.toString());
        ThreadPoolManager tpm = this.threadPoolManager;
        if (tpm == null) {
            throw new SchedulerException("Thread pool manager missing");
        }
        this.threadPool = tpm.get(poolName);
        QuartzThreadPool quartzPool = new QuartzThreadPool(this.threadPool);
        DirectSchedulerFactory factory = DirectSchedulerFactory.getInstance();
        String runID = new Date().toString().replace(' ', '_');
        factory.createScheduler(QUARTZ_SCHEDULER_NAME, runID, (ThreadPool)quartzPool, (JobStore)new RAMJobStore());
        Iterator allSchedulersIter = factory.getAllSchedulers().iterator();
        org.quartz.Scheduler s = null;
        while (s == null && allSchedulersIter.hasNext()) {
            org.quartz.Scheduler current = (org.quartz.Scheduler)allSchedulersIter.next();
            if (!QUARTZ_SCHEDULER_NAME.equals(current.getSchedulerName()) || !runID.equals(current.getSchedulerInstanceId())) continue;
            s = current;
        }
        if (s == null) {
            throw new SchedulerException("Unable to find new scheduler with name ApacheSling and run ID " + runID);
        }
        s.start();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Apache Sling Quartz Scheduler started.");
        }
        return s;
    }

    protected void dispose(org.quartz.Scheduler s) {
        ThreadPoolManager tpm;
        if (s != null) {
            try {
                s.shutdown();
            }
            catch (SchedulerException e) {
                this.logger.debug("Exception during shutdown of scheduler.", (Throwable)e);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Apache Sling Quartz Scheduler stopped.");
            }
        }
        if ((tpm = this.threadPoolManager) != null && this.threadPool != null) {
            tpm.release(this.threadPool);
        }
        this.threadPool = null;
    }

    protected void scheduleJob(String name, Object job, Map<String, Serializable> config, Trigger trigger, boolean canRunConcurrently) throws SchedulerException {
        org.quartz.Scheduler s = this.scheduler;
        if (s == null) {
            throw new IllegalStateException("Scheduler is not available anymore.");
        }
        this.checkJob(job);
        if (name != null) {
            try {
                JobDetail jobdetail = s.getJobDetail(JobKey.jobKey((String)name));
                if (jobdetail != null) {
                    this.removeJob(name);
                }
            }
            catch (SchedulerException ignored) {
                // empty catch block
            }
        }
        String jobName = this.getJobName(name);
        JobDataMap jobDataMap = this.initDataMap(jobName, job, config);
        JobDetail detail = this.createJobDetail(jobName, jobDataMap, canRunConcurrently);
        this.logger.debug("Scheduling job {} with name {} and trigger {}", new Object[]{job, jobName, trigger});
        s.scheduleJob(detail, trigger);
    }

    protected JobDataMap initDataMap(String jobName, Object job, Map<String, Serializable> config) {
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put(DATA_MAP_OBJECT, job);
        jobDataMap.put(DATA_MAP_NAME, jobName);
        jobDataMap.put(DATA_MAP_LOGGER, (Object)this.logger);
        if (config != null) {
            jobDataMap.put(DATA_MAP_CONFIGURATION, config);
        }
        return jobDataMap;
    }

    protected JobDetail createJobDetail(String name, JobDataMap jobDataMap, boolean concurrent) {
        JobDetail detail = JobBuilder.newJob(concurrent ? QuartzJobExecutor.class : NonParallelQuartzJobExecutor.class).withIdentity(name).usingJobData(jobDataMap).build();
        return detail;
    }

    protected void checkJob(Object job) throws IllegalArgumentException {
        if (!(job instanceof Runnable) && !(job instanceof Job)) {
            throw new IllegalArgumentException("Job object is neither an instance of " + Runnable.class.getName() + " nor " + Job.class.getName());
        }
    }

    @Override
    public void addJob(String name, Object job, Map<String, Serializable> config, String schedulingExpression, boolean canRunConcurrently) throws SchedulerException {
        Trigger cronTrigger = TriggerBuilder.newTrigger().withIdentity(name).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)schedulingExpression)).build();
        this.scheduleJob(name, job, config, cronTrigger, canRunConcurrently);
    }

    @Override
    public void addPeriodicJob(String name, Object job, Map<String, Serializable> config, long period, boolean canRunConcurrently) throws SchedulerException {
        this.addPeriodicJob(name, job, config, period, canRunConcurrently, false);
    }

    @Override
    public void addPeriodicJob(String name, Object job, Map<String, Serializable> config, long period, boolean canRunConcurrently, boolean startImmediate) throws SchedulerException {
        long ms = period * 1000L;
        String jobName = this.getJobName(name);
        TriggerBuilder builder = TriggerBuilder.newTrigger().withIdentity(jobName).startAt(new Date(System.currentTimeMillis() + ms)).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().repeatForever().withIntervalInMilliseconds(ms));
        Trigger trigger = startImmediate ? builder.startNow().build() : builder.startAt(new Date(System.currentTimeMillis() + ms)).build();
        this.scheduleJob(jobName, job, config, trigger, canRunConcurrently);
    }

    @Override
    public void fireJob(Object job, Map<String, Serializable> config) throws SchedulerException {
        this.checkJob(job);
        String jobName = job.getClass().getName();
        JobDataMap dataMap = this.initDataMap(jobName, job, config);
        JobDetail detail = this.createJobDetail(jobName, dataMap, true);
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(jobName).startNow().build();
        this.scheduler.scheduleJob(detail, trigger);
    }

    @Override
    public void fireJobAt(String name, Object job, Map<String, Serializable> config, Date date) throws SchedulerException {
        String jobName = this.getJobName(name);
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(jobName).startAt(date).build();
        this.scheduleJob(jobName, job, config, trigger, true);
    }

    @Override
    public boolean fireJob(Object job, Map<String, Serializable> config, int times, long period) {
        this.checkJob(job);
        if (times < 2) {
            throw new IllegalArgumentException("Times argument must be higher than 1");
        }
        long ms = period * 1000L;
        String jobName = job.getClass().getName();
        JobDataMap dataMap = this.initDataMap(jobName, job, config);
        JobDetail detail = this.createJobDetail(jobName, dataMap, true);
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(jobName).startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withRepeatCount(times).withIntervalInMilliseconds(ms)).build();
        try {
            this.scheduler.scheduleJob(detail, trigger);
        }
        catch (SchedulerException se) {
            return false;
        }
        return true;
    }

    @Override
    public boolean fireJobAt(String name, Object job, Map<String, Serializable> config, Date date, int times, long period) {
        if (times < 2) {
            throw new IllegalArgumentException("Times argument must be higher than 1");
        }
        String jobName = job.getClass().getName();
        long ms = period * 1000L;
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(jobName).startAt(date).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withRepeatCount(times).withIntervalInMilliseconds(ms)).build();
        try {
            this.scheduleJob(jobName, job, config, trigger, true);
        }
        catch (SchedulerException se) {
            return false;
        }
        return true;
    }

    private String getJobName(String name) {
        return name != null ? name : PREFIX + UUID.randomUUID();
    }

    @Override
    public void removeJob(String name) throws NoSuchElementException {
        org.quartz.Scheduler s = this.scheduler;
        if (s != null) {
            try {
                s.deleteJob(JobKey.jobKey((String)name));
                this.logger.debug("Unscheduling job with name {}", (Object)name);
            }
            catch (SchedulerException se) {
                throw new NoSuchElementException(se.getMessage());
            }
        }
    }

    private String getServiceIdentifier(ServiceReference ref) {
        String name = (String)ref.getProperty("scheduler.name");
        if (name == null && (name = (String)ref.getProperty("service.pid")) == null) {
            name = "Registered Service";
        }
        name = name + "." + ref.getProperty("service.id");
        return name;
    }

    private void register(String type, ServiceReference ref) {
        Object job;
        ComponentContext ctx = this.context;
        if (ctx != null && (job = ctx.locateService(type, ref)) != null) {
            this.checkJob(job);
            try {
                String name = this.getServiceIdentifier(ref);
                Boolean concurrent = (Boolean)ref.getProperty("scheduler.concurrent");
                String expression = (String)ref.getProperty("scheduler.expression");
                if (expression != null) {
                    this.addJob(name, job, null, expression, concurrent != null ? concurrent : true);
                } else {
                    Long period = (Long)ref.getProperty("scheduler.period");
                    if (period != null) {
                        if (period < 1L) {
                            this.logger.debug("Ignoring service {} : scheduler period is less than 1.", (Object)ref);
                        } else {
                            boolean immediate = false;
                            if (ref.getProperty("scheduler.immediate") != null) {
                                immediate = (Boolean)ref.getProperty("scheduler.immediate");
                            }
                            this.addPeriodicJob(name, job, null, period, concurrent != null ? concurrent : true, immediate);
                        }
                    } else {
                        this.logger.debug("Ignoring servce {} : no scheduling property found.", (Object)ref);
                    }
                }
            }
            catch (IllegalStateException e) {
                this.logger.warn("Ignoring servce " + ref + " : exception occurred during registering.", (Throwable)e);
            }
            catch (SchedulerException e) {
                this.logger.warn("Ignoring servce " + ref + " : exception occurred during registering.", (Throwable)e);
            }
        }
    }

    private void unregister(ServiceReference ref) {
        try {
            String name = this.getServiceIdentifier(ref);
            this.removeJob(name);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindJob(ServiceReference ref) {
        if (this.scheduler != null) {
            this.register("job", ref);
        } else {
            List<Registration> list = this.registeredJobs;
            synchronized (list) {
                this.registeredJobs.add(new Registration(ref, "job"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindJob(ServiceReference ref) {
        if (this.scheduler != null) {
            this.unregister(ref);
        } else {
            List<Registration> list = this.registeredJobs;
            synchronized (list) {
                this.registeredJobs.remove(new Registration(ref, "job"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindTask(ServiceReference ref) {
        if (this.scheduler != null) {
            this.register("task", ref);
        } else {
            List<Registration> list = this.registeredJobs;
            synchronized (list) {
                this.registeredJobs.add(new Registration(ref, "task"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindTask(ServiceReference ref) {
        if (this.scheduler != null) {
            this.unregister(ref);
        } else {
            List<Registration> list = this.registeredJobs;
            synchronized (list) {
                this.registeredJobs.remove(new Registration(ref, "task"));
            }
        }
    }

    org.quartz.Scheduler getScheduler() {
        return this.scheduler;
    }

    protected void bindThreadPoolManager(ThreadPoolManager threadPoolManager) {
        this.threadPoolManager = threadPoolManager;
    }

    protected void unbindThreadPoolManager(ThreadPoolManager threadPoolManager) {
        if (this.threadPoolManager == threadPoolManager) {
            this.threadPoolManager = null;
        }
    }

    public static final class QuartzThreadPool
    implements ThreadPool {
        private org.apache.sling.commons.threads.ThreadPool executor;

        public QuartzThreadPool(org.apache.sling.commons.threads.ThreadPool executor) {
            this.executor = executor;
        }

        public int getPoolSize() {
            return this.executor.getConfiguration().getMaxPoolSize();
        }

        public void initialize() {
        }

        public void setInstanceId(String id) {
        }

        public void setInstanceName(String name) {
        }

        public boolean runInThread(Runnable job) {
            this.executor.execute(job);
            return true;
        }

        public int blockForAvailableThreads() {
            return this.executor.getConfiguration().getMaxPoolSize() - this.executor.getConfiguration().getQueueSize();
        }

        public void shutdown(boolean waitForJobsToComplete) {
            this.executor = null;
        }
    }

    private static final class Registration {
        public static final String JOB = "job";
        public static final String TASK = "task";
        public final ServiceReference reference;
        public final String componentName;

        public Registration(ServiceReference r, String name) {
            this.reference = r;
            this.componentName = name;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Registration)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            return this.reference.equals(((Registration)obj).reference);
        }

        public int hashCode() {
            return this.reference.hashCode();
        }
    }
}

