/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.mime.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.commons.mime.MimeTypeProvider;
import org.apache.sling.commons.mime.MimeTypeService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.log.LogService;

public class MimeTypeServiceImpl
implements MimeTypeService,
BundleListener {
    public static final String MIME_TYPES = "/META-INF/mime.types";
    private LogService logService;
    private Map<String, String> mimeTab = new HashMap<String, String>();
    private Map<String, String> extensionMap = new HashMap<String, String>();
    private MimeTypeProvider[] typeProviders;
    private List<MimeTypeProvider> typeProviderList = new ArrayList<MimeTypeProvider>();

    public String getMimeType(String name) {
        if (name == null) {
            return null;
        }
        String ext = name.substring(name.lastIndexOf(46) + 1);
        String type = this.mimeTab.get(ext = ext.toLowerCase());
        if (type == null) {
            MimeTypeProvider[] mtp = this.getMimeTypeProviders();
            for (int i = 0; type == null && i < mtp.length; ++i) {
                type = mtp[i].getMimeType(ext);
            }
        }
        return type;
    }

    public String getExtension(String mimeType) {
        if (mimeType == null) {
            return null;
        }
        String ext = this.extensionMap.get(mimeType = mimeType.toLowerCase());
        if (ext == null) {
            MimeTypeProvider[] mtp = this.getMimeTypeProviders();
            for (int i = 0; ext == null && i < mtp.length; ++i) {
                ext = mtp[i].getExtension(mimeType);
            }
        }
        return ext;
    }

    public void registerMimeType(String mimeType, String ... extensions) {
        if (mimeType == null || mimeType.length() == 0 || extensions == null || extensions.length == 0) {
            return;
        }
        mimeType = mimeType.toLowerCase();
        String defaultExtension = null;
        for (int i = 0; i < extensions.length; ++i) {
            if (extensions[i] == null || extensions[i].length() <= 0) continue;
            extensions[i] = extensions[i].toLowerCase();
            this.mimeTab.put(extensions[i], mimeType);
            if (defaultExtension != null) continue;
            defaultExtension = extensions[i];
        }
        if (defaultExtension != null) {
            this.extensionMap.put(mimeType, defaultExtension);
        }
    }

    public void registerMimeType(InputStream mimeTabStream) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(mimeTabStream, "ISO-8859-1"));
        while ((line = br.readLine()) != null) {
            String[] parts;
            if (line.startsWith("#") || (parts = line.split("\\s+")).length <= 1) continue;
            String[] extensions = new String[parts.length - 1];
            System.arraycopy(parts, 1, extensions, 0, extensions.length);
            this.registerMimeType(parts[0], extensions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MimeTypeProvider[] getMimeTypeProviders() {
        MimeTypeProvider[] list = this.typeProviders;
        if (list == null) {
            List<MimeTypeProvider> list2 = this.typeProviderList;
            synchronized (list2) {
                this.typeProviders = this.typeProviderList.toArray(new MimeTypeProvider[this.typeProviderList.size()]);
                list = this.typeProviders;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBundle(Bundle bundle) {
        URL mimes = bundle.getEntry(MIME_TYPES);
        if (mimes != null) {
            InputStream ins = null;
            try {
                ins = mimes.openStream();
                this.registerMimeType(ins);
            }
            catch (IOException ioe) {
                this.log(2, "An error occurred reading " + mimes, ioe);
            }
            finally {
                if (ins != null) {
                    try {
                        ins.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
    }

    private void log(int level, String message, Throwable t) {
        LogService log = this.logService;
        if (log != null) {
            log.log(level, message, t);
        } else {
            PrintStream out = level == 1 ? System.err : System.out;
            out.println(message);
            if (t != null) {
                t.printStackTrace(out);
            }
        }
    }

    protected void activate(ComponentContext context) {
        context.getBundleContext().addBundleListener((BundleListener)this);
        Bundle[] bundles = context.getBundleContext().getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            if ((bundles[i].getState() & 0x3C) == 0) continue;
            this.handleBundle(bundles[i]);
        }
    }

    protected void deactivate(ComponentContext context) {
        context.getBundleContext().removeBundleListener((BundleListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindMimeTypeProvider(MimeTypeProvider mimeTypeProvider) {
        List<MimeTypeProvider> list = this.typeProviderList;
        synchronized (list) {
            this.typeProviderList.add(mimeTypeProvider);
            this.typeProviders = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindMimeTypeProvider(MimeTypeProvider mimeTypeProvider) {
        List<MimeTypeProvider> list = this.typeProviderList;
        synchronized (list) {
            this.typeProviderList.remove(mimeTypeProvider);
            this.typeProviders = null;
        }
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 32) {
            this.handleBundle(event.getBundle());
        }
    }

    protected void bindLogService(LogService logService) {
        this.logService = logService;
    }

    protected void unbindLogService(LogService logService) {
        if (this.logService == logService) {
            this.logService = null;
        }
    }
}

