/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bundleresource.impl;

class MappedPath {
    private static final char prefixSeparatorChar = '!';
    private final String resourceRoot;
    private final String resourceRootPrefix;
    private final String entryRoot;
    private final String entryRootPrefix;

    static MappedPath create(String configPath) {
        String resourceRoot;
        String entryRoot;
        int prefixSep = configPath.indexOf(33);
        if (prefixSep >= 0) {
            entryRoot = configPath.substring(prefixSep + 1);
            resourceRoot = configPath.substring(0, prefixSep).concat(entryRoot);
        } else {
            resourceRoot = configPath;
            entryRoot = null;
        }
        return new MappedPath(resourceRoot, entryRoot);
    }

    MappedPath(String resourceRoot, String entryRoot) {
        this.resourceRoot = resourceRoot;
        this.resourceRootPrefix = MappedPath.ensureTrailingSlash(resourceRoot);
        this.entryRoot = entryRoot;
        this.entryRootPrefix = MappedPath.ensureTrailingSlash(entryRoot);
    }

    boolean isChild(String resourcePath) {
        return resourcePath.startsWith(this.resourceRootPrefix) || resourcePath.equals(this.resourceRoot);
    }

    String getEntryPath(String resourcePath) {
        if (this.entryRootPrefix == null) {
            return resourcePath;
        }
        if (resourcePath.startsWith(this.resourceRootPrefix)) {
            return this.entryRootPrefix.concat(resourcePath.substring(this.resourceRootPrefix.length()));
        }
        if (resourcePath.equals(this.resourceRoot)) {
            return this.entryRoot;
        }
        return null;
    }

    String getResourceRoot() {
        return this.resourceRoot;
    }

    String getResourceRootPrefix() {
        return this.resourceRootPrefix;
    }

    String getEntryRoot() {
        return this.entryRoot;
    }

    String getEntryRootPrefix() {
        return this.entryRootPrefix;
    }

    private static String ensureTrailingSlash(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        if (!path.endsWith("/")) {
            return path.concat("/");
        }
        return path;
    }

    public String toString() {
        return "MappedPath: " + this.getResourceRoot() + " -> " + this.getEntryRoot();
    }
}

