/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bundleresource.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.bundleresource.impl.BundleResource;
import org.apache.sling.bundleresource.impl.BundleResourceCache;
import org.apache.sling.bundleresource.impl.MappedPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BundleResourceIterator
implements Iterator<Resource> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ResourceResolver resourceResolver;
    private final BundleResourceCache bundle;
    private final MappedPath mappedPath;
    private final Iterator<String> entries;
    private final int prefixLength;
    private Resource nextResult;

    BundleResourceIterator(BundleResource parent) {
        if (parent.isFile()) {
            this.resourceResolver = null;
            this.bundle = null;
            this.entries = null;
            this.prefixLength = 0;
            this.mappedPath = null;
            this.nextResult = null;
        } else {
            String parentPath = parent.getPath().concat("/");
            this.resourceResolver = parent.getResourceResolver();
            this.bundle = parent.getBundle();
            this.mappedPath = parent.getMappedPath();
            parentPath = this.mappedPath.getEntryPath(parentPath);
            this.entries = parent.getBundle().getEntryPaths(parentPath);
            this.prefixLength = parentPath.length();
            this.nextResult = this.entries != null ? this.seek() : null;
        }
    }

    BundleResourceIterator(ResourceResolver resourceResolver, BundleResourceCache bundle, MappedPath mappedPath, String parentPath) {
        if (!parentPath.endsWith("/")) {
            parentPath = parentPath.concat("/");
        }
        this.resourceResolver = resourceResolver;
        this.bundle = bundle;
        this.mappedPath = mappedPath;
        this.entries = bundle.getEntryPaths(parentPath);
        this.prefixLength = parentPath.length();
        this.nextResult = this.entries != null ? this.seek() : null;
    }

    @Override
    public boolean hasNext() {
        return this.nextResult != null;
    }

    @Override
    public Resource next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Resource result = this.nextResult;
        this.nextResult = this.seek();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private Resource seek() {
        while (this.entries.hasNext()) {
            int slash;
            String entry = this.entries.next();
            if (!entry.startsWith("/")) {
                entry = "/" + entry;
            }
            if ((slash = entry.indexOf(47, this.prefixLength)) < 0 || slash == entry.length() - 1) {
                this.log.debug("seek: Using entry {}", (Object)entry);
                return new BundleResource(this.resourceResolver, this.bundle, this.mappedPath, entry);
            }
            this.log.debug("seek: Ignoring entry {}", (Object)entry);
        }
        this.log.debug("seek: No more nodes, iterator exhausted");
        return null;
    }
}

