/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bundleresource.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.bundleresource.impl.BundleResourceCache;
import org.apache.sling.bundleresource.impl.BundleResourceIterator;
import org.apache.sling.bundleresource.impl.BundleResourceURLStreamHandler;
import org.apache.sling.bundleresource.impl.MappedPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleResource
extends AbstractResource {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ResourceResolver resourceResolver;
    private final BundleResourceCache bundle;
    private final MappedPath mappedPath;
    private final String path;
    private URL url;
    private final String resourceType;
    private final ResourceMetadata metadata;

    public static BundleResource getResource(ResourceResolver resourceResolver, BundleResourceCache bundle, MappedPath mappedPath, String resourcePath) {
        String entryPath = mappedPath.getEntryPath(resourcePath);
        URL entry = bundle.getEntry(entryPath.concat("/"));
        if (entry != null) {
            resourcePath = resourcePath.concat("/");
        }
        if (entry == null) {
            entry = bundle.getEntry(entryPath);
        }
        if (entry != null) {
            return new BundleResource(resourceResolver, bundle, mappedPath, resourcePath);
        }
        return null;
    }

    public BundleResource(ResourceResolver resourceResolver, BundleResourceCache bundle, MappedPath mappedPath, String resourcePath) {
        this.resourceResolver = resourceResolver;
        this.bundle = bundle;
        this.mappedPath = mappedPath;
        this.metadata = new ResourceMetadata();
        this.metadata.setResolutionPath(resourcePath);
        this.metadata.setCreationTime(bundle.getBundle().getLastModified());
        this.metadata.setModificationTime(bundle.getBundle().getLastModified());
        if (resourcePath.endsWith("/")) {
            this.path = resourcePath.substring(0, resourcePath.length() - 1);
            this.resourceType = "nt:folder";
            this.metadata.put((Object)":org.apache.sling.resource.internal.continue.resolving", (Object)Boolean.TRUE);
        } else {
            this.path = resourcePath;
            this.resourceType = "nt:file";
            try {
                URL url = bundle.getEntry(mappedPath.getEntryPath(resourcePath));
                this.metadata.setContentLength((long)url.openConnection().getContentLength());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getResourceSuperType() {
        return null;
    }

    public ResourceMetadata getResourceMetadata() {
        return this.metadata;
    }

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public <Type> Type adaptTo(Class<Type> type) {
        if (type == InputStream.class) {
            return (Type)this.getInputStream();
        }
        if (type == URL.class) {
            return (Type)this.getURL();
        }
        return (Type)super.adaptTo(type);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ", type=" + this.getResourceType() + ", path=" + this.getPath();
    }

    private InputStream getInputStream() {
        if (this.isFile()) {
            try {
                URL url = this.getURL();
                if (url != null) {
                    return url.openStream();
                }
            }
            catch (IOException ioe) {
                this.log.error("getInputStream: Cannot get input stream for " + (Object)((Object)this), (Throwable)ioe);
            }
        }
        return null;
    }

    private URL getURL() {
        if (this.url == null) {
            try {
                this.url = new URL("bundle", null, -1, this.path, new BundleResourceURLStreamHandler(this.bundle.getBundle(), this.mappedPath.getEntryPath(this.path)));
            }
            catch (MalformedURLException mue) {
                this.log.error("getURL: Cannot get URL for " + (Object)((Object)this), (Throwable)mue);
            }
        }
        return this.url;
    }

    public Iterator<Resource> listChildren() {
        return new BundleResourceIterator(this);
    }

    BundleResourceCache getBundle() {
        return this.bundle;
    }

    MappedPath getMappedPath() {
        return this.mappedPath;
    }

    boolean isFile() {
        return "nt:file".equals(this.getResourceType());
    }
}

