/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bundleresource.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.sling.bundleresource.impl.BundleResourceProvider;
import org.apache.sling.bundleresource.impl.BundleResourceWebConsolePlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator,
BundleListener {
    public static final String BUNDLE_RESOURCE_ROOTS = "Sling-Bundle-Resources";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Map<Long, BundleResourceProvider> bundleResourceProviderMap = new HashMap<Long, BundleResourceProvider>();
    private BundleContext bundleContext;

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        context.addBundleListener((BundleListener)this);
        try {
            Bundle[] bundles;
            for (Bundle bundle : bundles = context.getBundles()) {
                if (bundle.getState() != 32) continue;
                this.addBundleResourceProvider(bundle);
            }
        }
        catch (Throwable t) {
            this.log.error("activate: Problem while registering bundle resources for existing bundles", t);
        }
        BundleResourceWebConsolePlugin.initPlugin(context);
    }

    public void stop(BundleContext context) throws Exception {
        BundleResourceWebConsolePlugin.destroyPlugin();
        context.removeBundleListener((BundleListener)this);
        this.bundleContext = null;
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 2: {
                this.addBundleResourceProvider(event.getBundle());
                break;
            }
            case 4: {
                this.removeBundleResourceProvider(event.getBundle());
            }
        }
    }

    private void addBundleResourceProvider(Bundle bundle) {
        String prefixes = (String)bundle.getHeaders().get(BUNDLE_RESOURCE_ROOTS);
        if (prefixes != null) {
            this.log.debug("addBundleResourceProvider: Registering resources '{}' for bundle {}/{} as service ", new Object[]{prefixes, bundle.getSymbolicName(), bundle.getBundleId()});
            BundleResourceProvider brp = new BundleResourceProvider(bundle, prefixes);
            long id = brp.registerService(this.bundleContext);
            this.bundleResourceProviderMap.put(bundle.getBundleId(), brp);
            this.log.debug("addBundleResourceProvider: Service ID = {}", (Object)id);
        }
    }

    private void removeBundleResourceProvider(Bundle bundle) {
        BundleResourceProvider brp = this.bundleResourceProviderMap.remove(bundle.getBundleId());
        if (brp != null) {
            this.log.debug("removeBundleResourceProvider: Unregistering resources for bundle {}/{}", new Object[]{bundle.getSymbolicName(), bundle.getBundleId()});
            brp.unregisterService();
        }
    }
}

