/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bundleresource.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.bundleresource.impl.BundleResourceCache;
import org.apache.sling.bundleresource.impl.BundleResourceProvider;
import org.apache.sling.bundleresource.impl.MappedPath;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

class BundleResourceWebConsolePlugin
extends AbstractWebConsolePlugin {
    private static final String LABEL = "bundleresources";
    private ServiceRegistration serviceRegistration;
    private ServiceTracker providerTracker;
    private List<BundleResourceProvider> provider = new ArrayList<BundleResourceProvider>();
    private static BundleResourceWebConsolePlugin INSTANCE;

    static void initPlugin(BundleContext context) {
        if (INSTANCE == null) {
            BundleResourceWebConsolePlugin tmp = new BundleResourceWebConsolePlugin();
            tmp.activate(context);
            INSTANCE = tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void destroyPlugin() {
        if (INSTANCE != null) {
            try {
                INSTANCE.deactivate();
            }
            finally {
                INSTANCE = null;
            }
        }
    }

    private BundleResourceWebConsolePlugin() {
    }

    public String getLabel() {
        return LABEL;
    }

    public String getTitle() {
        return "Bundle Resource Provider";
    }

    protected void renderContent(HttpServletRequest req, HttpServletResponse res) throws IOException {
        BundleResourceProvider[] brp;
        PrintWriter pw = res.getWriter();
        pw.println("<table class='content' cellpadding='0' cellspacing='0' width='100%'>");
        pw.println("<tr class='content'>");
        pw.println("<th colspan='2' class='content container'>Bundle Resource Provider</th>");
        pw.println("</tr>");
        for (BundleResourceProvider bundleResourceProvider : brp = this.provider.toArray(new BundleResourceProvider[this.provider.size()])) {
            BundleResourceCache cache = bundleResourceProvider.getBundleResourceCache();
            MappedPath[] paths = bundleResourceProvider.getMappedPaths();
            pw.println("<tr class='content'>");
            pw.println("<td class='content'>");
            pw.println(cache.getBundle().getBundleId());
            pw.println("</td>");
            pw.println("<td class='content'>");
            pw.println(this.getName(cache.getBundle()));
            pw.println("</td>");
            pw.println("</tr>");
            pw.println("<tr class='content'>");
            pw.println("<td class='content'>&nbsp;</td>");
            pw.println("<td class='content'>");
            pw.println("<table>");
            pw.println("<tr>");
            pw.println("<td>Mappings</td>");
            pw.println("<td>");
            for (MappedPath mappedPath : paths) {
                pw.print(mappedPath.getResourceRoot());
                if (mappedPath.getEntryRoot() != null) {
                    pw.print(" ==> ");
                    pw.print(mappedPath.getEntryRoot());
                }
                pw.print("<br>");
            }
            pw.println("</td>");
            pw.println("</tr>");
            pw.println("<tr>");
            pw.println("<td>Entry Cache</td>");
            pw.printf("<td>Size: %d, Limit: %d</td>%n", cache.getEntryCacheSize(), cache.getEntryCacheMaxSize());
            pw.println("</tr>");
            pw.println("<tr>");
            pw.println("<td>List Cache</td>");
            pw.printf("<td>Size: %d, Limit: %d</td>%n", cache.getListCacheSize(), cache.getListCacheMaxSize());
            pw.println("</tr>");
            pw.println("</table>");
            pw.println("</td>");
            pw.println("</tr>");
        }
        pw.println("</table>");
    }

    public void activate(BundleContext context) {
        super.activate(context);
        this.providerTracker = new ServiceTracker(context, ResourceProvider.SERVICE_NAME, null){

            public Object addingService(ServiceReference reference) {
                Object service = super.addingService(reference);
                if (service instanceof BundleResourceProvider) {
                    BundleResourceWebConsolePlugin.this.provider.add((BundleResourceProvider)service);
                }
                return service;
            }

            public void removedService(ServiceReference reference, Object service) {
                if (service instanceof BundleResourceProvider) {
                    BundleResourceWebConsolePlugin.this.provider.remove(service);
                }
                super.removedService(reference, service);
            }
        };
        this.providerTracker.open();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.description", "Web Console Plugin for Bundle Resource Providers");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)props).put("service.pid", ((Object)((Object)this)).getClass().getName());
        ((Dictionary)props).put("felix.webconsole.label", LABEL);
        this.serviceRegistration = context.registerService("javax.servlet.Servlet", (Object)this, props);
    }

    public void deactivate() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
        if (this.providerTracker != null) {
            this.providerTracker.close();
            this.providerTracker = null;
        }
        super.deactivate();
    }

    private String getName(Bundle bundle) {
        String name = (String)bundle.getHeaders().get("Bundle-Name");
        if (name == null && (name = bundle.getSymbolicName()) == null) {
            name = bundle.getLocation();
        }
        return name;
    }
}

