/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bundleresource.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.bundleresource.impl.BundleResource;
import org.apache.sling.bundleresource.impl.BundleResourceCache;
import org.apache.sling.bundleresource.impl.BundleResourceIterator;
import org.apache.sling.bundleresource.impl.MappedPath;
import org.apache.sling.commons.osgi.ManifestHeader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleResourceProvider
implements ResourceProvider {
    private final BundleResourceCache bundle;
    private final MappedPath[] roots;
    private ServiceRegistration serviceRegistration;

    public BundleResourceProvider(Bundle bundle, String rootList) {
        this.bundle = new BundleResourceCache(bundle);
        ArrayList<MappedPath> prefixList = new ArrayList<MappedPath>();
        ManifestHeader header = ManifestHeader.parse((String)rootList);
        for (ManifestHeader.Entry entry : header.getEntries()) {
            String resourceRoot = entry.getValue();
            String pathDirective = entry.getDirectiveValue("path");
            if (pathDirective != null) {
                prefixList.add(new MappedPath(resourceRoot, pathDirective));
                continue;
            }
            prefixList.add(MappedPath.create(resourceRoot));
        }
        this.roots = prefixList.toArray(new MappedPath[prefixList.size()]);
    }

    void registerService(BundleContext context) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("service.description", "Provider of bundle based resources");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)props).put("provider.roots", this.getRoots());
        this.serviceRegistration = context.registerService(SERVICE_NAME, (Object)this, props);
    }

    void unregisterService() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }

    BundleResourceCache getBundleResourceCache() {
        return this.bundle;
    }

    MappedPath[] getMappedPaths() {
        return this.roots;
    }

    private String[] getRoots() {
        String[] rootPaths = new String[this.roots.length];
        for (int i = 0; i < this.roots.length; ++i) {
            rootPaths[i] = this.roots[i].getResourceRoot();
        }
        return rootPaths;
    }

    private MappedPath getMappedPath(String resourcePath) {
        for (MappedPath mappedPath : this.roots) {
            if (!mappedPath.isChild(resourcePath)) continue;
            return mappedPath;
        }
        return null;
    }

    public Resource getResource(ResourceResolver resourceResolver, HttpServletRequest request, String path) {
        return this.getResource(resourceResolver, path);
    }

    public Resource getResource(ResourceResolver resourceResolver, String path) {
        MappedPath mappedPath = this.getMappedPath(path);
        if (mappedPath != null) {
            return BundleResource.getResource(resourceResolver, this.bundle, mappedPath, path);
        }
        return null;
    }

    public Iterator<Resource> listChildren(Resource parent) throws SlingException {
        if (parent instanceof BundleResource) {
            return ((BundleResource)parent).listChildren();
        }
        String parentPath = parent.getPath();
        MappedPath mappedPath = this.getMappedPath(parentPath);
        if (mappedPath != null) {
            return new BundleResourceIterator(parent.getResourceResolver(), this.bundle, mappedPath, parentPath);
        }
        return Collections.emptyList().iterator();
    }
}

