/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bundleresource.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BundleResourceCache {
    private static final int CACHE_SIZE = 50;
    private static final int LIST_CACHE_SIZE = 20;
    private static final URL NOT_FOUND_URL;
    private static final List<String> NOT_FOUND_CHILDREN;
    private final Map<String, URL> cache;
    private final Map<String, List<String>> listCache;
    private final Bundle bundle;

    BundleResourceCache(Bundle bundle) {
        this.bundle = bundle;
        this.cache = Collections.synchronizedMap(new BundleResourceMap(50));
        this.listCache = Collections.synchronizedMap(new BundleResourceMap(20));
    }

    Bundle getBundle() {
        return this.bundle;
    }

    URL getEntry(String path) {
        URL url = this.cache.get(path);
        if (url == null) {
            url = this.bundle.getEntry(path);
            if (url == null) {
                url = NOT_FOUND_URL;
            }
            this.cache.put(path, url);
        }
        return url == NOT_FOUND_URL ? null : url;
    }

    Iterator<String> getEntryPaths(String path) {
        List<String> list = this.listCache.get(path);
        if (list == null) {
            Enumeration entries = this.bundle.getEntryPaths(path);
            if (entries != null && entries.hasMoreElements()) {
                list = new LinkedList<String>();
                while (entries.hasMoreElements()) {
                    list.add((String)entries.nextElement());
                }
            }
            if (list == null) {
                list = NOT_FOUND_CHILDREN;
            }
            this.listCache.put(path, list);
        }
        return list == NOT_FOUND_CHILDREN ? null : list.iterator();
    }

    int getEntryCacheSize() {
        return this.cache.size();
    }

    int getEntryCacheMaxSize() {
        return 50;
    }

    int getListCacheSize() {
        return this.listCache.size();
    }

    int getListCacheMaxSize() {
        return 20;
    }

    static {
        NOT_FOUND_CHILDREN = Collections.emptyList();
        try {
            NOT_FOUND_URL = new URL("file:/not_found");
        }
        catch (MalformedURLException mue) {
            throw new ExceptionInInitializerError(mue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BundleResourceMap<K, V>
    extends LinkedHashMap<String, V> {
        private static final int DEFAULT_LIMIT = 20;
        private final int limit;

        BundleResourceMap(int limit) {
            super(8, 0.75f, true);
            if (limit <= 0) {
                limit = 20;
            }
            this.limit = limit;
        }

        int getLimit() {
            return this.limit;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, V> eldest) {
            return this.size() > this.limit;
        }
    }
}

