/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bundleresource.impl;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.bundleresource.impl.BundleResourceProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
implements BundleActivator,
BundleListener {
    public static final String BUNDLE_RESOURCE_ROOTS = "Sling-Bundle-Resources";
    private static final String CONSOLE_PLUGIN_CLASS = "org.apache.sling.bundleresource.impl.BundleResourceWebConsolePlugin";
    private static final String METHOD_INIT = "initPlugin";
    private static final String METHOD_DESTROY = "destroyPlugin";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Map<Long, BundleResourceProvider> bundleResourceProviderMap = new HashMap<Long, BundleResourceProvider>();
    private BundleContext bundleContext;

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        context.addBundleListener((BundleListener)this);
        try {
            Bundle[] bundles;
            for (Bundle bundle : bundles = context.getBundles()) {
                if (bundle.getState() != 32) continue;
                this.addBundleResourceProvider(bundle);
            }
        }
        catch (Throwable t) {
            this.log.error("activate: Problem while registering bundle resources for existing bundles", t);
        }
        this.callMethod(CONSOLE_PLUGIN_CLASS, METHOD_INIT, new Class[]{BundleContext.class}, new Object[]{context});
    }

    public void stop(BundleContext context) throws Exception {
        this.callMethod(CONSOLE_PLUGIN_CLASS, METHOD_DESTROY, null, null);
        context.removeBundleListener((BundleListener)this);
        this.bundleContext = null;
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 2: {
                this.addBundleResourceProvider(event.getBundle());
                break;
            }
            case 4: {
                this.removeBundleResourceProvider(event.getBundle());
            }
        }
    }

    private void addBundleResourceProvider(Bundle bundle) {
        String prefixes = (String)bundle.getHeaders().get(BUNDLE_RESOURCE_ROOTS);
        if (prefixes != null) {
            BundleResourceProvider brp = new BundleResourceProvider(bundle, prefixes);
            brp.registerService(this.bundleContext);
            this.bundleResourceProviderMap.put(bundle.getBundleId(), brp);
        }
    }

    private void removeBundleResourceProvider(Bundle bundle) {
        BundleResourceProvider brp = this.bundleResourceProviderMap.remove(bundle.getBundleId());
        if (brp != null) {
            brp.unregisterService();
        }
    }

    private void callMethod(String clazzName, String methodName, Class<?>[] argTypes, Object[] args) {
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(clazzName);
            Method method = clazz.getDeclaredMethod(methodName, argTypes);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            method.invoke(null, args);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }
}

