/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.saml2;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@ObjectClassDefinition(name="SAML2 Service Provider (SP) Configuration", description="Configure SAML SSO by configuring details about your Identify Provider (IdP)and related Service Provider metadata")
public @interface AuthenticationHandlerSAML2Config {
    @AttributeDefinition(name="Path", description="Path under which this AuthenticationHandler should be used")
    public String path() default "";

    @AttributeDefinition(name="Service Provider Entity ID", description="The Entity ID for the SP")
    public String entityID() default "http://localhost:8080/";

    @AttributeDefinition(name="ACS Path", description="Service Provider's Assertion Consumer Service Path")
    public String acsPath() default "/sp/consumer";

    @AttributeDefinition(name="User ID (uid) Attribute Name", description="Name of the attribute holding the users unique id")
    public String saml2userIDAttr() default "username";

    @AttributeDefinition(name="Path for SAML2 Users", description="Home path for SAML2 Users")
    public String saml2userHome() default "/home/users/saml";

    @AttributeDefinition(name="groupMembership Attribute Name", description="Name of the attribute holding the users' group memberships")
    public String saml2groupMembershipAttr() default "";

    @AttributeDefinition(name="Synchronize User Attributes", description="Map of attributes from SAML Response to Synchronize. For example, urn:oid:1.2.840.113549.1.9.1=./profile/email saves this attribute if it exists under the users profile node with the property name 'email' ")
    public String[] syncAttrs() default {};

    @AttributeDefinition(name="SAML2 Session Attribute", description="Name used to save the users security context within a HTTP SESSION")
    public String saml2SessionAttr() default "saml2AuthInfo";

    @AttributeDefinition(name="SAML2 IDP Destination", description="")
    public String saml2IDPDestination() default "http://localhost:8080/idp/profile/SAML2/Redirect/SSO";

    @AttributeDefinition(name="Logout URL", description="Redirect User to this URL when they logout")
    public String saml2LogoutURL() default "https://sling.apache.org/";

    @AttributeDefinition(name="Service Provider Enabled", description="SAML2 Web Profile Service Provider Authentication Handler Enabled", type=AttributeType.BOOLEAN)
    public boolean saml2SPEnabled() default false;

    @AttributeDefinition(name="Sign and Encrypt Assertions", description="Highly Recommended for security", type=AttributeType.BOOLEAN)
    public boolean saml2SPEncryptAndSign() default false;

    @AttributeDefinition(name="Java Keystore (.jks) file location", description="File location of the Java Keystore JKS")
    public String jksFileLocation() default "";

    @AttributeDefinition(name="JKS Password (storepass)", description="Password needed for accessing the JKS", type=AttributeType.PASSWORD)
    public String jksStorePassword() default "";

    @AttributeDefinition(name="IDP Signing Certificate Alias", description="Alias of certificate to be used when verifying Identity Provider signature")
    public String idpCertAlias() default "";

    @AttributeDefinition(name="SP Keystore Alias", description="Alias identifying the Service Provider (SP) Encryption Key-pair (keystore alias)")
    public String spKeysAlias() default "";

    @AttributeDefinition(name="SP Keystore Password (keystore)", description="Password needed for accessing the Service Provider (SP) Key Pair identified by the SP Keystore Alias", type=AttributeType.PASSWORD)
    public String spKeysPassword() default "";
}

