/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.skywalking.library.elasticsearch.requests.search.BoolQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.aggregation.Aggregation;
import org.apache.skywalking.library.elasticsearch.requests.search.aggregation.AggregationBuilder;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHit;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.TagAutocompleteData;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.TagType;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.storage.query.ITagAutoCompleteQueryDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.ElasticSearchConverter;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.TimeRangeIndexNameGenerator;

public class TagAutoCompleteQueryDAO
extends EsDAO
implements ITagAutoCompleteQueryDAO {
    public TagAutoCompleteQueryDAO(ElasticSearchClient client) {
        super(client);
    }

    public Set<String> queryTagAutocompleteKeys(TagType tagType, int limit, Duration duration) throws IOException {
        long startSecondTB = 0L;
        long endSecondTB = 0L;
        if (Objects.nonNull(duration)) {
            startSecondTB = duration.getStartTimeBucketInSec();
            endSecondTB = duration.getEndTimeBucketInSec();
        }
        BoolQueryBuilder query = Query.bool();
        query.must((QueryBuilder)Query.term((String)"tag_type", (Object)tagType.name()));
        if (IndexController.LogicIndicesRegister.isMergedTable("tag_autocomplete")) {
            query.must((QueryBuilder)Query.term((String)"metric_table", (Object)"tag_autocomplete"));
        }
        SearchBuilder search = Search.builder().query((QueryBuilder)query);
        search.aggregation((AggregationBuilder)Aggregation.terms((String)"tag_key").field("tag_key").size(limit));
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search((Supplier)new TimeRangeIndexNameGenerator(IndexController.LogicIndicesRegister.getPhysicalTableName("tag_autocomplete"), startSecondTB, endSecondTB), search.build());
        Map terms = (Map)response.getAggregations().get("tag_key");
        List buckets = (List)terms.get("buckets");
        HashSet<String> tagKeys = new HashSet<String>();
        for (Map bucket : buckets) {
            String tagKey = (String)bucket.get("key");
            if (StringUtil.isEmpty((String)tagKey)) continue;
            tagKeys.add(tagKey);
        }
        return tagKeys;
    }

    public Set<String> queryTagAutocompleteValues(TagType tagType, String tagKey, int limit, Duration duration) throws IOException {
        long startSecondTB = 0L;
        long endSecondTB = 0L;
        if (Objects.nonNull(duration)) {
            startSecondTB = duration.getStartTimeBucketInSec();
            endSecondTB = duration.getEndTimeBucketInSec();
        }
        BoolQueryBuilder query = Query.bool().must((QueryBuilder)Query.term((String)"tag_key", (Object)tagKey));
        query.must((QueryBuilder)Query.term((String)"tag_type", (Object)tagType.name()));
        if (IndexController.LogicIndicesRegister.isMergedTable("tag_autocomplete")) {
            query.must((QueryBuilder)Query.term((String)"metric_table", (Object)"tag_autocomplete"));
        }
        SearchBuilder search = Search.builder().query((QueryBuilder)query).size(Integer.valueOf(limit));
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search((Supplier)new TimeRangeIndexNameGenerator(IndexController.LogicIndicesRegister.getPhysicalTableName("tag_autocomplete"), startSecondTB, endSecondTB), search.build());
        HashSet<String> tagValues = new HashSet<String>();
        for (SearchHit searchHit : response.getHits().getHits()) {
            TagAutocompleteData tag = new TagAutocompleteData.Builder().storage2Entity((Convert2Entity)new ElasticSearchConverter.ToEntity("tag_autocomplete", searchHit.getSource()));
            tagValues.add(tag.getTagValue());
        }
        return tagValues;
    }
}

