/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.library.elasticsearch.requests.search.BoolQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchParams;
import org.apache.skywalking.library.elasticsearch.requests.search.Sort;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHit;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.analysis.manual.spanattach.SpanAttachedEventRecord;
import org.apache.skywalking.oap.server.core.analysis.manual.spanattach.SpanAttachedEventTraceType;
import org.apache.skywalking.oap.server.core.storage.query.ISpanAttachedEventQueryDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.StorageModuleElasticsearchConfig;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.ElasticSearchConverter;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;

public class SpanAttachedEventEsDAO
extends EsDAO
implements ISpanAttachedEventQueryDAO {
    private final int scrollingBatchSize;

    public SpanAttachedEventEsDAO(ElasticSearchClient client, StorageModuleElasticsearchConfig config) {
        super(client);
        this.scrollingBatchSize = config.getProfileDataQueryBatchSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<SpanAttachedEventRecord> querySpanAttachedEvents(SpanAttachedEventTraceType type, List<String> traceIds) throws IOException {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("span_attached_event_record");
        BoolQueryBuilder query = Query.bool();
        if (IndexController.LogicIndicesRegister.isMergedTable("span_attached_event_record")) {
            query.must((QueryBuilder)Query.term((String)"record_table", (Object)"span_attached_event_record"));
        }
        SearchBuilder search = Search.builder().query((QueryBuilder)query).size(Integer.valueOf(this.scrollingBatchSize));
        query.must((QueryBuilder)Query.terms((String)"related_trace_id", traceIds));
        query.must((QueryBuilder)Query.terms((String)"trace_ref_type", (Object[])new Object[]{type.value()}));
        search.sort("start_time_second", Sort.Order.ASC);
        search.sort("start_time_nanos", Sort.Order.ASC);
        SearchParams params = new SearchParams().scroll(SCROLL_CONTEXT_RETENTION);
        ArrayList<SpanAttachedEventRecord> records = new ArrayList<SpanAttachedEventRecord>();
        SearchResponse results = ((ElasticSearchClient)this.getClient()).search(index, search.build(), params);
        HashSet<String> scrollIds = new HashSet<String>();
        try {
            while (true) {
                String scrollId = results.getScrollId();
                scrollIds.add(scrollId);
                if (results.getHits().getTotal() != 0) {
                    List<SpanAttachedEventRecord> batch = this.buildDataList(results);
                    records.addAll(batch);
                    if (batch.size() >= this.scrollingBatchSize) {
                        results = ((ElasticSearchClient)this.getClient()).scroll(SCROLL_CONTEXT_RETENTION, scrollId);
                        continue;
                    }
                }
                break;
            }
        }
        catch (Throwable throwable) {
            scrollIds.forEach(arg_0 -> ((ElasticSearchClient)((ElasticSearchClient)this.getClient())).deleteScrollContextQuietly(arg_0));
            throw throwable;
        }
        scrollIds.forEach(arg_0 -> ((ElasticSearchClient)((ElasticSearchClient)this.getClient())).deleteScrollContextQuietly(arg_0));
        return records;
    }

    private List<SpanAttachedEventRecord> buildDataList(SearchResponse response) {
        ArrayList<SpanAttachedEventRecord> records = new ArrayList<SpanAttachedEventRecord>();
        for (SearchHit hit : response.getHits()) {
            Map sourceAsMap = hit.getSource();
            SpanAttachedEventRecord.Builder builder = new SpanAttachedEventRecord.Builder();
            records.add(builder.storage2Entity((Convert2Entity)new ElasticSearchConverter.ToEntity("span_attached_event_record", sourceAsMap)));
        }
        return records;
    }
}

