/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base;

import java.io.IOException;
import java.util.Map;
import org.apache.skywalking.oap.server.core.analysis.management.ManagementData;
import org.apache.skywalking.oap.server.core.storage.IManagementDAO;
import org.apache.skywalking.oap.server.core.storage.StorageData;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.ElasticSearchConverter;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;

public class ManagementEsDAO
extends EsDAO
implements IManagementDAO {
    private final StorageBuilder<ManagementData> storageBuilder;

    public ManagementEsDAO(ElasticSearchClient client, StorageBuilder<ManagementData> storageBuilder) {
        super(client);
        this.storageBuilder = storageBuilder;
    }

    public void insert(Model model, ManagementData managementData) throws IOException {
        String tableName = IndexController.INSTANCE.getTableName(model);
        String docId = IndexController.INSTANCE.generateDocId(model, managementData.id().build());
        boolean exist = ((ElasticSearchClient)this.getClient()).existDoc(tableName, docId);
        if (exist) {
            return;
        }
        ElasticSearchConverter.ToStorage toStorage = new ElasticSearchConverter.ToStorage(model.getName());
        this.storageBuilder.entity2Storage((StorageData)managementData, (Convert2Storage)toStorage);
        Map<String, Object> source = IndexController.INSTANCE.appendTableColumn(model, (Map<String, Object>)toStorage.obtain());
        ((ElasticSearchClient)this.getClient()).forceInsert(tableName, docId, source);
    }
}

