/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch;

import java.io.ByteArrayInputStream;
import java.util.Properties;
import java.util.function.Function;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.config.ConfigService;
import org.apache.skywalking.oap.server.core.storage.IBatchDAO;
import org.apache.skywalking.oap.server.core.storage.IHistoryDeleteDAO;
import org.apache.skywalking.oap.server.core.storage.StorageBuilderFactory;
import org.apache.skywalking.oap.server.core.storage.StorageDAO;
import org.apache.skywalking.oap.server.core.storage.StorageModule;
import org.apache.skywalking.oap.server.core.storage.cache.INetworkAddressAliasDAO;
import org.apache.skywalking.oap.server.core.storage.management.UITemplateManagementDAO;
import org.apache.skywalking.oap.server.core.storage.model.ModelCreator;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IEBPFProfilingDataDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IEBPFProfilingScheduleDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IEBPFProfilingTaskDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IServiceLabelDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.trace.IProfileTaskLogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.trace.IProfileTaskQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.trace.IProfileThreadSnapshotQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IAggregationQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IAlarmQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IBrowserLogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IEventQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ILogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IMetadataQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IMetricsQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IRecordsQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ISpanAttachedEventQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITagAutoCompleteQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITopologyQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITraceQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IZipkinQueryDAO;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.library.util.HealthChecker;
import org.apache.skywalking.oap.server.library.util.MultipleFilesChangeMonitor;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.StorageModuleElasticsearchConfig;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.BatchProcessEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.HistoryDeleteEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.StorageEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.StorageEsInstaller;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.TimeSeriesUtils;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.cache.NetworkAddressAliasEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.AggregationQueryEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.AlarmQueryEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.BrowserLogQueryEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.EBPFProfilingDataEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.EBPFProfilingScheduleEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.EBPFProfilingTaskEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.ESEventQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.LogQueryEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.MetadataQueryEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.MetricsQueryEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.ProfileTaskLogEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.ProfileTaskQueryEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.ProfileThreadSnapshotQueryEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.RecordsQueryEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.ServiceLabelEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.SpanAttachedEventEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.TagAutoCompleteQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.TopologyQueryEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.TraceQueryEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.UITemplateManagementEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.zipkin.ZipkinQueryEsDAO;
import org.apache.skywalking.oap.server.telemetry.api.HealthCheckMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageModuleElasticsearchProvider
extends ModuleProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StorageModuleElasticsearchProvider.class);
    protected StorageModuleElasticsearchConfig config;
    protected ElasticSearchClient elasticSearchClient;
    protected StorageEsInstaller modelInstaller;

    public String name() {
        return "elasticsearch";
    }

    public Class<? extends ModuleDefine> module() {
        return StorageModule.class;
    }

    public ModuleProvider.ConfigCreator newConfigCreator() {
        return new ModuleProvider.ConfigCreator<StorageModuleElasticsearchConfig>(){

            public Class type() {
                return StorageModuleElasticsearchConfig.class;
            }

            public void onInitialized(StorageModuleElasticsearchConfig initialized) {
                StorageModuleElasticsearchProvider.this.config = initialized;
            }
        };
    }

    public void prepare() throws ServiceNotProvidedException {
        this.registerServiceImplementation(StorageBuilderFactory.class, (Service)new StorageBuilderFactory.Default());
        if (StringUtil.isEmpty((String)this.config.getNamespace())) {
            this.config.setNamespace("sw");
        } else {
            this.config.setNamespace(this.config.getNamespace().toLowerCase());
        }
        if (this.config.getDayStep() > 1) {
            TimeSeriesUtils.setDAY_STEP(this.config.getDayStep());
            TimeSeriesUtils.setSUPER_DATASET_DAY_STEP(this.config.getDayStep());
        }
        if (this.config.getSuperDatasetDayStep() > 0) {
            TimeSeriesUtils.setSUPER_DATASET_DAY_STEP(this.config.getSuperDatasetDayStep());
        }
        if (!StringUtil.isEmpty((String)this.config.getSecretsManagementFile())) {
            MultipleFilesChangeMonitor monitor = new MultipleFilesChangeMonitor(10L, readableContents -> {
                byte[] secretsFileContent = (byte[])readableContents.get(0);
                if (secretsFileContent == null) {
                    return;
                }
                Properties secrets = new Properties();
                secrets.load(new ByteArrayInputStream(secretsFileContent));
                this.config.setUser(secrets.getProperty("user", null));
                this.config.setPassword(secrets.getProperty("password", null));
                this.config.setTrustStorePass(secrets.getProperty("trustStorePass", null));
                if (this.elasticSearchClient != null) {
                    this.elasticSearchClient.setUser(this.config.getUser());
                    this.elasticSearchClient.setPassword(this.config.getPassword());
                    this.elasticSearchClient.setTrustStorePass(this.config.getTrustStorePass());
                    this.elasticSearchClient.connect();
                }
            }, new String[]{this.config.getSecretsManagementFile(), this.config.getTrustStorePath()});
            monitor.start();
        }
        this.elasticSearchClient = new ElasticSearchClient(this.config.getClusterNodes(), this.config.getProtocol(), this.config.getTrustStorePath(), this.config.getTrustStorePass(), this.config.getUser(), this.config.getPassword(), StorageModuleElasticsearchProvider.indexNameConverter(this.config.getNamespace()), this.config.getConnectTimeout(), this.config.getSocketTimeout(), this.config.getResponseTimeout(), this.config.getNumHttpClientThread());
        this.modelInstaller = new StorageEsInstaller((Client)this.elasticSearchClient, this.getManager(), this.config);
        this.registerServiceImplementation(IBatchDAO.class, (Service)new BatchProcessEsDAO(this.elasticSearchClient, this.config.getBulkActions(), this.config.getFlushInterval(), this.config.getConcurrentRequests(), this.config.getBatchOfBytes()));
        this.registerServiceImplementation(StorageDAO.class, (Service)new StorageEsDAO(this.elasticSearchClient));
        this.registerServiceImplementation(IHistoryDeleteDAO.class, (Service)new HistoryDeleteEsDAO(this.elasticSearchClient));
        this.registerServiceImplementation(INetworkAddressAliasDAO.class, (Service)new NetworkAddressAliasEsDAO(this.elasticSearchClient, this.config));
        this.registerServiceImplementation(ITopologyQueryDAO.class, (Service)new TopologyQueryEsDAO(this.elasticSearchClient));
        this.registerServiceImplementation(IMetricsQueryDAO.class, (Service)new MetricsQueryEsDAO(this.elasticSearchClient));
        this.registerServiceImplementation(ITraceQueryDAO.class, (Service)new TraceQueryEsDAO(this.elasticSearchClient, this.config.getSegmentQueryMaxSize()));
        this.registerServiceImplementation(IBrowserLogQueryDAO.class, (Service)new BrowserLogQueryEsDAO(this.elasticSearchClient));
        this.registerServiceImplementation(IMetadataQueryDAO.class, (Service)new MetadataQueryEsDAO(this.elasticSearchClient, this.config));
        this.registerServiceImplementation(IAggregationQueryDAO.class, (Service)new AggregationQueryEsDAO(this.elasticSearchClient));
        this.registerServiceImplementation(IAlarmQueryDAO.class, (Service)new AlarmQueryEsDAO(this.elasticSearchClient));
        this.registerServiceImplementation(IRecordsQueryDAO.class, (Service)new RecordsQueryEsDAO(this.elasticSearchClient));
        this.registerServiceImplementation(ILogQueryDAO.class, (Service)new LogQueryEsDAO(this.elasticSearchClient));
        this.registerServiceImplementation(IProfileTaskQueryDAO.class, (Service)new ProfileTaskQueryEsDAO(this.elasticSearchClient, this.config.getProfileTaskQueryMaxSize()));
        this.registerServiceImplementation(IProfileTaskLogQueryDAO.class, (Service)new ProfileTaskLogEsDAO(this.elasticSearchClient, this.config.getProfileTaskQueryMaxSize()));
        this.registerServiceImplementation(IProfileThreadSnapshotQueryDAO.class, (Service)new ProfileThreadSnapshotQueryEsDAO(this.elasticSearchClient, this.config.getProfileTaskQueryMaxSize()));
        this.registerServiceImplementation(UITemplateManagementDAO.class, (Service)new UITemplateManagementEsDAO(this.elasticSearchClient));
        this.registerServiceImplementation(IEventQueryDAO.class, (Service)new ESEventQueryDAO(this.elasticSearchClient));
        this.registerServiceImplementation(IEBPFProfilingTaskDAO.class, (Service)new EBPFProfilingTaskEsDAO(this.elasticSearchClient, this.config));
        this.registerServiceImplementation(IEBPFProfilingScheduleDAO.class, (Service)new EBPFProfilingScheduleEsDAO(this.elasticSearchClient, this.config));
        this.registerServiceImplementation(IEBPFProfilingDataDAO.class, (Service)new EBPFProfilingDataEsDAO(this.elasticSearchClient, this.config));
        this.registerServiceImplementation(IServiceLabelDAO.class, (Service)new ServiceLabelEsDAO(this.elasticSearchClient, this.config));
        this.registerServiceImplementation(ITagAutoCompleteQueryDAO.class, (Service)new TagAutoCompleteQueryDAO(this.elasticSearchClient));
        this.registerServiceImplementation(IZipkinQueryDAO.class, (Service)new ZipkinQueryEsDAO(this.elasticSearchClient));
        this.registerServiceImplementation(ISpanAttachedEventQueryDAO.class, (Service)new SpanAttachedEventEsDAO(this.elasticSearchClient, this.config));
        IndexController.INSTANCE.setLogicSharding(this.config.isLogicSharding());
        IndexController.INSTANCE.setEnableCustomRouting(this.config.isEnableCustomRouting());
    }

    public void start() throws ModuleStartException {
        MetricsCreator metricCreator = (MetricsCreator)this.getManager().find("telemetry").provider().getService(MetricsCreator.class);
        HealthCheckMetrics healthChecker = metricCreator.createHealthCheckerGauge("storage_elasticsearch", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
        this.elasticSearchClient.registerChecker((HealthChecker)healthChecker);
        try {
            this.elasticSearchClient.connect();
            ConfigService service = (ConfigService)this.getManager().find("core").provider().getService(ConfigService.class);
            this.modelInstaller.setIndexRefreshInterval(service.getPersistentPeriod() + 5);
            this.modelInstaller.start();
            ((ModelCreator)this.getManager().find("core").provider().getService(ModelCreator.class)).addModelListener((ModelCreator.CreatingListener)this.modelInstaller);
        }
        catch (Exception e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
    }

    public void notifyAfterCompleted() {
    }

    public String[] requiredModules() {
        return new String[]{"core"};
    }

    public static Function<String, String> indexNameConverter(String namespace) {
        return indexName -> {
            if (StringUtil.isNotEmpty((String)namespace)) {
                return namespace + "_" + indexName;
            }
            return indexName;
        };
    }
}

