/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.promql.rt;

import java.util.Map;
import org.apache.skywalking.oap.query.promql.entity.ErrorType;
import org.apache.skywalking.oap.query.promql.entity.LabelName;
import org.apache.skywalking.oap.query.promql.rt.result.MatcherSetResult;
import org.apache.skywalking.oap.query.promql.rt.result.ParseResultType;
import org.apache.skywalking.promql.rt.grammar.PromQLParser;
import org.apache.skywalking.promql.rt.grammar.PromQLParserBaseVisitor;

public class PromQLMatchVisitor
extends PromQLParserBaseVisitor<MatcherSetResult> {
    @Override
    public MatcherSetResult visitMetricInstant(PromQLParser.MetricInstantContext ctx) {
        String metricName = ctx.metricName().getText();
        MatcherSetResult result = new MatcherSetResult();
        result.setResultType(ParseResultType.MATCH);
        result.setMetricName(metricName);
        Map<LabelName, String> labelMap = result.getLabelMap();
        if (ctx.labelList() != null) {
            for (PromQLParser.LabelContext labelCtx : ctx.labelList().label()) {
                String labelName = labelCtx.labelName().getText();
                String labelValue = labelCtx.labelValue().getText();
                String labelValueTrim = labelValue.substring(1, labelValue.length() - 1);
                try {
                    labelMap.put(LabelName.labelOf(labelName), labelValueTrim);
                }
                catch (IllegalArgumentException e) {
                    result.setErrorType(ErrorType.BAD_DATA);
                    result.setErrorInfo("Label:[" + labelName + "] is illegal.");
                    return result;
                }
            }
        }
        return result;
    }
}

