/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.promql.rt;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.skywalking.oap.query.promql.entity.MetricRangeData;
import org.apache.skywalking.oap.query.promql.entity.TimeValuePair;
import org.apache.skywalking.oap.query.promql.rt.exception.IllegalExpressionException;
import org.apache.skywalking.oap.query.promql.rt.result.MetricsRangeResult;
import org.apache.skywalking.oap.query.promql.rt.result.ParseResultType;
import org.apache.skywalking.oap.query.promql.rt.result.ScalarResult;
import org.apache.skywalking.oap.server.core.query.DurationUtils;
import org.apache.skywalking.oap.server.core.query.PointOfTime;
import org.apache.skywalking.oap.server.core.query.enumeration.Step;
import org.apache.skywalking.oap.server.core.query.type.KVInt;
import org.apache.skywalking.oap.server.core.query.type.MetricsValues;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class PromOpUtils {
    public static org.apache.skywalking.oap.server.core.query.input.Duration timestamp2Duration(long startTS, long endTS) {
        org.apache.skywalking.oap.server.core.query.input.Duration duration = new org.apache.skywalking.oap.server.core.query.input.Duration();
        if (endTS < startTS) {
            throw new IllegalArgumentException("End time must not be before start");
        }
        DateTime startDT = new DateTime(startTS);
        DateTime endDT = new DateTime(endTS);
        long durationValue = endTS - startTS;
        if (durationValue <= 3600000L) {
            duration.setStep(Step.MINUTE);
            duration.setStart(startDT.toString(DurationUtils.YYYY_MM_DD_HHMM));
            duration.setEnd(endDT.toString(DurationUtils.YYYY_MM_DD_HHMM));
        } else if (durationValue <= 86400000L) {
            duration.setStep(Step.HOUR);
            duration.setStart(startDT.toString(DurationUtils.YYYY_MM_DD_HH));
            duration.setEnd(endDT.toString(DurationUtils.YYYY_MM_DD_HH));
        } else {
            duration.setStep(Step.DAY);
            duration.setStart(startDT.toString(DurationUtils.YYYY_MM_DD));
            duration.setEnd(endDT.toString(DurationUtils.YYYY_MM_DD));
        }
        return duration;
    }

    static MetricsRangeResult matrixScalarBinaryOp(MetricsRangeResult matrix, ScalarResult scalar, int opType) {
        MetricsRangeResult result = new MetricsRangeResult();
        result.setResultType(ParseResultType.METRICS_RANGE);
        matrix.getMetricDataList().forEach(metricData -> {
            MetricRangeData newData = new MetricRangeData();
            result.getMetricDataList().add(newData);
            newData.setMetric(metricData.getMetric());
            List<TimeValuePair> newValues = metricData.getValues().stream().map(value -> {
                double v = Double.parseDouble(value.getValue());
                return new TimeValuePair(value.getTime(), PromOpUtils.formatDoubleValue(PromOpUtils.scalarBinaryOp(v, scalar.getValue(), opType)));
            }).collect(Collectors.toList());
            newData.setValues(newValues);
        });
        return result;
    }

    static MetricsRangeResult matrixBinaryOp(MetricsRangeResult matrixLeft, MetricsRangeResult matrixRight, int opType) throws IllegalExpressionException {
        MetricsRangeResult result = new MetricsRangeResult();
        result.setResultType(ParseResultType.METRICS_RANGE);
        for (int i = 0; i < matrixLeft.getMetricDataList().size(); ++i) {
            MetricRangeData dataLeft = matrixLeft.getMetricDataList().get(i);
            MetricRangeData dataRight = matrixRight.getMetricDataList().get(i);
            if (!dataLeft.getMetric().equals(dataRight.getMetric())) {
                throw new IllegalExpressionException("The metric info result left in conformity with right.");
            }
            if (dataLeft.getValues().size() != dataRight.getValues().size()) {
                throw new IllegalExpressionException("The metric value range left in conformity with right.");
            }
            MetricRangeData newData = new MetricRangeData();
            result.getMetricDataList().add(newData);
            newData.setMetric(dataLeft.getMetric());
            ArrayList<TimeValuePair> newValues = new ArrayList<TimeValuePair>();
            newData.setValues(newValues);
            for (int j = 0; j < dataLeft.getValues().size(); ++j) {
                double lv = Double.parseDouble(dataLeft.getValues().get(j).getValue());
                double rv = Double.parseDouble(dataRight.getValues().get(j).getValue());
                newValues.add(new TimeValuePair(dataLeft.getValues().get(j).getTime(), PromOpUtils.formatDoubleValue(PromOpUtils.scalarBinaryOp(lv, rv, opType))));
            }
        }
        return result;
    }

    static double scalarBinaryOp(double leftValue, double rightValue, int opType) {
        double calculatedResult = 0.0;
        switch (opType) {
            case 12: {
                calculatedResult = leftValue + rightValue;
                break;
            }
            case 11: {
                calculatedResult = leftValue - rightValue;
                break;
            }
            case 13: {
                calculatedResult = leftValue * rightValue;
                break;
            }
            case 14: {
                calculatedResult = leftValue / rightValue;
                break;
            }
            case 15: {
                calculatedResult = leftValue % rightValue;
            }
        }
        return calculatedResult;
    }

    static int scalarCompareOp(double leftValue, double rightValue, int opType) {
        int comparedResult = 0;
        switch (opType) {
            case 16: {
                comparedResult = PromOpUtils.boolToInt(leftValue == rightValue);
                break;
            }
            case 17: {
                comparedResult = PromOpUtils.boolToInt(leftValue != rightValue);
                break;
            }
            case 21: {
                comparedResult = PromOpUtils.boolToInt(leftValue > rightValue);
                break;
            }
            case 19: {
                comparedResult = PromOpUtils.boolToInt(leftValue < rightValue);
                break;
            }
            case 20: {
                comparedResult = PromOpUtils.boolToInt(leftValue >= rightValue);
                break;
            }
            case 18: {
                comparedResult = PromOpUtils.boolToInt(leftValue <= rightValue);
            }
        }
        return comparedResult;
    }

    private static int boolToInt(boolean v) {
        return v ? 1 : 0;
    }

    static MetricsRangeResult matrixScalarCompareOp(MetricsRangeResult matrix, ScalarResult scalar, int opType) {
        MetricsRangeResult result = new MetricsRangeResult();
        result.setResultType(ParseResultType.METRICS_RANGE);
        matrix.getMetricDataList().forEach(metricData -> {
            MetricRangeData newData = new MetricRangeData();
            result.getMetricDataList().add(newData);
            newData.setMetric(metricData.getMetric());
            List<TimeValuePair> newValues = metricData.getValues().stream().filter(timeValuePair -> PromOpUtils.scalarCompareOp(Double.parseDouble(timeValuePair.getValue()), scalar.getValue(), opType) == 1).collect(Collectors.toList());
            newData.setValues(newValues);
        });
        return result;
    }

    static MetricsRangeResult matrixCompareOp(MetricsRangeResult matrixLeft, MetricsRangeResult matrixRight, int opType) throws IllegalExpressionException {
        MetricsRangeResult result = new MetricsRangeResult();
        result.setResultType(ParseResultType.METRICS_RANGE);
        for (int i = 0; i < matrixLeft.getMetricDataList().size(); ++i) {
            MetricRangeData dataLeft = matrixLeft.getMetricDataList().get(i);
            MetricRangeData dataRight = matrixRight.getMetricDataList().get(i);
            if (!dataLeft.getMetric().equals(dataRight.getMetric())) {
                throw new IllegalExpressionException("The metric info result left in conformity with right.");
            }
            if (dataLeft.getValues().size() != dataRight.getValues().size()) {
                throw new IllegalExpressionException("The metric value range left in conformity with right.");
            }
            MetricRangeData newData = new MetricRangeData();
            result.getMetricDataList().add(newData);
            newData.setMetric(dataLeft.getMetric());
            ArrayList<TimeValuePair> newValues = new ArrayList<TimeValuePair>();
            newData.setValues(newValues);
            for (int j = 0; j < dataLeft.getValues().size(); ++j) {
                double rv;
                double lv = Double.parseDouble(dataLeft.getValues().get(j).getValue());
                if (PromOpUtils.scalarCompareOp(lv, rv = Double.parseDouble(dataRight.getValues().get(j).getValue()), opType) != 1) continue;
                newValues.add(dataLeft.getValues().get(j));
            }
        }
        return result;
    }

    public static List<TimeValuePair> buildMatrixValues(org.apache.skywalking.oap.server.core.query.input.Duration duration, String singleValue) {
        List times = duration.assembleDurationPoints();
        ArrayList<TimeValuePair> values = new ArrayList<TimeValuePair>(times.size());
        for (PointOfTime time : times) {
            long retTimestampSec = DurationUtils.INSTANCE.parseToDateTime(duration.getStep(), time.getPoint()).getMillis() / 1000L;
            TimeValuePair value = new TimeValuePair(retTimestampSec, singleValue);
            values.add(value);
        }
        return values;
    }

    static List<TimeValuePair> buildMatrixValues(org.apache.skywalking.oap.server.core.query.input.Duration duration, MetricsValues metricsValues) {
        List times = duration.assembleDurationPoints();
        ArrayList<TimeValuePair> values = new ArrayList<TimeValuePair>(times.size());
        for (int i = 0; i < times.size(); ++i) {
            long retTimestampSec = DurationUtils.INSTANCE.parseToDateTime(duration.getStep(), ((PointOfTime)times.get(i)).getPoint()).getMillis() / 1000L;
            KVInt kvInt = (KVInt)metricsValues.getValues().getValues().get(i);
            if (kvInt.isEmptyValue()) continue;
            TimeValuePair value = new TimeValuePair(retTimestampSec, Long.toString(kvInt.getValue()));
            values.add(value);
        }
        return values;
    }

    public static String formatDoubleValue(double v) {
        DecimalFormat format = new DecimalFormat("#.##");
        return format.format(v);
    }

    public static Duration formatDuration(String duration) {
        PeriodFormatter f = new PeriodFormatterBuilder().appendWeeks().appendSuffix("w").appendDays().appendSuffix("d").appendHours().appendSuffix("h").appendMinutes().appendSuffix("m").appendSeconds().appendSuffix("s").appendMillis().appendSuffix("ms").toFormatter();
        return f.parsePeriod(duration).toStandardDuration();
    }
}

