/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.promql.handler;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Path;
import com.linecorp.armeria.server.annotation.Post;
import graphql.org.antlr.v4.runtime.misc.ParseCancellationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.skywalking.oap.query.graphql.resolver.MetadataQueryV2;
import org.apache.skywalking.oap.query.graphql.resolver.MetricsQuery;
import org.apache.skywalking.oap.query.graphql.resolver.RecordsQuery;
import org.apache.skywalking.oap.query.promql.entity.ErrorType;
import org.apache.skywalking.oap.query.promql.entity.LabelName;
import org.apache.skywalking.oap.query.promql.entity.LabelValuePair;
import org.apache.skywalking.oap.query.promql.entity.MetricInfo;
import org.apache.skywalking.oap.query.promql.entity.MetricInstantData;
import org.apache.skywalking.oap.query.promql.entity.MetricMetadata;
import org.apache.skywalking.oap.query.promql.entity.MetricRangeData;
import org.apache.skywalking.oap.query.promql.entity.ResultStatus;
import org.apache.skywalking.oap.query.promql.entity.TimeValuePair;
import org.apache.skywalking.oap.query.promql.entity.response.ExprQueryRsp;
import org.apache.skywalking.oap.query.promql.entity.response.LabelValuesQueryRsp;
import org.apache.skywalking.oap.query.promql.entity.response.LabelsQueryRsp;
import org.apache.skywalking.oap.query.promql.entity.response.MetadataQueryRsp;
import org.apache.skywalking.oap.query.promql.entity.response.MetricRspData;
import org.apache.skywalking.oap.query.promql.entity.response.MetricType;
import org.apache.skywalking.oap.query.promql.entity.response.QueryResponse;
import org.apache.skywalking.oap.query.promql.entity.response.ResultType;
import org.apache.skywalking.oap.query.promql.entity.response.ScalarRspData;
import org.apache.skywalking.oap.query.promql.entity.response.SeriesQueryRsp;
import org.apache.skywalking.oap.query.promql.rt.PromOpUtils;
import org.apache.skywalking.oap.query.promql.rt.PromQLExprQueryVisitor;
import org.apache.skywalking.oap.query.promql.rt.PromQLMatchVisitor;
import org.apache.skywalking.oap.query.promql.rt.exception.ParseErrorListener;
import org.apache.skywalking.oap.query.promql.rt.result.MatcherSetResult;
import org.apache.skywalking.oap.query.promql.rt.result.MetricsRangeResult;
import org.apache.skywalking.oap.query.promql.rt.result.ParseResult;
import org.apache.skywalking.oap.query.promql.rt.result.ScalarResult;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.query.MetricDefinition;
import org.apache.skywalking.oap.server.core.query.enumeration.Scope;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.Endpoint;
import org.apache.skywalking.oap.server.core.query.type.Service;
import org.apache.skywalking.oap.server.core.query.type.ServiceInstance;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnMetadata;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.promql.rt.grammar.PromQLLexer;
import org.apache.skywalking.promql.rt.grammar.PromQLParser;

public class PromQLApiHandler {
    private final MetadataQueryV2 metadataQuery;
    private final MetricsQuery metricsQuery;
    private final RecordsQuery recordsQuery;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public PromQLApiHandler(ModuleManager moduleManager) {
        this.metadataQuery = new MetadataQueryV2(moduleManager);
        this.metricsQuery = new MetricsQuery(moduleManager);
        this.recordsQuery = new RecordsQuery(moduleManager);
    }

    @Get
    @Path(value="/api/v1/metadata")
    public HttpResponse metadata(@Param(value="limit") Optional<Integer> limit, @Param(value="metric") Optional<String> metric) throws JsonProcessingException {
        MetadataQueryRsp response = new MetadataQueryRsp();
        response.setStatus(ResultStatus.SUCCESS);
        String regex = metric.orElse("");
        List definitionList = this.metricsQuery.listMetrics(regex);
        int inputLimit = limit.orElse(definitionList.size());
        int maxNum = Math.min(inputLimit, definitionList.size());
        for (int i = 0; i < maxNum; ++i) {
            ArrayList<MetricMetadata> metadataList = new ArrayList<MetricMetadata>();
            MetricMetadata metadata = new MetricMetadata(MetricType.GAUGE, "", "");
            metadataList.add(metadata);
            response.getData().put(((MetricDefinition)definitionList.get(i)).getName(), metadataList);
        }
        return this.jsonResponse(response);
    }

    @Get
    @Post
    @Path(value="/api/v1/labels")
    public HttpResponse labels(@Param(value="match[]") Optional<String> match, @Param(value="start") Optional<String> start, @Param(value="end") Optional<String> end) throws IOException {
        LabelsQueryRsp response = new LabelsQueryRsp();
        if (match.isPresent()) {
            PromQLParser.ExpressionContext tree;
            PromQLLexer lexer = new PromQLLexer((CharStream)CharStreams.fromString((String)match.get()));
            lexer.addErrorListener((ANTLRErrorListener)new ParseErrorListener());
            PromQLParser parser = new PromQLParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
            parser.addErrorListener((ANTLRErrorListener)new ParseErrorListener());
            try {
                tree = parser.expression();
            }
            catch (ParseCancellationException e) {
                response.setStatus(ResultStatus.ERROR);
                response.setErrorType(ErrorType.BAD_DATA);
                response.setError(e.getMessage());
                return this.jsonResponse(response);
            }
            PromQLMatchVisitor visitor = new PromQLMatchVisitor();
            MatcherSetResult parseResult = (MatcherSetResult)visitor.visit((ParseTree)tree);
            String metricName = parseResult.getMetricName();
            Optional valueColumn = ValueColumnMetadata.INSTANCE.readValueColumnDefinition(metricName);
            if (valueColumn.isPresent()) {
                ValueColumnMetadata.ValueColumn metaData = (ValueColumnMetadata.ValueColumn)valueColumn.get();
                Scope scope = Scope.Finder.valueOf((int)metaData.getScopeId());
                Column.ValueDataType dataType = metaData.getDataType();
                response.getData().addAll(this.buildLabelNames(scope, dataType));
            }
        } else {
            Arrays.stream(LabelName.values()).forEach(label -> response.getData().add((LabelName)((Object)label)));
        }
        response.setStatus(ResultStatus.SUCCESS);
        return this.jsonResponse(response);
    }

    @Get
    @Path(value="/api/v1/label/{label_name}/values")
    public HttpResponse labelValues(@Param(value="label_name") String labelName, @Param(value="match[]") Optional<String> match, @Param(value="start") Optional<String> start, @Param(value="end") Optional<String> end) throws IOException {
        LabelValuesQueryRsp response = new LabelValuesQueryRsp();
        response.setStatus(ResultStatus.SUCCESS);
        switch (LabelName.labelOf(labelName)) {
            case NAME: {
                this.metricsQuery.listMetrics("").forEach(definition -> response.getData().add(definition.getName()));
                break;
            }
            case LAYER: {
                for (Layer layer : Layer.values()) {
                    response.getData().add(layer.name());
                }
                break;
            }
            case SCOPE: {
                for (Scope scope : Scope.values()) {
                    response.getData().add(scope.name());
                }
                break;
            }
        }
        return this.jsonResponse(response);
    }

    @Get
    @Post
    @Path(value="/api/v1/series")
    public HttpResponse series(@Param(value="match[]") String match, @Param(value="start") String start, @Param(value="end") String end) throws IOException {
        PromQLParser.ExpressionContext tree;
        long startTS = PromQLApiHandler.formatTimestamp2Millis(start);
        long endTS = PromQLApiHandler.formatTimestamp2Millis(end);
        Duration duration = PromOpUtils.timestamp2Duration(startTS, endTS);
        SeriesQueryRsp response = new SeriesQueryRsp();
        PromQLLexer lexer = new PromQLLexer((CharStream)CharStreams.fromString((String)match));
        lexer.addErrorListener((ANTLRErrorListener)new ParseErrorListener());
        PromQLParser parser = new PromQLParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.addErrorListener((ANTLRErrorListener)new ParseErrorListener());
        try {
            tree = parser.expression();
        }
        catch (ParseCancellationException e) {
            response.setStatus(ResultStatus.ERROR);
            response.setErrorType(ErrorType.BAD_DATA);
            response.setError(e.getMessage());
            return this.jsonResponse(response);
        }
        PromQLMatchVisitor visitor = new PromQLMatchVisitor();
        MatcherSetResult parseResult = (MatcherSetResult)visitor.visit((ParseTree)tree);
        String metricName = parseResult.getMetricName();
        Optional valueColumn = ValueColumnMetadata.INSTANCE.readValueColumnDefinition(metricName);
        if (valueColumn.isPresent()) {
            ValueColumnMetadata.ValueColumn metaData = (ValueColumnMetadata.ValueColumn)valueColumn.get();
            Scope scope = Scope.Finder.valueOf((int)metaData.getScopeId());
            Column.ValueDataType dataType = metaData.getDataType();
            response.getData().add(this.buildMetaMetricInfo(metricName, scope, dataType));
        } else if (Objects.equals(metricName, "service_traffic")) {
            String serviceName = parseResult.getLabelMap().get((Object)LabelName.SERVICE);
            if (StringUtil.isNotBlank((String)serviceName)) {
                Service service2 = this.metadataQuery.findService(serviceName);
                response.getData().add(this.buildMetricInfoFromTraffic(metricName, service2));
            } else {
                List services = this.metadataQuery.listServices(parseResult.getLabelMap().get((Object)LabelName.LAYER));
                services.forEach(service -> response.getData().add(this.buildMetricInfoFromTraffic(metricName, (Service)service)));
            }
        } else if (Objects.equals(metricName, "instance_traffic")) {
            String serviceName = parseResult.getLabelMap().get((Object)LabelName.SERVICE);
            String layer = parseResult.getLabelMap().get((Object)LabelName.LAYER);
            List instances = this.metadataQuery.listInstances(duration, IDManager.ServiceID.buildId((String)serviceName, (boolean)Layer.valueOf((String)layer).isNormal()));
            instances.forEach(instance -> response.getData().add(this.buildMetricInfoFromTraffic(metricName, (ServiceInstance)instance)));
        } else if (Objects.equals(metricName, "endpoint_traffic")) {
            String serviceName = parseResult.getLabelMap().get((Object)LabelName.SERVICE);
            String layer = parseResult.getLabelMap().get((Object)LabelName.LAYER);
            String keyword = parseResult.getLabelMap().getOrDefault((Object)LabelName.KEYWORD, "");
            String limit = parseResult.getLabelMap().getOrDefault((Object)LabelName.LIMIT, "100");
            List endpoints = this.metadataQuery.findEndpoint(keyword, IDManager.ServiceID.buildId((String)serviceName, (boolean)Layer.valueOf((String)layer).isNormal()), Integer.parseInt(limit));
            endpoints.forEach(endpoint -> response.getData().add(this.buildMetricInfoFromTraffic(metricName, (Endpoint)endpoint)));
        }
        response.setStatus(ResultStatus.SUCCESS);
        return this.jsonResponse(response);
    }

    @Get
    @Post
    @Path(value="/api/v1/query")
    public HttpResponse query(@Param(value="query") String query, @Param(value="time") Optional<String> time, @Param(value="timeout") Optional<String> timeout) throws IOException {
        PromQLParser.ExpressionContext tree;
        long endTS = System.currentTimeMillis();
        if (time.isPresent()) {
            endTS = PromQLApiHandler.formatTimestamp2Millis(time.get());
        }
        long startTS = endTS - 120000L;
        Duration duration = PromOpUtils.timestamp2Duration(startTS, endTS);
        ExprQueryRsp response = new ExprQueryRsp();
        PromQLLexer lexer = new PromQLLexer((CharStream)CharStreams.fromString((String)query));
        lexer.addErrorListener((ANTLRErrorListener)new ParseErrorListener());
        PromQLParser parser = new PromQLParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.addErrorListener((ANTLRErrorListener)new ParseErrorListener());
        try {
            tree = parser.expression();
        }
        catch (ParseCancellationException e) {
            response.setStatus(ResultStatus.ERROR);
            response.setErrorType(ErrorType.BAD_DATA);
            response.setError(e.getMessage());
            return this.jsonResponse(response);
        }
        PromQLExprQueryVisitor visitor = new PromQLExprQueryVisitor(this.metricsQuery, this.recordsQuery, duration, QueryType.INSTANT);
        ParseResult parseResult = (ParseResult)visitor.visit((ParseTree)tree);
        if (parseResult == null) {
            response.setStatus(ResultStatus.ERROR);
            response.setErrorType(ErrorType.BAD_DATA);
            response.setError("Bad expression, can not parse it.");
        } else if (StringUtil.isBlank((String)parseResult.getErrorInfo())) {
            if (parseResult.isRangeExpression()) {
                this.buildMatrixRsp(parseResult, response);
            } else {
                switch (parseResult.getResultType()) {
                    case METRICS_RANGE: {
                        this.buildVectorRsp(parseResult, response);
                        break;
                    }
                    case SCALAR: {
                        this.buildScalarRsp(parseResult, response);
                    }
                }
            }
        } else {
            response.setStatus(ResultStatus.ERROR);
            response.setErrorType(parseResult.getErrorType());
            response.setError(parseResult.getErrorInfo());
        }
        return this.jsonResponse(response);
    }

    @Get
    @Post
    @Path(value="/api/v1/query_range")
    public HttpResponse query_range(@Param(value="query") String query, @Param(value="start") String start, @Param(value="end") String end, @Param(value="step") Optional<String> step, @Param(value="timeout") Optional<String> timeout) throws IOException {
        PromQLParser.ExpressionContext tree;
        long startTS = PromQLApiHandler.formatTimestamp2Millis(start);
        long endTS = PromQLApiHandler.formatTimestamp2Millis(end);
        Duration duration = PromOpUtils.timestamp2Duration(startTS, endTS);
        ExprQueryRsp response = new ExprQueryRsp();
        PromQLLexer lexer = new PromQLLexer((CharStream)CharStreams.fromString((String)query));
        lexer.addErrorListener((ANTLRErrorListener)new ParseErrorListener());
        PromQLParser parser = new PromQLParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.addErrorListener((ANTLRErrorListener)new ParseErrorListener());
        try {
            tree = parser.expression();
        }
        catch (ParseCancellationException e) {
            response.setStatus(ResultStatus.ERROR);
            response.setErrorType(ErrorType.BAD_DATA);
            response.setError(e.getMessage());
            return this.jsonResponse(response);
        }
        PromQLExprQueryVisitor visitor = new PromQLExprQueryVisitor(this.metricsQuery, this.recordsQuery, duration, QueryType.RANGE);
        ParseResult parseResult = (ParseResult)visitor.visit((ParseTree)tree);
        if (parseResult == null) {
            response.setStatus(ResultStatus.ERROR);
            response.setErrorType(ErrorType.BAD_DATA);
            response.setError("Bad expression, can not parse it.");
        } else if (StringUtil.isBlank((String)parseResult.getErrorInfo())) {
            switch (parseResult.getResultType()) {
                case METRICS_RANGE: {
                    this.buildMatrixRsp(parseResult, response);
                    break;
                }
                case SCALAR: {
                    this.buildScalarMatrixRsp(duration, parseResult, response);
                }
            }
        } else {
            response.setStatus(ResultStatus.ERROR);
            response.setErrorType(parseResult.getErrorType());
            response.setError(parseResult.getErrorInfo());
        }
        return this.jsonResponse(response);
    }

    private HttpResponse jsonResponse(QueryResponse response) throws JsonProcessingException {
        return HttpResponse.of((ResponseHeaders)ResponseHeaders.builder((HttpStatus)HttpStatus.OK).contentType(MediaType.JSON).build(), (HttpData)HttpData.ofUtf8((String)MAPPER.writeValueAsString((Object)response)));
    }

    private void buildVectorRsp(ParseResult parseResult, ExprQueryRsp response) {
        MetricRspData exprRspData = new MetricRspData();
        response.setData(exprRspData);
        exprRspData.setResultType(ResultType.VECTOR);
        MetricsRangeResult matrixResult = (MetricsRangeResult)parseResult;
        response.setStatus(ResultStatus.SUCCESS);
        matrixResult.getMetricDataList().forEach(rangData -> {
            List<TimeValuePair> values = rangData.getValues();
            if (values.size() > 0) {
                MetricInstantData instantData = new MetricInstantData();
                instantData.setValue(values.get(values.size() - 1));
                instantData.setMetric(rangData.getMetric());
                exprRspData.getResult().add(instantData);
            }
        });
    }

    private void buildScalarRsp(ParseResult parseResult, ExprQueryRsp response) {
        ScalarRspData scalarRspData = new ScalarRspData();
        response.setData(scalarRspData);
        scalarRspData.setResultType(ResultType.SCALAR);
        ScalarResult scalarResult = (ScalarResult)parseResult;
        response.setStatus(ResultStatus.SUCCESS);
        scalarRspData.setResult(new TimeValuePair(System.currentTimeMillis() / 1000L, PromOpUtils.formatDoubleValue(scalarResult.getValue())));
    }

    private void buildMatrixRsp(ParseResult parseResult, ExprQueryRsp response) {
        MetricRspData responseData = new MetricRspData();
        responseData.setResultType(ResultType.MATRIX);
        response.setData(responseData);
        MetricsRangeResult matrixResult = (MetricsRangeResult)parseResult;
        response.setStatus(ResultStatus.SUCCESS);
        responseData.getResult().addAll(matrixResult.getMetricDataList());
    }

    private void buildScalarMatrixRsp(Duration duration, ParseResult parseResult, ExprQueryRsp response) {
        MetricRspData responseData = new MetricRspData();
        responseData.setResultType(ResultType.MATRIX);
        response.setData(responseData);
        ScalarResult scalarResult = (ScalarResult)parseResult;
        response.setStatus(ResultStatus.SUCCESS);
        MetricRangeData metricData = new MetricRangeData();
        metricData.setValues(PromOpUtils.buildMatrixValues(duration, PromOpUtils.formatDoubleValue(scalarResult.getValue())));
        responseData.getResult().add(metricData);
    }

    private static long formatTimestamp2Millis(String timestamp) {
        return Double.valueOf(timestamp).longValue() * 1000L;
    }

    private List<LabelName> buildLabelNames(Scope scope, Column.ValueDataType dataType) {
        ArrayList<LabelName> labelNames = new ArrayList<LabelName>();
        labelNames.add(LabelName.LAYER);
        labelNames.add(LabelName.SERVICE);
        labelNames.add(LabelName.TOP_N);
        labelNames.add(LabelName.ORDER);
        if (Column.ValueDataType.LABELED_VALUE == dataType) {
            labelNames.add(LabelName.LABELS);
            labelNames.add(LabelName.RELABELS);
        }
        switch (scope) {
            case ServiceInstance: {
                labelNames.add(LabelName.SERVICE_INSTANCE);
                labelNames.add(LabelName.PARENT_SERVICE);
                break;
            }
            case Endpoint: {
                labelNames.add(LabelName.ENDPOINT);
                labelNames.add(LabelName.PARENT_SERVICE);
            }
        }
        return labelNames;
    }

    private MetricInfo buildMetaMetricInfo(String metricName, Scope scope, Column.ValueDataType dataType) {
        MetricInfo metricInfo = new MetricInfo(metricName);
        metricInfo.getLabels().add(new LabelValuePair(LabelName.LAYER, ""));
        metricInfo.getLabels().add(new LabelValuePair(LabelName.TOP_N, ""));
        metricInfo.getLabels().add(new LabelValuePair(LabelName.ORDER, ""));
        if (Column.ValueDataType.LABELED_VALUE == dataType) {
            metricInfo.getLabels().add(new LabelValuePair(LabelName.LABELS, ""));
            metricInfo.getLabels().add(new LabelValuePair(LabelName.RELABELS, ""));
        }
        switch (scope) {
            case Service: {
                metricInfo.getLabels().add(new LabelValuePair(LabelName.SCOPE, Scope.Service.name()));
                metricInfo.getLabels().add(new LabelValuePair(LabelName.SERVICE, ""));
                break;
            }
            case ServiceInstance: {
                metricInfo.getLabels().add(new LabelValuePair(LabelName.SCOPE, Scope.ServiceInstance.name()));
                metricInfo.getLabels().add(new LabelValuePair(LabelName.SERVICE, ""));
                metricInfo.getLabels().add(new LabelValuePair(LabelName.SERVICE_INSTANCE, ""));
                metricInfo.getLabels().add(new LabelValuePair(LabelName.PARENT_SERVICE, ""));
                break;
            }
            case Endpoint: {
                metricInfo.getLabels().add(new LabelValuePair(LabelName.SCOPE, Scope.Endpoint.name()));
                metricInfo.getLabels().add(new LabelValuePair(LabelName.SERVICE, ""));
                metricInfo.getLabels().add(new LabelValuePair(LabelName.ENDPOINT, ""));
                metricInfo.getLabels().add(new LabelValuePair(LabelName.PARENT_SERVICE, ""));
            }
        }
        return metricInfo;
    }

    private MetricInfo buildMetricInfoFromTraffic(String metricName, Service service) {
        MetricInfo metricInfo = new MetricInfo(metricName);
        metricInfo.getLabels().add(new LabelValuePair(LabelName.SERVICE, service.getName()));
        metricInfo.getLabels().add(new LabelValuePair(LabelName.SCOPE, Scope.Service.name()));
        metricInfo.getLabels().add(new LabelValuePair(LabelName.LAYER, (String)service.getLayers().iterator().next()));
        return metricInfo;
    }

    private MetricInfo buildMetricInfoFromTraffic(String metricName, ServiceInstance instance) {
        MetricInfo metricInfo = new MetricInfo(metricName);
        metricInfo.getLabels().add(new LabelValuePair(LabelName.SERVICE_INSTANCE, instance.getName()));
        metricInfo.getLabels().add(new LabelValuePair(LabelName.SCOPE, Scope.ServiceInstance.name()));
        return metricInfo;
    }

    private MetricInfo buildMetricInfoFromTraffic(String metricName, Endpoint endpoint) {
        MetricInfo metricInfo = new MetricInfo(metricName);
        metricInfo.getLabels().add(new LabelValuePair(LabelName.ENDPOINT, endpoint.getName()));
        metricInfo.getLabels().add(new LabelValuePair(LabelName.SCOPE, Scope.Endpoint.name()));
        return metricInfo;
    }

    public static enum QueryType {
        INSTANT,
        RANGE;

    }
}

