/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.promql;

import com.linecorp.armeria.common.HttpMethod;
import java.util.Arrays;
import org.apache.skywalking.oap.query.promql.PromQLConfig;
import org.apache.skywalking.oap.query.promql.PromQLModule;
import org.apache.skywalking.oap.query.promql.handler.PromQLApiHandler;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.library.server.http.HTTPServer;
import org.apache.skywalking.oap.server.library.server.http.HTTPServerConfig;

public class PromQLProvider
extends ModuleProvider {
    public static final String NAME = "default";
    private PromQLConfig config;
    private HTTPServer httpServer;

    public String name() {
        return NAME;
    }

    public Class<? extends ModuleDefine> module() {
        return PromQLModule.class;
    }

    public ModuleProvider.ConfigCreator newConfigCreator() {
        return new ModuleProvider.ConfigCreator<PromQLConfig>(){

            public Class type() {
                return PromQLConfig.class;
            }

            public void onInitialized(PromQLConfig initialized) {
                PromQLProvider.this.config = initialized;
            }
        };
    }

    public void prepare() throws ServiceNotProvidedException {
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        HTTPServerConfig httpServerConfig = HTTPServerConfig.builder().host(this.config.getRestHost()).port(this.config.getRestPort()).contextPath(this.config.getRestContextPath()).idleTimeOut(this.config.getRestIdleTimeOut()).maxThreads(this.config.getRestMaxThreads()).acceptQueueSize(this.config.getRestAcceptQueueSize()).build();
        this.httpServer = new HTTPServer(httpServerConfig);
        this.httpServer.initialize();
        this.httpServer.addHandler((Object)new PromQLApiHandler(this.getManager()), Arrays.asList(HttpMethod.POST, HttpMethod.GET));
    }

    public void notifyAfterCompleted() {
        this.httpServer.start();
    }

    public String[] requiredModules() {
        return new String[]{"telemetry", "core"};
    }
}

