/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oal.rt.parser;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Objects;
import org.apache.skywalking.oal.rt.parser.AnalysisResult;
import org.apache.skywalking.oal.rt.parser.ConditionExpression;
import org.apache.skywalking.oal.rt.parser.EntryMethod;
import org.apache.skywalking.oal.rt.parser.Expression;
import org.apache.skywalking.oal.rt.parser.FilterMatchers;
import org.apache.skywalking.oal.rt.parser.MetricsHolder;
import org.apache.skywalking.oal.rt.parser.SourceColumn;
import org.apache.skywalking.oal.rt.parser.SourceColumnsFactory;
import org.apache.skywalking.oal.rt.util.ClassMethodUtil;
import org.apache.skywalking.oal.rt.util.TypeCastUtil;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Arg;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.ConstOne;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Entrance;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.SourceFrom;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;

public class DeepAnalysis {
    public AnalysisResult analysis(AnalysisResult result) {
        Class<? extends Metrics> metricsClass = MetricsHolder.find(result.getAggregationFuncStmt().getAggregationFunctionName());
        String metricsClassSimpleName = metricsClass.getSimpleName();
        result.setMetricsClassName(metricsClassSimpleName);
        List<ConditionExpression> expressions = result.getFilters().getFilterExpressionsParserResult();
        if (expressions != null && expressions.size() > 0) {
            for (ConditionExpression expression : expressions) {
                FilterMatchers.MatcherInfo matcherInfo = FilterMatchers.INSTANCE.find(expression.getExpressionType());
                String getter = matcherInfo.isBooleanType() ? ClassMethodUtil.toIsMethod(expression.getAttributes()) : ClassMethodUtil.toGetMethod(expression.getAttributes());
                Expression filterExpression = new Expression();
                filterExpression.setExpressionObject(matcherInfo.getMatcher().getName());
                filterExpression.setLeft(TypeCastUtil.withCast(expression.getCastType(), "source." + getter));
                filterExpression.setRight(expression.getValue());
                result.getFilters().addFilterExpressions(filterExpression);
            }
        }
        Class<? extends Metrics> c = metricsClass;
        Object entranceMethod = null;
        block1: while (!c.equals(Object.class)) {
            for (Method method : c.getMethods()) {
                Entrance entrance = method.getAnnotation(Entrance.class);
                if (entrance == null) continue;
                entranceMethod = method;
                break block1;
            }
            c = c.getSuperclass();
        }
        if (entranceMethod == null) {
            throw new IllegalArgumentException("Can't find Entrance method in class: " + metricsClass.getName());
        }
        EntryMethod entryMethod = new EntryMethod();
        result.setEntryMethod(entryMethod);
        entryMethod.setMethodName(((Method)entranceMethod).getName());
        for (Parameter parameter : ((Executable)entranceMethod).getParameters()) {
            Class<?> parameterType = parameter.getType();
            Annotation[] parameterAnnotations = parameter.getAnnotations();
            if (parameterAnnotations == null || parameterAnnotations.length == 0) {
                throw new IllegalArgumentException("Entrance method:" + entranceMethod + " doesn't include the annotation.");
            }
            Annotation annotation = parameterAnnotations[0];
            if (annotation instanceof SourceFrom) {
                entryMethod.addArg(parameterType, TypeCastUtil.withCast(result.getFrom().getSourceCastType(), "source." + ClassMethodUtil.toGetMethod(result.getFrom().getSourceAttribute())));
                continue;
            }
            if (annotation instanceof ConstOne) {
                entryMethod.addArg(parameterType, "1");
                continue;
            }
            if (annotation instanceof org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Expression) {
                if (Objects.isNull(result.getAggregationFuncStmt().getFuncConditionExpressions()) || result.getAggregationFuncStmt().getFuncConditionExpressions().isEmpty()) {
                    throw new IllegalArgumentException("Entrance method:" + entranceMethod + " argument can't find funcParamExpression.");
                }
                ConditionExpression expression = result.getAggregationFuncStmt().getNextFuncConditionExpression();
                FilterMatchers.MatcherInfo matcherInfo = FilterMatchers.INSTANCE.find(expression.getExpressionType());
                String getter = matcherInfo.isBooleanType() ? ClassMethodUtil.toIsMethod(expression.getAttributes()) : ClassMethodUtil.toGetMethod(expression.getAttributes());
                Expression argExpression = new Expression();
                argExpression.setRight(expression.getValue());
                argExpression.setExpressionObject(matcherInfo.getMatcher().getName());
                argExpression.setLeft(TypeCastUtil.withCast(expression.getCastType(), "source." + getter));
                entryMethod.addArg(argExpression);
                continue;
            }
            if (annotation instanceof Arg) {
                entryMethod.addArg(parameterType, result.getAggregationFuncStmt().getNextFuncArg());
                continue;
            }
            throw new IllegalArgumentException("Entrance method:" + entranceMethod + " doesn't the expected annotation.");
        }
        c = metricsClass;
        while (!c.equals(Object.class)) {
            for (AnnotatedElement annotatedElement : c.getDeclaredFields()) {
                Column column = ((Field)annotatedElement).getAnnotation(Column.class);
                if (column == null) continue;
                result.addPersistentField(((Field)annotatedElement).getName(), column.columnName(), ((Field)annotatedElement).getType());
            }
            c = c.getSuperclass();
        }
        List<SourceColumn> columns = SourceColumnsFactory.getColumns(result.getFrom().getSourceName());
        result.setFieldsFromSource(columns);
        result.generateSerializeFields();
        return result;
    }
}

