/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oal.rt.parser;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oal.rt.parser.Argument;
import org.apache.skywalking.oal.rt.parser.ConditionExpression;
import org.apache.skywalking.oal.rt.parser.DataColumn;
import org.apache.skywalking.oal.rt.parser.EntryMethod;
import org.apache.skywalking.oal.rt.parser.Expression;
import org.apache.skywalking.oal.rt.parser.PersistenceColumns;
import org.apache.skywalking.oal.rt.parser.SourceColumn;
import org.apache.skywalking.oap.server.core.storage.type.StorageDataComplexObject;

public class AnalysisResult {
    private String varName;
    private String metricsName;
    private String metricsClassPackage;
    private String tableName;
    private String packageName;
    private String sourcePackage;
    private String sourceName;
    private int sourceScopeId;
    private List<String> sourceAttribute = new ArrayList<String>();
    private String aggregationFunctionName;
    private String metricsClassName;
    private EntryMethod entryMethod;
    private List<Expression> filterExpressions;
    private List<ConditionExpression> filterExpressionsParserResult;
    private List<ConditionExpression> funcConditionExpressions;
    private int funcConditionExpressionGetIdx = 0;
    private List<Argument> funcArgs;
    private int argGetIdx = 0;
    private List<DataColumn> persistentFields;
    private List<SourceColumn> fieldsFromSource;
    private PersistenceColumns serializeFields;

    public void addPersistentField(String fieldName, String columnName, Class<?> type) {
        if (this.persistentFields == null) {
            this.persistentFields = new LinkedList<DataColumn>();
        }
        DataColumn dataColumn = new DataColumn(fieldName, columnName, type);
        this.persistentFields.add(dataColumn);
    }

    public void addFuncConditionExpression(ConditionExpression conditionExpression) {
        if (this.funcConditionExpressions == null) {
            this.funcConditionExpressions = new LinkedList<ConditionExpression>();
        }
        this.funcConditionExpressions.add(conditionExpression);
    }

    public ConditionExpression getNextFuncConditionExpression() {
        return this.funcConditionExpressions.get(this.funcConditionExpressionGetIdx++);
    }

    public void addFilterExpressions(Expression filterExpression) {
        if (this.filterExpressions == null) {
            this.filterExpressions = new LinkedList<Expression>();
        }
        this.filterExpressions.add(filterExpression);
    }

    public void addFilterExpressionsParserResult(ConditionExpression conditionExpression) {
        if (this.filterExpressionsParserResult == null) {
            this.filterExpressionsParserResult = new LinkedList<ConditionExpression>();
        }
        this.filterExpressionsParserResult.add(conditionExpression);
    }

    public void addFuncArg(Argument argument) {
        if (this.funcArgs == null) {
            this.funcArgs = new LinkedList<Argument>();
        }
        this.funcArgs.add(argument);
    }

    public Argument getNextFuncArg() {
        return this.funcArgs.get(this.argGetIdx++);
    }

    public void generateSerializeFields() {
        this.serializeFields = new PersistenceColumns();
        block12: for (SourceColumn sourceColumn : this.fieldsFromSource) {
            String type;
            switch (type = sourceColumn.getType().getSimpleName()) {
                case "int": {
                    this.serializeFields.addIntField(sourceColumn.getFieldName());
                    continue block12;
                }
                case "double": {
                    this.serializeFields.addDoubleField(sourceColumn.getFieldName());
                    continue block12;
                }
                case "String": {
                    this.serializeFields.addStringField(sourceColumn.getFieldName());
                    continue block12;
                }
                case "long": {
                    this.serializeFields.addLongField(sourceColumn.getFieldName());
                    continue block12;
                }
            }
            throw new IllegalStateException("Unexpected field type [" + type + "] of source sourceColumn [" + sourceColumn.getFieldName() + "]");
        }
        for (DataColumn column : this.persistentFields) {
            Class<?> columnType = column.getType();
            if (columnType.equals(Integer.TYPE)) {
                this.serializeFields.addIntField(column.getFieldName());
                continue;
            }
            if (columnType.equals(Double.TYPE)) {
                this.serializeFields.addDoubleField(column.getFieldName());
                continue;
            }
            if (columnType.equals(String.class)) {
                this.serializeFields.addStringField(column.getFieldName());
                continue;
            }
            if (columnType.equals(Long.TYPE)) {
                this.serializeFields.addLongField(column.getFieldName());
                continue;
            }
            if (StorageDataComplexObject.class.isAssignableFrom(columnType)) {
                this.serializeFields.addObjectField(column.getFieldName(), columnType.getName());
                continue;
            }
            throw new IllegalStateException("Unexpected field type [" + columnType.getSimpleName() + "] of persistence column [" + column.getFieldName() + "]");
        }
    }

    @Generated
    public String getVarName() {
        return this.varName;
    }

    @Generated
    public String getMetricsName() {
        return this.metricsName;
    }

    @Generated
    public String getMetricsClassPackage() {
        return this.metricsClassPackage;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public String getPackageName() {
        return this.packageName;
    }

    @Generated
    public String getSourcePackage() {
        return this.sourcePackage;
    }

    @Generated
    public String getSourceName() {
        return this.sourceName;
    }

    @Generated
    public int getSourceScopeId() {
        return this.sourceScopeId;
    }

    @Generated
    public List<String> getSourceAttribute() {
        return this.sourceAttribute;
    }

    @Generated
    public String getAggregationFunctionName() {
        return this.aggregationFunctionName;
    }

    @Generated
    public String getMetricsClassName() {
        return this.metricsClassName;
    }

    @Generated
    public EntryMethod getEntryMethod() {
        return this.entryMethod;
    }

    @Generated
    public List<Expression> getFilterExpressions() {
        return this.filterExpressions;
    }

    @Generated
    public List<ConditionExpression> getFilterExpressionsParserResult() {
        return this.filterExpressionsParserResult;
    }

    @Generated
    public List<ConditionExpression> getFuncConditionExpressions() {
        return this.funcConditionExpressions;
    }

    @Generated
    public int getFuncConditionExpressionGetIdx() {
        return this.funcConditionExpressionGetIdx;
    }

    @Generated
    public List<Argument> getFuncArgs() {
        return this.funcArgs;
    }

    @Generated
    public int getArgGetIdx() {
        return this.argGetIdx;
    }

    @Generated
    public List<DataColumn> getPersistentFields() {
        return this.persistentFields;
    }

    @Generated
    public List<SourceColumn> getFieldsFromSource() {
        return this.fieldsFromSource;
    }

    @Generated
    public PersistenceColumns getSerializeFields() {
        return this.serializeFields;
    }

    @Generated
    public void setVarName(String varName) {
        this.varName = varName;
    }

    @Generated
    public void setMetricsName(String metricsName) {
        this.metricsName = metricsName;
    }

    @Generated
    public void setMetricsClassPackage(String metricsClassPackage) {
        this.metricsClassPackage = metricsClassPackage;
    }

    @Generated
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Generated
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Generated
    public void setSourcePackage(String sourcePackage) {
        this.sourcePackage = sourcePackage;
    }

    @Generated
    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    @Generated
    public void setSourceScopeId(int sourceScopeId) {
        this.sourceScopeId = sourceScopeId;
    }

    @Generated
    public void setSourceAttribute(List<String> sourceAttribute) {
        this.sourceAttribute = sourceAttribute;
    }

    @Generated
    public void setAggregationFunctionName(String aggregationFunctionName) {
        this.aggregationFunctionName = aggregationFunctionName;
    }

    @Generated
    public void setMetricsClassName(String metricsClassName) {
        this.metricsClassName = metricsClassName;
    }

    @Generated
    public void setEntryMethod(EntryMethod entryMethod) {
        this.entryMethod = entryMethod;
    }

    @Generated
    public void setFilterExpressions(List<Expression> filterExpressions) {
        this.filterExpressions = filterExpressions;
    }

    @Generated
    public void setFilterExpressionsParserResult(List<ConditionExpression> filterExpressionsParserResult) {
        this.filterExpressionsParserResult = filterExpressionsParserResult;
    }

    @Generated
    public void setFuncConditionExpressions(List<ConditionExpression> funcConditionExpressions) {
        this.funcConditionExpressions = funcConditionExpressions;
    }

    @Generated
    public void setFuncConditionExpressionGetIdx(int funcConditionExpressionGetIdx) {
        this.funcConditionExpressionGetIdx = funcConditionExpressionGetIdx;
    }

    @Generated
    public void setFuncArgs(List<Argument> funcArgs) {
        this.funcArgs = funcArgs;
    }

    @Generated
    public void setArgGetIdx(int argGetIdx) {
        this.argGetIdx = argGetIdx;
    }

    @Generated
    public void setPersistentFields(List<DataColumn> persistentFields) {
        this.persistentFields = persistentFields;
    }

    @Generated
    public void setFieldsFromSource(List<SourceColumn> fieldsFromSource) {
        this.fieldsFromSource = fieldsFromSource;
    }

    @Generated
    public void setSerializeFields(PersistenceColumns serializeFields) {
        this.serializeFields = serializeFields;
    }
}

