/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oal.rt.parser;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.MetricsFunction;

public class MetricsHolder {
    private static Map<String, Class<? extends Metrics>> REGISTER = new HashMap<String, Class<? extends Metrics>>();

    public static void init() throws IOException {
        ClassPath classpath = ClassPath.from((ClassLoader)MetricsHolder.class.getClassLoader());
        ImmutableSet classes = classpath.getTopLevelClassesRecursive("org.apache.skywalking");
        for (ClassPath.ClassInfo classInfo : classes) {
            Class aClass = classInfo.load();
            if (!aClass.isAnnotationPresent(MetricsFunction.class)) continue;
            MetricsFunction metricsFunction = aClass.getAnnotation(MetricsFunction.class);
            REGISTER.put(metricsFunction.functionName(), aClass);
        }
    }

    public static Class<? extends Metrics> find(String functionName) {
        String func = functionName;
        Class<? extends Metrics> metricsClass = REGISTER.get(func);
        if (metricsClass == null) {
            throw new IllegalArgumentException("Can't find metrics, " + func);
        }
        return metricsClass;
    }
}

