/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oal.rt.parser;

import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.oal.rt.util.ClassMethodUtil;

public class SourceColumn {
    private String fieldName;
    private String columnName;
    private Class<?> type;
    private String typeName;
    private boolean isID;
    private int length;
    private String fieldSetter;
    private String fieldGetter;
    private final boolean groupByCondInTopN;

    public SourceColumn(String fieldName, String columnName, Class<?> type, boolean isID, int length, boolean groupByCondInTopN) {
        this.fieldName = fieldName;
        this.columnName = columnName;
        this.type = type;
        this.typeName = type.getName();
        this.isID = isID;
        this.length = length;
        this.fieldGetter = ClassMethodUtil.toGetMethod(fieldName);
        this.fieldSetter = ClassMethodUtil.toSetMethod(fieldName);
        this.groupByCondInTopN = groupByCondInTopN;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
        this.fieldGetter = ClassMethodUtil.toGetMethod(fieldName);
        this.fieldSetter = ClassMethodUtil.toSetMethod(fieldName);
    }

    public void setTypeName(String typeName) {
        switch (typeName) {
            case "int": {
                this.type = Integer.TYPE;
                break;
            }
            case "long": {
                this.type = Long.TYPE;
                break;
            }
            case "string": 
            case "String": {
                this.type = String.class;
                typeName = "String";
                break;
            }
            default: {
                try {
                    this.type = Class.forName(typeName);
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.typeName = typeName;
    }

    public String toString() {
        return "SourceColumn{fieldName='" + this.fieldName + "', columnName='" + this.columnName + "', type=" + this.type + ", isID=" + this.isID + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceColumn column = (SourceColumn)o;
        return this.isID == column.isID && Objects.equals(this.fieldName, column.fieldName) && Objects.equals(this.columnName, column.columnName) && Objects.equals(this.type, column.type) && Objects.equals(this.typeName, column.typeName) && Objects.equals(this.fieldSetter, column.fieldSetter) && Objects.equals(this.fieldGetter, column.fieldGetter);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.columnName, this.type, this.typeName, this.isID, this.fieldSetter, this.fieldGetter);
    }

    @Generated
    public String getFieldName() {
        return this.fieldName;
    }

    @Generated
    public String getColumnName() {
        return this.columnName;
    }

    @Generated
    public Class<?> getType() {
        return this.type;
    }

    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public boolean isID() {
        return this.isID;
    }

    @Generated
    public int getLength() {
        return this.length;
    }

    @Generated
    public String getFieldSetter() {
        return this.fieldSetter;
    }

    @Generated
    public String getFieldGetter() {
        return this.fieldGetter;
    }

    @Generated
    public boolean isGroupByCondInTopN() {
        return this.groupByCondInTopN;
    }

    @Generated
    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    @Generated
    public void setType(Class<?> type) {
        this.type = type;
    }

    @Generated
    public void setID(boolean isID) {
        this.isID = isID;
    }

    @Generated
    public void setLength(int length) {
        this.length = length;
    }

    @Generated
    public void setFieldSetter(String fieldSetter) {
        this.fieldSetter = fieldSetter;
    }

    @Generated
    public void setFieldGetter(String fieldGetter) {
        this.fieldGetter = fieldGetter;
    }
}

