/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oal.rt.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.antlr.v4.runtime.misc.NotNull;
import org.apache.skywalking.oal.rt.grammar.OALParser;
import org.apache.skywalking.oal.rt.grammar.OALParserBaseListener;
import org.apache.skywalking.oal.rt.parser.AnalysisResult;
import org.apache.skywalking.oal.rt.parser.Argument;
import org.apache.skywalking.oal.rt.parser.ConditionExpression;
import org.apache.skywalking.oal.rt.parser.DeepAnalysis;
import org.apache.skywalking.oal.rt.parser.DisableCollection;
import org.apache.skywalking.oal.rt.parser.OALScripts;
import org.apache.skywalking.oap.server.core.source.DefaultScopeDefine;

public class OALListener
extends OALParserBaseListener {
    private List<AnalysisResult> results;
    private AnalysisResult current;
    private DisableCollection collection;
    private ConditionExpression conditionExpression;
    private final String sourcePackage;

    public OALListener(OALScripts scripts, String sourcePackage) {
        this.results = scripts.getMetricsStmts();
        this.collection = scripts.getDisableCollection();
        this.sourcePackage = sourcePackage;
    }

    public void enterAggregationStatement(@NotNull OALParser.AggregationStatementContext ctx) {
        this.current = new AnalysisResult();
    }

    public void exitAggregationStatement(@NotNull OALParser.AggregationStatementContext ctx) {
        DeepAnalysis deepAnalysis = new DeepAnalysis();
        this.results.add(deepAnalysis.analysis(this.current));
        this.current = null;
    }

    public void enterSource(OALParser.SourceContext ctx) {
        this.current.getFrom().setSourceName(ctx.getText());
        this.current.getFrom().setSourceScopeId(DefaultScopeDefine.valueOf((String)this.metricsNameFormat(ctx.getText())));
    }

    public void enterSourceAttribute(OALParser.SourceAttributeContext ctx) {
        this.current.getFrom().getSourceAttribute().add(ctx.getText());
    }

    public void enterSourceAttrCast(OALParser.SourceAttrCastContext ctx) {
        this.current.getFrom().setSourceCastType(ctx.getText());
    }

    public void enterVariable(OALParser.VariableContext ctx) {
    }

    public void exitVariable(OALParser.VariableContext ctx) {
        this.current.setVarName(ctx.getText());
        this.current.setMetricsName(this.metricsNameFormat(ctx.getText()));
        this.current.setTableName(ctx.getText().toLowerCase());
    }

    public void enterFunctionName(OALParser.FunctionNameContext ctx) {
        this.current.getAggregationFuncStmt().setAggregationFunctionName(ctx.getText());
    }

    public void enterFilterStatement(OALParser.FilterStatementContext ctx) {
        this.conditionExpression = new ConditionExpression();
    }

    public void exitFilterStatement(OALParser.FilterStatementContext ctx) {
        this.current.getFilters().addFilterExpressionsParserResult(this.conditionExpression);
        this.conditionExpression = null;
    }

    public void enterFuncParamExpression(OALParser.FuncParamExpressionContext ctx) {
        this.conditionExpression = new ConditionExpression();
    }

    public void exitFuncParamExpression(OALParser.FuncParamExpressionContext ctx) {
        this.current.getAggregationFuncStmt().addFuncConditionExpression(this.conditionExpression);
        this.conditionExpression = null;
    }

    public void enterConditionAttribute(OALParser.ConditionAttributeContext ctx) {
        this.conditionExpression.getAttributes().add(ctx.getText());
    }

    public void enterBooleanMatch(OALParser.BooleanMatchContext ctx) {
        this.conditionExpression.setExpressionType("booleanMatch");
    }

    public void enterNumberMatch(OALParser.NumberMatchContext ctx) {
        this.conditionExpression.setExpressionType("numberMatch");
    }

    public void enterStringMatch(OALParser.StringMatchContext ctx) {
        this.conditionExpression.setExpressionType("stringMatch");
    }

    public void enterGreaterMatch(OALParser.GreaterMatchContext ctx) {
        this.conditionExpression.setExpressionType("greaterMatch");
    }

    public void enterGreaterEqualMatch(OALParser.GreaterEqualMatchContext ctx) {
        this.conditionExpression.setExpressionType("greaterEqualMatch");
    }

    public void enterLessMatch(OALParser.LessMatchContext ctx) {
        this.conditionExpression.setExpressionType("lessMatch");
    }

    public void enterLessEqualMatch(OALParser.LessEqualMatchContext ctx) {
        this.conditionExpression.setExpressionType("lessEqualMatch");
    }

    public void enterNotEqualMatch(OALParser.NotEqualMatchContext ctx) {
        this.conditionExpression.setExpressionType("notEqualMatch");
    }

    public void enterBooleanNotEqualMatch(OALParser.BooleanNotEqualMatchContext ctx) {
        this.conditionExpression.setExpressionType("booleanNotEqualMatch");
    }

    public void enterLikeMatch(OALParser.LikeMatchContext ctx) {
        this.conditionExpression.setExpressionType("likeMatch");
    }

    public void enterContainMatch(OALParser.ContainMatchContext ctx) {
        this.conditionExpression.setExpressionType("containMatch");
    }

    public void enterNotContainMatch(OALParser.NotContainMatchContext ctx) {
        this.conditionExpression.setExpressionType("notContainMatch");
    }

    public void enterInMatch(OALParser.InMatchContext ctx) {
        this.conditionExpression.setExpressionType("inMatch");
    }

    public void enterMultiConditionValue(OALParser.MultiConditionValueContext ctx) {
        this.conditionExpression.enterMultiConditionValue();
    }

    public void exitMultiConditionValue(OALParser.MultiConditionValueContext ctx) {
        this.conditionExpression.exitMultiConditionValue();
    }

    public void enterBooleanConditionValue(OALParser.BooleanConditionValueContext ctx) {
        this.enterConditionValue(ctx.getText());
    }

    public void enterStringConditionValue(OALParser.StringConditionValueContext ctx) {
        this.enterConditionValue(ctx.getText());
    }

    public void enterEnumConditionValue(OALParser.EnumConditionValueContext ctx) {
        this.enterEnumConditionValue(ctx.getText());
    }

    public void enterNumberConditionValue(OALParser.NumberConditionValueContext ctx) {
        this.conditionExpression.isNumber();
        this.enterConditionValue(ctx.getText());
    }

    public void enterNullConditionValue(OALParser.NullConditionValueContext ctx) {
        this.enterConditionValue(ctx.getText());
    }

    public void enterExpressionAttrCast(OALParser.ExpressionAttrCastContext ctx) {
        this.conditionExpression.setCastType(ctx.getText());
    }

    private void enterConditionValue(String value) {
        this.conditionExpression.addValue(value);
    }

    private void enterEnumConditionValue(String value) {
        this.conditionExpression.addValue(this.sourcePackage + value);
    }

    public void enterLiteralExpression(OALParser.LiteralExpressionContext ctx) {
        this.current.getAggregationFuncStmt().addFuncArg(new Argument(1, Arrays.asList(ctx.getText())));
    }

    public void enterAttributeExpression(OALParser.AttributeExpressionContext ctx) {
        this.current.getAggregationFuncStmt().addFuncArg(new Argument(2, new ArrayList<String>(3)));
    }

    public void enterAttributeExpressionSegment(OALParser.AttributeExpressionSegmentContext ctx) {
        this.current.getAggregationFuncStmt().getLastArgument().addText(ctx.getText());
    }

    public void enterFunctionArgCast(OALParser.FunctionArgCastContext ctx) {
        this.current.getAggregationFuncStmt().getLastArgument().setCastType(ctx.getText());
    }

    private String metricsNameFormat(String source) {
        int idx;
        source = this.firstLetterUpper((String)source);
        while ((idx = ((String)source).indexOf("_")) > -1) {
            source = ((String)source).substring(0, idx) + this.firstLetterUpper(((String)source).substring(idx + 1));
        }
        return source;
    }

    public void enterDisableSource(OALParser.DisableSourceContext ctx) {
        this.collection.add(ctx.getText());
    }

    private String firstLetterUpper(String source) {
        return source.substring(0, 1).toUpperCase() + source.substring(1);
    }
}

