/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.collector.analysis.jvm.provider.service;

import java.util.Objects;
import org.apache.skywalking.apm.collector.analysis.jvm.define.service.IMemoryPoolMetricService;
import org.apache.skywalking.apm.collector.core.graph.Graph;
import org.apache.skywalking.apm.collector.core.graph.GraphManager;
import org.apache.skywalking.apm.collector.storage.table.jvm.MemoryPoolMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryPoolMetricService
implements IMemoryPoolMetricService {
    private final Logger logger = LoggerFactory.getLogger(MemoryPoolMetricService.class);
    private Graph<MemoryPoolMetric> memoryPoolMetricGraph;

    private Graph<MemoryPoolMetric> getMemoryPoolMetricGraph() {
        if (Objects.isNull(this.memoryPoolMetricGraph)) {
            this.memoryPoolMetricGraph = GraphManager.INSTANCE.findGraph(304, MemoryPoolMetric.class);
        }
        return this.memoryPoolMetricGraph;
    }

    public void send(int instanceId, long timeBucket, int poolType, long init, long max, long used, long committed) {
        String metricId = instanceId + "_" + String.valueOf(poolType);
        String id = timeBucket + "_" + metricId;
        MemoryPoolMetric memoryPoolMetric = new MemoryPoolMetric();
        memoryPoolMetric.setId(id);
        memoryPoolMetric.setMetricId(metricId);
        memoryPoolMetric.setInstanceId(Integer.valueOf(instanceId));
        memoryPoolMetric.setPoolType(Integer.valueOf(poolType));
        memoryPoolMetric.setInit(Long.valueOf(init));
        memoryPoolMetric.setMax(Long.valueOf(max));
        memoryPoolMetric.setUsed(Long.valueOf(used));
        memoryPoolMetric.setCommitted(Long.valueOf(committed));
        memoryPoolMetric.setTimes(Long.valueOf(1L));
        memoryPoolMetric.setTimeBucket(Long.valueOf(timeBucket));
        this.logger.debug("push to memory pool metric graph, id: {}", (Object)memoryPoolMetric.getId());
        this.getMemoryPoolMetricGraph().start((Object)memoryPoolMetric);
    }
}

