/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.collector.analysis.jvm.provider.service;

import java.util.Objects;
import org.apache.skywalking.apm.collector.analysis.jvm.define.service.IMemoryMetricService;
import org.apache.skywalking.apm.collector.core.graph.Graph;
import org.apache.skywalking.apm.collector.core.graph.GraphManager;
import org.apache.skywalking.apm.collector.core.util.BooleanUtils;
import org.apache.skywalking.apm.collector.storage.table.jvm.MemoryMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryMetricService
implements IMemoryMetricService {
    private final Logger logger = LoggerFactory.getLogger(MemoryMetricService.class);
    private Graph<MemoryMetric> memoryMetricGraph;

    private Graph<MemoryMetric> getMemoryMetricGraph() {
        if (Objects.isNull(this.memoryMetricGraph)) {
            this.memoryMetricGraph = GraphManager.INSTANCE.findGraph(303, MemoryMetric.class);
        }
        return this.memoryMetricGraph;
    }

    public void send(int instanceId, long timeBucket, boolean isHeap, long init, long max, long used, long committed) {
        String metricId = instanceId + "_" + BooleanUtils.booleanToValue((Boolean)isHeap);
        String id = timeBucket + "_" + metricId;
        MemoryMetric memoryMetric = new MemoryMetric();
        memoryMetric.setId(id);
        memoryMetric.setMetricId(metricId);
        memoryMetric.setInstanceId(Integer.valueOf(instanceId));
        memoryMetric.setIsHeap(Integer.valueOf(BooleanUtils.booleanToValue((Boolean)isHeap)));
        memoryMetric.setInit(Long.valueOf(init));
        memoryMetric.setMax(Long.valueOf(max));
        memoryMetric.setUsed(Long.valueOf(used));
        memoryMetric.setCommitted(Long.valueOf(committed));
        memoryMetric.setTimes(Long.valueOf(1L));
        memoryMetric.setTimeBucket(Long.valueOf(timeBucket));
        this.logger.debug("push to memory metric graph, id: {}", (Object)memoryMetric.getId());
        this.getMemoryMetricGraph().start((Object)memoryMetric);
    }
}

