/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.collector.analysis.jvm.provider.service;

import java.util.Objects;
import org.apache.skywalking.apm.collector.analysis.jvm.define.service.IGCMetricService;
import org.apache.skywalking.apm.collector.core.graph.Graph;
import org.apache.skywalking.apm.collector.core.graph.GraphManager;
import org.apache.skywalking.apm.collector.storage.table.jvm.GCMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCMetricService
implements IGCMetricService {
    private final Logger logger = LoggerFactory.getLogger(GCMetricService.class);
    private Graph<GCMetric> gcMetricGraph;

    private Graph<GCMetric> getGcMetricGraph() {
        if (Objects.isNull(this.gcMetricGraph)) {
            this.gcMetricGraph = GraphManager.INSTANCE.findGraph(301, GCMetric.class);
        }
        return this.gcMetricGraph;
    }

    public void send(int instanceId, long timeBucket, int phraseValue, long count, long duration) {
        String metricId = instanceId + "_" + String.valueOf(phraseValue);
        String id = timeBucket + "_" + metricId;
        GCMetric gcMetric = new GCMetric();
        gcMetric.setId(id);
        gcMetric.setMetricId(metricId);
        gcMetric.setInstanceId(Integer.valueOf(instanceId));
        gcMetric.setPhrase(Integer.valueOf(phraseValue));
        gcMetric.setCount(Long.valueOf(count));
        gcMetric.setDuration(Long.valueOf(duration));
        gcMetric.setTimes(Long.valueOf(1L));
        gcMetric.setTimeBucket(Long.valueOf(timeBucket));
        this.logger.debug("push to gc metric graph, id: {}", (Object)gcMetric.getId());
        this.getGcMetricGraph().start((Object)gcMetric);
    }
}

