/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.collector.analysis.jvm.provider.service;

import java.util.Objects;
import org.apache.skywalking.apm.collector.analysis.jvm.define.service.ICpuMetricService;
import org.apache.skywalking.apm.collector.core.graph.Graph;
import org.apache.skywalking.apm.collector.core.graph.GraphManager;
import org.apache.skywalking.apm.collector.storage.table.jvm.CpuMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpuMetricService
implements ICpuMetricService {
    private final Logger logger = LoggerFactory.getLogger(CpuMetricService.class);
    private Graph<CpuMetric> cpuMetricGraph;

    private Graph<CpuMetric> getCpuMetricGraph() {
        if (Objects.isNull(this.cpuMetricGraph)) {
            this.cpuMetricGraph = GraphManager.INSTANCE.findGraph(300, CpuMetric.class);
        }
        return this.cpuMetricGraph;
    }

    public void send(int instanceId, long timeBucket, double usagePercent) {
        String metricId = String.valueOf(instanceId);
        String id = timeBucket + "_" + metricId;
        CpuMetric cpuMetric = new CpuMetric();
        cpuMetric.setId(id);
        cpuMetric.setMetricId(metricId);
        cpuMetric.setInstanceId(Integer.valueOf(instanceId));
        cpuMetric.setUsagePercent(Double.valueOf(usagePercent));
        cpuMetric.setTimes(Long.valueOf(1L));
        cpuMetric.setTimeBucket(Long.valueOf(timeBucket));
        this.logger.debug("push to cpu metric graph, id: {}", (Object)cpuMetric.getId());
        this.getCpuMetricGraph().start((Object)cpuMetric);
    }
}

