/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.collector.analysis.jvm.provider;

import org.apache.skywalking.apm.collector.analysis.jvm.define.AnalysisJVMModule;
import org.apache.skywalking.apm.collector.analysis.jvm.define.service.ICpuMetricService;
import org.apache.skywalking.apm.collector.analysis.jvm.define.service.IGCMetricService;
import org.apache.skywalking.apm.collector.analysis.jvm.define.service.IMemoryMetricService;
import org.apache.skywalking.apm.collector.analysis.jvm.define.service.IMemoryPoolMetricService;
import org.apache.skywalking.apm.collector.analysis.jvm.provider.AnalysisJVMModuleConfig;
import org.apache.skywalking.apm.collector.analysis.jvm.provider.service.CpuMetricService;
import org.apache.skywalking.apm.collector.analysis.jvm.provider.service.GCMetricService;
import org.apache.skywalking.apm.collector.analysis.jvm.provider.service.MemoryMetricService;
import org.apache.skywalking.apm.collector.analysis.jvm.provider.service.MemoryPoolMetricService;
import org.apache.skywalking.apm.collector.analysis.jvm.provider.worker.cpu.CpuMetricPersistenceGraph;
import org.apache.skywalking.apm.collector.analysis.jvm.provider.worker.gc.GCMetricPersistenceGraph;
import org.apache.skywalking.apm.collector.analysis.jvm.provider.worker.memory.MemoryMetricPersistenceGraph;
import org.apache.skywalking.apm.collector.analysis.jvm.provider.worker.memorypool.MemoryPoolMetricPersistenceGraph;
import org.apache.skywalking.apm.collector.analysis.worker.model.base.WorkerCreateListener;
import org.apache.skywalking.apm.collector.analysis.worker.timer.PersistenceTimer;
import org.apache.skywalking.apm.collector.core.module.ModuleConfig;
import org.apache.skywalking.apm.collector.core.module.ModuleDefine;
import org.apache.skywalking.apm.collector.core.module.ModuleProvider;
import org.apache.skywalking.apm.collector.core.module.Service;
import org.apache.skywalking.apm.collector.core.module.ServiceNotProvidedException;

public class AnalysisJVMModuleProvider
extends ModuleProvider {
    public static final String NAME = "default";
    private final AnalysisJVMModuleConfig config = new AnalysisJVMModuleConfig();

    public String name() {
        return NAME;
    }

    public Class<? extends ModuleDefine> module() {
        return AnalysisJVMModule.class;
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        return this.config;
    }

    public void prepare() throws ServiceNotProvidedException {
        this.registerServiceImplementation(ICpuMetricService.class, (Service)new CpuMetricService());
        this.registerServiceImplementation(IGCMetricService.class, (Service)new GCMetricService());
        this.registerServiceImplementation(IMemoryMetricService.class, (Service)new MemoryMetricService());
        this.registerServiceImplementation(IMemoryPoolMetricService.class, (Service)new MemoryPoolMetricService());
    }

    public void start() {
        WorkerCreateListener workerCreateListener = new WorkerCreateListener();
        this.graphCreate(workerCreateListener);
        PersistenceTimer.INSTANCE.start(this.getManager(), workerCreateListener.getPersistenceWorkers());
    }

    public void notifyAfterCompleted() {
    }

    public String[] requiredModules() {
        return new String[]{"storage", "remote"};
    }

    private void graphCreate(WorkerCreateListener workerCreateListener) {
        CpuMetricPersistenceGraph cpuMetricPersistenceGraph = new CpuMetricPersistenceGraph(this.getManager(), workerCreateListener);
        cpuMetricPersistenceGraph.create();
        GCMetricPersistenceGraph gcMetricPersistenceGraph = new GCMetricPersistenceGraph(this.getManager(), workerCreateListener);
        gcMetricPersistenceGraph.create();
        MemoryMetricPersistenceGraph memoryMetricPersistenceGraph = new MemoryMetricPersistenceGraph(this.getManager(), workerCreateListener);
        memoryMetricPersistenceGraph.create();
        MemoryPoolMetricPersistenceGraph memoryPoolMetricPersistenceGraph = new MemoryPoolMetricPersistenceGraph(this.getManager(), workerCreateListener);
        memoryPoolMetricPersistenceGraph.create();
    }
}

