/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.configuration.grpc;

import io.grpc.Channel;
import io.grpc.netty.NettyChannelBuilder;
import java.util.Set;
import org.apache.skywalking.oap.server.configuration.api.ConfigTable;
import org.apache.skywalking.oap.server.configuration.api.ConfigWatcherRegister;
import org.apache.skywalking.oap.server.configuration.grpc.RemoteEndpointSettings;
import org.apache.skywalking.oap.server.configuration.service.ConfigurationRequest;
import org.apache.skywalking.oap.server.configuration.service.ConfigurationResponse;
import org.apache.skywalking.oap.server.configuration.service.ConfigurationServiceGrpc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GRPCConfigWatcherRegister
extends ConfigWatcherRegister {
    private static final Logger logger = LoggerFactory.getLogger(GRPCConfigWatcherRegister.class);
    private RemoteEndpointSettings settings;
    private ConfigurationServiceGrpc.ConfigurationServiceBlockingStub stub;

    public GRPCConfigWatcherRegister(RemoteEndpointSettings settings) {
        super((long)settings.getPeriod());
        this.settings = settings;
        this.stub = ConfigurationServiceGrpc.newBlockingStub((Channel)NettyChannelBuilder.forAddress((String)settings.getHost(), (int)settings.getPort()).usePlaintext().build());
    }

    public ConfigTable readConfig(Set<String> keys) {
        ConfigTable table = new ConfigTable();
        try {
            ConfigurationResponse response = this.stub.call(ConfigurationRequest.newBuilder().setClusterName(this.settings.getClusterName()).build());
            response.getConfigTableList().forEach(config -> {
                String name = config.getName();
                if (keys.contains(name)) {
                    table.add(new ConfigTable.ConfigItem(name, config.getValue()));
                }
            });
        }
        catch (Exception e) {
            logger.error("Remote config center [" + (Object)((Object)this.settings) + "] is not available.", (Throwable)e);
        }
        return table;
    }
}

