/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.configuration.consul;

import com.google.common.base.Strings;
import lombok.Generated;
import org.apache.skywalking.oap.server.configuration.api.AbstractConfigurationProvider;
import org.apache.skywalking.oap.server.configuration.api.ConfigWatcherRegister;
import org.apache.skywalking.oap.server.configuration.consul.ConsulConfigurationCenterSettings;
import org.apache.skywalking.oap.server.configuration.consul.ConsulConfigurationWatcherRegister;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulConfigurationProvider
extends AbstractConfigurationProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsulConfigurationProvider.class);
    private final ConsulConfigurationCenterSettings settings = new ConsulConfigurationCenterSettings();

    public String name() {
        return "consul";
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        return this.settings;
    }

    protected ConfigWatcherRegister initConfigReader() throws ModuleStartException {
        log.info("consul settings: {}", (Object)this.settings);
        if (Strings.isNullOrEmpty((String)this.settings.getHostAndPorts())) {
            throw new ModuleStartException("Consul hostAndPorts cannot be null or empty");
        }
        return new ConsulConfigurationWatcherRegister(this.settings);
    }
}

