/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.collector.remote.service;

import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.apm.collector.core.data.RemoteData;
import org.apache.skywalking.apm.collector.remote.service.RemoteDataIDGetter;
import org.apache.skywalking.apm.collector.remote.service.RemoteDataInstanceCreatorGetter;
import org.apache.skywalking.apm.collector.remote.service.RemoteDataInstanceCreatorNotFoundException;
import org.apache.skywalking.apm.collector.remote.service.RemoteDataMappingIdNotFoundException;
import org.apache.skywalking.apm.collector.remote.service.RemoteDataRegisterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonRemoteDataRegisterService
implements RemoteDataRegisterService,
RemoteDataIDGetter,
RemoteDataInstanceCreatorGetter {
    private final Logger logger = LoggerFactory.getLogger(CommonRemoteDataRegisterService.class);
    private Integer id = 1;
    private final Map<Class<? extends RemoteData>, Integer> dataClassMapping = new HashMap<Class<? extends RemoteData>, Integer>();
    private final Map<Integer, RemoteDataRegisterService.RemoteDataInstanceCreator> dataInstanceCreatorMapping = new HashMap<Integer, RemoteDataRegisterService.RemoteDataInstanceCreator>();

    @Override
    public void register(Class<? extends RemoteData> dataClass, RemoteDataRegisterService.RemoteDataInstanceCreator instanceCreator) {
        if (!this.dataClassMapping.containsKey(dataClass)) {
            this.dataClassMapping.put(dataClass, this.id);
            this.dataInstanceCreatorMapping.put(this.id, instanceCreator);
            CommonRemoteDataRegisterService commonRemoteDataRegisterService = this;
            Integer n = commonRemoteDataRegisterService.id;
            Integer n2 = commonRemoteDataRegisterService.id = Integer.valueOf(commonRemoteDataRegisterService.id + 1);
        } else {
            this.logger.warn("The data class {} was registered.", (Object)dataClass.getName());
        }
    }

    @Override
    public Integer getRemoteDataId(Class<? extends RemoteData> dataClass) throws RemoteDataMappingIdNotFoundException {
        if (this.dataClassMapping.containsKey(dataClass)) {
            return this.dataClassMapping.get(dataClass);
        }
        throw new RemoteDataMappingIdNotFoundException("Could not found the id of remote data class " + dataClass.getName());
    }

    @Override
    public RemoteDataRegisterService.RemoteDataInstanceCreator getInstanceCreator(Integer remoteDataId) throws RemoteDataInstanceCreatorNotFoundException {
        if (this.dataInstanceCreatorMapping.containsKey(remoteDataId)) {
            return this.dataInstanceCreatorMapping.get(remoteDataId);
        }
        throw new RemoteDataInstanceCreatorNotFoundException("Could not found the instance creator of remote data id " + remoteDataId);
    }
}

