/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.collector.cluster.zookeeper;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.skywalking.apm.collector.client.Client;
import org.apache.skywalking.apm.collector.client.ClientException;
import org.apache.skywalking.apm.collector.client.zookeeper.ZookeeperClient;
import org.apache.skywalking.apm.collector.client.zookeeper.ZookeeperClientException;
import org.apache.skywalking.apm.collector.cluster.ClusterModuleListener;
import org.apache.skywalking.apm.collector.cluster.ClusterNodeExistException;
import org.apache.skywalking.apm.collector.cluster.DataMonitor;
import org.apache.skywalking.apm.collector.cluster.ModuleRegistration;
import org.apache.skywalking.apm.collector.core.CollectorException;
import org.apache.skywalking.apm.collector.core.util.CollectionUtils;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterZKDataMonitor
implements DataMonitor,
Watcher {
    private final Logger logger = LoggerFactory.getLogger(ClusterZKDataMonitor.class);
    private ZookeeperClient client;
    private Map<String, ClusterModuleListener> listeners = new LinkedHashMap<String, ClusterModuleListener>();
    private Map<String, ModuleRegistration> registrations = new LinkedHashMap<String, ModuleRegistration>();
    private String namespace;

    public synchronized void process(WatchedEvent event) {
        this.logger.info("changed path {}, event type: {}", (Object)event.getPath(), (Object)event.getType().name());
        if (this.listeners.containsKey(event.getPath())) {
            try {
                List paths = this.client.getChildren(event.getPath(), true);
                ClusterModuleListener listener = this.listeners.get(event.getPath());
                HashSet<String> remoteNodes = new HashSet<String>();
                Set notifiedNodes = listener.getAddresses();
                if (CollectionUtils.isNotEmpty((List)paths)) {
                    for (String serverPath : paths) {
                        Stat stat = new Stat();
                        byte[] data = this.client.getData(event.getPath() + "/" + serverPath, true, stat);
                        String dataStr = new String(data);
                        String addressValue = serverPath + dataStr;
                        remoteNodes.add(addressValue);
                        if (notifiedNodes.contains(addressValue)) continue;
                        this.logger.info("path children has been created, path: {}, data: {}", (Object)(event.getPath() + "/" + serverPath), (Object)dataStr);
                        listener.addAddress(addressValue);
                        listener.serverJoinNotify(addressValue);
                    }
                }
                String[] notifiedNodeArray = notifiedNodes.toArray(new String[notifiedNodes.size()]);
                for (int i = notifiedNodeArray.length - 1; i >= 0; --i) {
                    String address = notifiedNodeArray[i];
                    if (!remoteNodes.isEmpty() && remoteNodes.contains(address)) continue;
                    this.logger.info("path children has been remove, path and data: {}", (Object)(event.getPath() + "/" + address));
                    listener.removeAddress(address);
                    listener.serverQuitNotify(address);
                }
            }
            catch (ZookeeperClientException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setClient(Client client) {
        this.client = (ZookeeperClient)client;
    }

    public void start() throws CollectorException {
        for (Map.Entry<String, ModuleRegistration> next : this.registrations.entrySet()) {
            this.createPath(next.getKey());
            ModuleRegistration.Value value = next.getValue().buildValue();
            String contextPath = value.getContextPath() == null ? "" : value.getContextPath();
            this.client.getChildren(next.getKey(), true);
            String serverPath = next.getKey() + "/" + value.getHostPort();
            Stat stat = this.client.exists(serverPath, false);
            if (stat != null) {
                this.client.delete(serverPath, stat.getVersion());
            }
            if ((stat = this.client.exists(serverPath, false)) == null) {
                this.setData(serverPath, contextPath);
                continue;
            }
            this.client.delete(serverPath, stat.getVersion());
            throw new ClusterNodeExistException("current address: " + value.getHostPort() + " has been registered, check the host and port configuration or wait a moment.");
        }
    }

    public void addListener(ClusterModuleListener listener) {
        String path = this.getBaseCatalog() + listener.path();
        this.logger.info("listener path: {}", (Object)path);
        this.listeners.put(path, listener);
    }

    public void register(String path, ModuleRegistration registration) {
        this.registrations.put(this.getBaseCatalog() + path, registration);
    }

    public ClusterModuleListener getListener(String path) {
        path = this.getBaseCatalog() + path;
        return this.listeners.get(path);
    }

    public void createPath(String path) throws ClientException {
        String[] paths = path.replaceFirst("/", "").split("/");
        StringBuilder pathBuilder = new StringBuilder();
        for (String subPath : paths) {
            pathBuilder.append("/").append(subPath);
            if (this.client.exists(pathBuilder.toString(), false) != null) continue;
            this.client.create(pathBuilder.toString(), null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
    }

    public void setData(String path, String value) throws ClientException {
        if (this.client.exists(path, false) == null) {
            this.client.create(path, value.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        } else {
            this.client.setData(path, value.getBytes(), -1);
        }
    }

    public String getBaseCatalog() {
        if (StringUtil.isEmpty((String)this.namespace)) {
            return "/skywalking";
        }
        return "/" + this.namespace + "/skywalking";
    }

    void setNamespace(String namespace) {
        this.namespace = namespace;
    }
}

