/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.collector.cluster.zookeeper;

import org.apache.skywalking.apm.collector.client.Client;
import org.apache.skywalking.apm.collector.client.zookeeper.ZookeeperClient;
import org.apache.skywalking.apm.collector.client.zookeeper.ZookeeperClientException;
import org.apache.skywalking.apm.collector.cluster.ClusterModule;
import org.apache.skywalking.apm.collector.cluster.service.ModuleListenerService;
import org.apache.skywalking.apm.collector.cluster.service.ModuleRegisterService;
import org.apache.skywalking.apm.collector.cluster.zookeeper.ClusterModuleZKConfig;
import org.apache.skywalking.apm.collector.cluster.zookeeper.ClusterZKDataMonitor;
import org.apache.skywalking.apm.collector.cluster.zookeeper.service.ZookeeperModuleListenerService;
import org.apache.skywalking.apm.collector.cluster.zookeeper.service.ZookeeperModuleRegisterService;
import org.apache.skywalking.apm.collector.configuration.service.ICollectorConfig;
import org.apache.skywalking.apm.collector.core.CollectorException;
import org.apache.skywalking.apm.collector.core.UnexpectedException;
import org.apache.skywalking.apm.collector.core.module.ModuleConfig;
import org.apache.skywalking.apm.collector.core.module.ModuleDefine;
import org.apache.skywalking.apm.collector.core.module.ModuleProvider;
import org.apache.skywalking.apm.collector.core.module.Service;
import org.apache.skywalking.apm.collector.core.module.ServiceNotProvidedException;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterModuleZookeeperProvider
extends ModuleProvider {
    private final Logger logger = LoggerFactory.getLogger(ClusterModuleZookeeperProvider.class);
    private final ClusterModuleZKConfig config = new ClusterModuleZKConfig();
    private ZookeeperClient zookeeperClient;
    private ClusterZKDataMonitor dataMonitor;

    public String name() {
        return "zookeeper";
    }

    public Class<? extends ModuleDefine> module() {
        return ClusterModule.class;
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        return this.config;
    }

    public void prepare() throws ServiceNotProvidedException {
        this.dataMonitor = new ClusterZKDataMonitor();
        this.zookeeperClient = new ZookeeperClient(this.config.getHostPort(), this.config.getSessionTimeout(), (Watcher)this.dataMonitor);
        this.dataMonitor.setClient((Client)this.zookeeperClient);
        this.registerServiceImplementation(ModuleListenerService.class, (Service)new ZookeeperModuleListenerService(this.dataMonitor));
        this.registerServiceImplementation(ModuleRegisterService.class, (Service)new ZookeeperModuleRegisterService(this.dataMonitor));
    }

    public void start() {
        this.dataMonitor.setNamespace(((ICollectorConfig)this.getManager().find("configuration").getService(ICollectorConfig.class)).getNamespace());
        try {
            this.zookeeperClient.initialize();
        }
        catch (ZookeeperClientException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void notifyAfterCompleted() {
        try {
            this.dataMonitor.start();
        }
        catch (CollectorException e) {
            throw new UnexpectedException(e.getMessage());
        }
    }

    public String[] requiredModules() {
        return new String[]{"configuration"};
    }
}

