/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.trace.ignore;

import org.apache.skywalking.apm.agent.core.boot.OverrideImplementor;
import org.apache.skywalking.apm.agent.core.boot.ServiceManager;
import org.apache.skywalking.apm.agent.core.conf.dynamic.AgentConfigChangeWatcher;
import org.apache.skywalking.apm.agent.core.conf.dynamic.ConfigurationDiscoveryService;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.sampling.SamplingService;
import org.apache.skywalking.apm.plugin.trace.ignore.TraceIgnorePatternWatcher;
import org.apache.skywalking.apm.plugin.trace.ignore.conf.IgnoreConfig;
import org.apache.skywalking.apm.plugin.trace.ignore.conf.IgnoreConfigInitializer;
import org.apache.skywalking.apm.plugin.trace.ignore.matcher.FastPathMatcher;
import org.apache.skywalking.apm.plugin.trace.ignore.matcher.TracePathMatcher;
import org.apache.skywalking.apm.util.StringUtil;

@OverrideImplementor(value=SamplingService.class)
public class TraceIgnoreExtendService
extends SamplingService {
    private static final ILog LOGGER = LogManager.getLogger(TraceIgnoreExtendService.class);
    private static final String PATTERN_SEPARATOR = ",";
    private TracePathMatcher pathMatcher = new FastPathMatcher();
    private volatile String[] patterns = new String[0];
    private TraceIgnorePatternWatcher traceIgnorePatternWatcher;

    public void prepare() {
        super.prepare();
    }

    public void boot() {
        super.boot();
        IgnoreConfigInitializer.initialize();
        if (StringUtil.isNotEmpty((String)IgnoreConfig.Trace.IGNORE_PATH)) {
            this.patterns = IgnoreConfig.Trace.IGNORE_PATH.split(PATTERN_SEPARATOR);
        }
        this.traceIgnorePatternWatcher = new TraceIgnorePatternWatcher("agent.trace.ignore_path", this);
        ((ConfigurationDiscoveryService)ServiceManager.INSTANCE.findService(ConfigurationDiscoveryService.class)).registerAgentConfigChangeWatcher((AgentConfigChangeWatcher)this.traceIgnorePatternWatcher);
        this.handleTraceIgnorePatternsChanged();
    }

    public void onComplete() {
    }

    public void shutdown() {
        super.shutdown();
    }

    public boolean trySampling(String operationName) {
        if (this.patterns.length > 0) {
            for (String pattern : this.patterns) {
                if (!this.pathMatcher.match(pattern, operationName)) continue;
                LOGGER.debug("operationName : " + operationName + " Ignore tracking");
                return false;
            }
        }
        return super.trySampling(operationName);
    }

    public void forceSampled() {
        super.forceSampled();
    }

    void handleTraceIgnorePatternsChanged() {
        if (StringUtil.isNotBlank((String)this.traceIgnorePatternWatcher.getTraceIgnorePathPatterns())) {
            this.patterns = this.traceIgnorePatternWatcher.getTraceIgnorePathPatterns().split(PATTERN_SEPARATOR);
        }
    }
}

