/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.trace.ignore.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.skywalking.apm.agent.core.boot.AgentPackageNotFoundException;
import org.apache.skywalking.apm.agent.core.boot.AgentPackagePath;
import org.apache.skywalking.apm.agent.core.conf.ConfigNotFoundException;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.plugin.trace.ignore.conf.IgnoreConfig;
import org.apache.skywalking.apm.util.ConfigInitializer;
import org.apache.skywalking.apm.util.PropertyPlaceholderHelper;

public class IgnoreConfigInitializer {
    private static final ILog LOGGER = LogManager.getLogger(IgnoreConfigInitializer.class);
    private static String CONFIG_FILE_NAME = "/config/apm-trace-ignore-plugin.config";
    private static String ENV_KEY_PREFIX = "skywalking.";

    public static void initialize() throws ConfigNotFoundException, AgentPackageNotFoundException {
        try {
            InputStream configFileStream = IgnoreConfigInitializer.loadConfigFromAgentFolder();
            Properties properties = new Properties();
            properties.load(configFileStream);
            PropertyPlaceholderHelper helper = PropertyPlaceholderHelper.INSTANCE;
            for (String key : properties.stringPropertyNames()) {
                String value = (String)properties.get(key);
                properties.put(key, PropertyPlaceholderHelper.INSTANCE.replacePlaceholders(value, properties));
            }
            ConfigInitializer.initialize((Properties)properties, IgnoreConfig.class);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e, "Failed to read the config file, skywalking is going to run in default config.", new Object[0]);
        }
        try {
            IgnoreConfigInitializer.overrideConfigBySystemProp();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e, "Failed to read the system env.", new Object[0]);
        }
    }

    private static void overrideConfigBySystemProp() throws IllegalAccessException {
        Properties properties = new Properties();
        Properties systemProperties = System.getProperties();
        for (Map.Entry<Object, Object> prop : systemProperties.entrySet()) {
            if (!prop.getKey().toString().startsWith(ENV_KEY_PREFIX)) continue;
            String realKey = prop.getKey().toString().substring(ENV_KEY_PREFIX.length());
            properties.put(realKey, prop.getValue());
        }
        if (!properties.isEmpty()) {
            ConfigInitializer.initialize((Properties)properties, IgnoreConfig.class);
        }
    }

    private static InputStream loadConfigFromAgentFolder() throws AgentPackageNotFoundException, ConfigNotFoundException {
        File configFile = new File(AgentPackagePath.getPath(), CONFIG_FILE_NAME);
        if (configFile.exists() && configFile.isFile()) {
            try {
                LOGGER.info("Ignore config file found in {}.", new Object[]{configFile});
                return new FileInputStream(configFile);
            }
            catch (FileNotFoundException e) {
                throw new ConfigNotFoundException("Fail to load apm-trace-ignore-plugin.config", (Throwable)e);
            }
        }
        throw new ConfigNotFoundException("Fail to load ignore config file.");
    }
}

