/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.spring.mvc.commons.interceptor;

import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.spring.mvc.commons.EnhanceRequireObjectCache;

public abstract class AbstractMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    public abstract String getRequestURL(Method var1);

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        Boolean forwardRequestFlag = (Boolean)ContextManager.getRuntimeContext().get((Object)"SW_FORWARD_REQUEST_FLAG");
        if (forwardRequestFlag != null && forwardRequestFlag.booleanValue()) {
            return;
        }
        EnhanceRequireObjectCache pathMappingCache = (EnhanceRequireObjectCache)objInst.getSkyWalkingDynamicField();
        String requestURL = pathMappingCache.findPathMapping(method);
        if (requestURL == null) {
            requestURL = this.getRequestURL(method);
            pathMappingCache.addPathMapping(method, requestURL);
            requestURL = pathMappingCache.findPathMapping(method);
        }
        String hystrixIsolateStrategy = (String)ContextManager.getRuntimeContext().get((Object)"ISOLATE_STRATEGY");
        HttpServletRequest request = (HttpServletRequest)ContextManager.getRuntimeContext().get((Object)"SW_REQUEST");
        if (hystrixIsolateStrategy != null) {
            ContextManager.createLocalSpan((String)requestURL);
        } else if (request != null) {
            ContextCarrier contextCarrier = new ContextCarrier();
            CarrierItem next = contextCarrier.items();
            while (next.hasNext()) {
                next = next.next();
                next.setHeadValue(request.getHeader(next.getHeadKey()));
            }
            AbstractSpan span = ContextManager.createEntrySpan((String)requestURL, (ContextCarrier)contextCarrier);
            Tags.URL.set(span, request.getRequestURL().toString());
            Tags.HTTP.METHOD.set(span, request.getMethod());
            span.setComponent((Component)ComponentsDefine.SPRING_MVC_ANNOTATION);
            SpanLayer.asHttp((AbstractSpan)span);
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        Boolean forwardRequestFlag = (Boolean)ContextManager.getRuntimeContext().get((Object)"SW_FORWARD_REQUEST_FLAG");
        if (forwardRequestFlag != null && forwardRequestFlag.booleanValue()) {
            return ret;
        }
        String hystrixIsolateStrategy = (String)ContextManager.getRuntimeContext().get((Object)"ISOLATE_STRATEGY");
        HttpServletResponse response = (HttpServletResponse)ContextManager.getRuntimeContext().get((Object)"SW_RESPONSE");
        if (hystrixIsolateStrategy != null) {
            ContextManager.stopSpan();
        } else if (response != null) {
            AbstractSpan span = ContextManager.activeSpan();
            if (response.getStatus() >= 400) {
                span.errorOccurred();
                Tags.STATUS_CODE.set(span, Integer.toString(response.getStatus()));
            }
            ContextManager.stopSpan();
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().errorOccurred().log(t);
    }
}

